/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.directory.DirectorySession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.bpm.compiler.AbstractRunningMonitor;
import oracle.bpm.compiler.BasicDebuggerHandler;
import oracle.bpm.compiler.BreakPoint;
import oracle.bpm.compiler.CodeRunner;
import oracle.bpm.compiler.CompilerParserException;
import oracle.bpm.compiler.ConditionalBreakPoint;
import oracle.bpm.compiler.DebuggerActionManager;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.ExecutionInterruptedException;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.FuegoInvokeable;
import oracle.bpm.compiler.InvalidLanguageException;
import oracle.bpm.compiler.InvokeMethodBreakPoint;
import oracle.bpm.compiler.LineBreakPoint;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.StackFrame;
import oracle.bpm.compiler.StackOverflowException;
import oracle.bpm.compiler.Watch;
import oracle.bpm.connector.ConnectorTransaction;
import oracle.bpm.lang.DefaultEnvironment;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.SourceCode;

public class CodeDebugger {
    private DebuggerActionManager actionMgr = new DebuggerActionManager();
    private String activity;
    private BreakPointHandler bpHandler;
    private boolean commit;
    private Compiler compiler;
    private DefaultEnvironment environment;
    private ErrorListener errorListener;
    private ExceptionHandler exHandler;
    private List<BreakPoint> exprbp;
    private FuegoInvokeable invokeable;
    private ExecutionException lastHandled;
    private int level;
    private List<LineBreakPoint> linebp;
    private String method;
    private List<InvokeMethodBreakPoint> methodbp;
    private RunningMonitor monitor;
    private String participant;
    private String process;
    private CodeRunner runner;
    private DirectorySession session;
    private CILSource source;
    private StackTraceList stackTrace;
    private StatusListener[] statusListeners;
    private FuegoCompiler validator;
    private List<Watch> watches;
    private WatchHandler wpHandler;

    public CodeDebugger() {
        this.addStatusListener(this.actionMgr);
        BasicDebuggerHandler basicHandler = new BasicDebuggerHandler();
        this.exHandler = basicHandler;
        this.bpHandler = basicHandler;
        this.wpHandler = basicHandler;
        this.stackTrace = basicHandler;
        this.source = basicHandler;
        this.linebp = new ArrayList<LineBreakPoint>();
        this.exprbp = new ArrayList<BreakPoint>();
        this.methodbp = new ArrayList<InvokeMethodBreakPoint>();
        this.watches = new ArrayList<Watch>();
    }

    public DebuggerActionManager getActionManager() {
        return this.actionMgr;
    }

    public void setBreakPointHandler(BreakPointHandler handler) {
        this.bpHandler = handler;
    }

    public void setCILSource(CILSource source) {
        this.source = source;
    }

    public void setCommit(boolean commit) {
        this.commit = commit;
        CodeRunner runner = this.runner;
        if (runner != null) {
            runner.setCommit(commit);
        }
    }

    public void setCompiler(Compiler compiler) {
        this.compiler = compiler;
    }

    public void setDirectorySession(DirectorySession directorySession) {
        this.session = directorySession;
    }

    public void setEnvironment(DefaultEnvironment environment) {
        this.environment = environment;
    }

    public void setErrorListener(ErrorListener listener) {
        assert (listener != null);
        this.errorListener = listener;
    }

    public void setExceptionHandler(ExceptionHandler handler) {
        this.exHandler = handler;
    }

    public void setInvokeable(FuegoInvokeable invokeable) {
        invokeable.removeAllWatches();
        this.invokeable = invokeable;
    }

    public void setMainMethod(String methodSignature) {
        this.method = methodSignature;
    }

    public void setParticipant(String participant) {
        this.participant = participant;
    }

    public void setActivity(String activity) {
        this.activity = activity;
    }

    public void setProcess(String process) {
        this.process = process;
    }

    public void setMonitor(RunningMonitor monitor) {
        this.monitor = monitor;
    }

    public RunningMonitor getMonitor() {
        return this.monitor;
    }

    public synchronized boolean isRunning() {
        return this.runner != null;
    }

    public void setStackTraceList(StackTraceList stack) {
        this.stackTrace = stack;
    }

    public void setWatchHandler(WatchHandler handler) {
        this.wpHandler = handler;
    }

    public void addBreakPoint(BreakPoint bp) throws CompilerParserException, InvalidLanguageException {
        if (bp instanceof LineBreakPoint) {
            LineBreakPoint lbp = (LineBreakPoint)bp;
            this.linebp.add(lbp);
        } else if (bp instanceof InvokeMethodBreakPoint) {
            this.methodbp.add((InvokeMethodBreakPoint)bp);
        } else if (bp instanceof ConditionalBreakPoint) {
            ConditionalBreakPoint cbp = (ConditionalBreakPoint)bp;
            this.getValidator().parse(SourceCode.create(cbp.getText(), "Fuego"));
            this.exprbp.add(bp);
        }
        CodeRunner runner = this.runner;
        if (runner != null) {
            runner.addBreakPoint(bp);
        }
    }

    public BreakPoint addExpressionBreakPoint(String expression) throws CompilerParserException, InvalidLanguageException {
        this.getValidator().parse(SourceCode.create(expression, "Fuego"));
        ConditionalBreakPoint bp = new ConditionalBreakPoint(expression);
        this.exprbp.add(bp);
        return bp;
    }

    public BreakPoint addMethodBreakPoint(String component, String method) {
        InvokeMethodBreakPoint bp = new InvokeMethodBreakPoint(component, method);
        this.methodbp.add(bp);
        return bp;
    }

    public void addStatusListener(StatusListener listener) {
        if (this.statusListeners == null) {
            this.statusListeners = new StatusListener[]{listener};
        } else {
            int length = this.statusListeners.length;
            this.statusListeners = Arrays.copyOf(this.statusListeners, length + 1);
            this.statusListeners[length] = listener;
        }
    }

    public void addWatch(Watch watch) throws CompilerParserException, InvalidLanguageException {
        this.getValidator().parse(SourceCode.create(watch.getText(), "Fuego"));
        this.watches.add(watch);
        CodeRunner runner = this.runner;
        if (runner != null) {
            runner.addWatch(watch);
        }
    }

    public CodeRunner.DebuggerRunnable beginDebugging() {
        CodeRunner.DebuggerRunnable debuggerRunnable = null;
        if (this.initialize()) {
            debuggerRunnable = this.runner.createDebuggerRunnable();
        }
        return debuggerRunnable;
    }

    public synchronized void exit() {
        if (this.runner == null) {
            return;
        }
        this.runner.exit();
        try {
            if (ConnectorTransaction.hasCurrent()) {
                ConnectorTransaction.current().commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void ignoreStep() {
        if (this.runner == null) {
            return;
        }
        this.runner.skipStep();
    }

    public void removeAllBreakPoints() {
        CodeRunner runner = this.runner;
        if (runner != null) {
            for (int i = 0; i < this.linebp.size(); ++i) {
                runner.removeBreakPoint(this.linebp.get(i));
            }
        }
        this.linebp.clear();
    }

    public void removeBreakPoint(BreakPoint bp) {
        if (bp instanceof LineBreakPoint) {
            LineBreakPoint lbp = (LineBreakPoint)bp;
            this.linebp.remove(lbp);
            this.source.removeBreakPoint(lbp);
        } else if (bp instanceof ConditionalBreakPoint) {
            this.exprbp.remove(bp);
        } else {
            InvokeMethodBreakPoint mbp = (InvokeMethodBreakPoint)bp;
            this.methodbp.remove(mbp);
        }
        CodeRunner runner = this.runner;
        if (runner != null) {
            runner.removeBreakPoint(bp);
        }
    }

    public void removeWatch(Watch watch) {
        this.watches.remove(watch);
        CodeRunner runner = this.runner;
        if (runner != null) {
            runner.removeWatch(watch);
        }
    }

    public synchronized void run() {
        this.notifyStatusRunning();
        this.source.requestFocus();
        this.runner.resume();
    }

    public synchronized void stepOver() {
        this.notifyStatusStepping();
        this.source.requestFocus();
        this.runner.stepOver();
    }

    public synchronized void stepInto() {
        this.notifyStatusStepping();
        this.source.requestFocus();
        this.runner.stepInto();
    }

    public synchronized void stepOut() {
        this.notifyStatusStepping();
        this.source.requestFocus();
        this.runner.stepOut();
    }

    public synchronized void stop() {
        this.notifyStatusStopped();
        if (this.runner == null) {
            return;
        }
        this.runner.terminate();
        this.runner = null;
    }

    public synchronized void suspend() {
        if (this.runner == null) {
            return;
        }
        this.notifyStatusStepping();
        this.runner.suspend();
    }

    public LineBreakPoint toggleLineBreakPoint(LineBreakPoint bp) {
        CodeRunner runner = this.runner;
        if (this.linebp.contains(bp)) {
            bp = this.linebp.remove(this.linebp.indexOf(bp));
            this.source.removeBreakPoint(bp);
            if (runner != null) {
                runner.removeBreakPoint(bp);
            }
            return bp;
        }
        this.source.addBreakPoint(bp);
        this.linebp.add(bp);
        if (runner != null) {
            runner.addBreakPoint(bp);
        }
        return null;
    }

    protected RunningMonitor createRunningMonitor() {
        CILRunningMonitor monitor = new CILRunningMonitor();
        RunningMonitor delegate = this.getMonitor();
        if (delegate != null) {
            monitor.setDelegate(delegate);
        }
        return monitor;
    }

    private FuegoCompiler getValidator() {
        if (this.validator == null) {
            this.validator = new FuegoCompiler();
        }
        return this.validator;
    }

    private void checkRunner() {
        if (this.runner == null) {
            this.resetWatches();
            this.runner = new CodeRunner(this.invokeable, this.method, this.participant, this.activity, this.process, null);
            this.init(this.runner);
            this.runner.setRunningMonitor(this.createRunningMonitor());
        }
    }

    private void init(CodeRunner runner) {
        runner.setCommit(this.commit);
        for (Watch watch : this.watches) {
            runner.addWatch(watch);
        }
        for (BreakPoint breakPoint : this.exprbp) {
            runner.addBreakPoint(breakPoint);
        }
        for (LineBreakPoint lineBreakPoint : this.linebp) {
            runner.addBreakPoint(lineBreakPoint);
        }
        runner.setDirectorySession(this.session);
        runner.setEnvironment(this.environment);
    }

    private synchronized boolean initialize() {
        if (!this.isRunning()) {
            this.invokeable = this.compiler.compile();
            if (this.invokeable == null) {
                return false;
            }
        }
        this.checkRunner();
        return true;
    }

    private void notifyStatusRunning() {
        if (this.statusListeners != null) {
            for (int i = 0; i < this.statusListeners.length; ++i) {
                StatusListener listener = this.statusListeners[i];
                listener.running();
            }
        }
    }

    private void notifyStatusStepping() {
        if (this.statusListeners != null) {
            for (int i = 0; i < this.statusListeners.length; ++i) {
                StatusListener listener = this.statusListeners[i];
                listener.stepping();
            }
        }
    }

    private void notifyStatusStopped() {
        if (this.statusListeners != null) {
            for (int i = 0; i < this.statusListeners.length; ++i) {
                StatusListener listener = this.statusListeners[i];
                listener.stopped();
            }
        }
    }

    private void resetWatches() {
        for (Watch watch : this.watches) {
            watch.reset();
            try {
                this.wpHandler.updateWatch(watch);
            }
            catch (ExecutionException executionException) {}
        }
    }

    public class CILRunningMonitor
    extends AbstractRunningMonitor {
        private RunningMonitor delegate;
        private static final int STACK_SIZE = 75;

        public void setDelegate(RunningMonitor delegate) {
            this.delegate = delegate;
        }

        public RunningMonitor getDelegate() {
            return this.delegate;
        }

        @Override
        public void beginEvent(MethodTypeDescription method) throws ExecutionException {
            if (CodeDebugger.this.level > 75) {
                throw new StackOverflowException(null, method.getName());
            }
            CodeDebugger.this.stackTrace.pushFrame(new StackFrame(method.getParent(), method));
            CodeDebugger.this.level++;
            RunningMonitor delegate = this.getDelegate();
            if (delegate != null) {
                delegate.beginEvent(method);
            }
        }

        @Override
        public void breakPointEvent(BreakPoint bp) throws ExecutionException {
            CodeDebugger.this.notifyStatusStepping();
            CodeDebugger.this.bpHandler.handleBreakPoint(bp);
            RunningMonitor delegate = this.getDelegate();
            if (delegate != null) {
                delegate.breakPointEvent(bp);
            }
        }

        @Override
        public boolean enableEvents(boolean enable) {
            RunningMonitor delegate = this.getDelegate();
            if (delegate != null) {
                delegate.enableEvents(enable);
            }
            return true;
        }

        @Override
        public void endEvent(MethodTypeDescription member) throws ExecutionException {
            CodeDebugger.this.stackTrace.popFrame();
            CodeDebugger.this.level--;
            CodeDebugger.this.source.selectLine(-1);
            RunningMonitor delegate = this.getDelegate();
            if (delegate != null) {
                delegate.endEvent(member);
            }
        }

        @Override
        public void exceptionEvent(ExecutionException e) throws ExecutionException {
            RunningMonitor delegate;
            if (e == CodeDebugger.this.lastHandled) {
                if (CodeDebugger.this.errorListener != null) {
                    CodeDebugger.this.errorListener.reportException(e);
                }
            } else {
                CodeDebugger.this.lastHandled = e;
                CodeDebugger.this.exHandler.handleException(e);
            }
            if ((delegate = this.getDelegate()) != null) {
                delegate.exceptionEvent(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finishEvent() {
            CILRunningMonitor cILRunningMonitor = this;
            synchronized (cILRunningMonitor) {
                CodeDebugger.this.notifyStatusStopped();
                CodeDebugger.this.runner = null;
            }
            RunningMonitor delegate = this.getDelegate();
            if (delegate != null) {
                delegate.finishEvent();
            }
        }

        @Override
        public void stepEvent(int line, int column) throws ExecutionInterruptedException {
            CodeDebugger.this.source.selectLine(line);
            RunningMonitor delegate = this.getDelegate();
            if (delegate != null) {
                try {
                    delegate.stepEvent(line, column);
                }
                catch (ExecutionException e) {
                    // empty catch block
                }
            }
        }

        @Override
        public void watchEvent(Watch wp) throws ExecutionException {
            CodeDebugger.this.wpHandler.updateWatch(wp);
            RunningMonitor delegate = this.getDelegate();
            if (delegate != null) {
                delegate.watchEvent(wp);
            }
        }

        @Override
        public void suspendEvent() throws ExecutionException {
        }

        @Override
        public void resumeEvent() throws ExecutionException {
        }

        @Override
        public void popVariable(String name) {
        }

        @Override
        public void pushVariable(String name, TypeDescription type, Object value) {
        }
    }

    public static interface WatchHandler {
        public void updateWatch(Watch var1) throws ExecutionException;
    }

    public static interface StatusListener {
        public void running();

        public void stepping();

        public void stopped();
    }

    public static interface StackTraceList {
        public void popFrame();

        public void pushFrame(StackFrame var1);
    }

    public static interface ExceptionHandler {
        public void handleException(ExecutionException var1) throws ExecutionException;
    }

    public static interface ErrorListener {
        public void reportException(ExecutionException var1);
    }

    public static interface Compiler {
        public FuegoInvokeable compile();
    }

    public static interface CILSource {
        public void addBreakPoint(LineBreakPoint var1);

        public void removeAllBreakpoints();

        public void removeBreakPoint(LineBreakPoint var1);

        public void requestFocus();

        public void selectLine(int var1);
    }

    public static interface BreakPointHandler {
        public void handleBreakPoint(BreakPoint var1) throws ExecutionException;
    }
}

