/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.bcgen.JVMCodeBuilder;
import fuego.bcgen.LocalVariable;
import fuego.bcgen.MethodD;
import fuego.bcgen.TD;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.JVMByteCodeGenerator;
import oracle.bpm.compiler.MDKit;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.TDKit;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeFactory;
import org.apache.bcel.generic.Type;

public class ClientStubGenerator {
    static void generateClientStub(JVMByteCodeGenerator cg, Method method) throws CodeGenerationException {
        Type[] methodParameterTypes;
        int argc = method.getMethodType().getArgumentCount();
        JVMCodeBuilder cb = cg.getCodeBuilder();
        cb.beginIf();
        cb.invoke(MDKit.IS_NOT_RUNNING_ON_SERVER);
        cb.addThen();
        cb.loadThis();
        cb.loadConstant(method.getJavaSignature());
        cb.loadConstant(method.isStatic());
        if (argc == 0) {
            cb.loadNull();
        } else {
            ClientStubGenerator.generateInputArgsAsArray(cb, method, true);
        }
        Object[] outputArguments = method.outputArgumentsRequest();
        if (outputArguments == null) {
            methodParameterTypes = new Type[]{TD.STRING, TD.BOOLEAN, TD.OBJECT_ARRAY};
        } else {
            methodParameterTypes = new Type[]{TD.STRING, TD.BOOLEAN, TD.OBJECT_ARRAY, TD.OBJECT_ARRAY};
            cb.createArray(TD.OBJECT_ARRAY, outputArguments);
        }
        cb.invoke(MethodD.create((Type)TD.OBJECT_ARRAY, cg.getClassCode().getType(), "xoInvoke", methodParameterTypes));
        LocalVariable result = cb.createLocalVariable("result", (Type)TD.OBJECT_ARRAY);
        cb.storeLocal(result);
        ClientStubGenerator.generateReturnFromArray(result, (String[])outputArguments, cb, method);
        cb.endIf();
    }

    private static void generateArgumentExtraction(TypeDescription argType, JVMCodeBuilder cb, int argn) {
        cb.loadConstant(argn);
        cb.arrayLoad();
        ClientStubGenerator.generateCast(TypeFactory.getAny(), argType, cb);
    }

    private static void generateCast(TypeDescription sourceType, TypeDescription targetType, JVMCodeBuilder cb) {
        if (sourceType.isPrimitive() == targetType.isPrimitive()) {
            cb.convert(TD.valueOf(targetType));
        } else {
            cb.invoke(MDKit.conversionMethod(sourceType, targetType));
        }
    }

    private static void generateArgumentReference(JVMCodeBuilder cb, Method method, Argument arg) {
        TypeDescription argType = arg.getType();
        cb.loadArgument(arg.getNumber());
        if (arg.isOut()) {
            Type argumentType = TD.valueOf(method.argumentType(arg));
            cb.loadField(TDKit.valueField(argumentType));
        }
        if (argType.isPrimitive()) {
            TypeDescription targetType = argType.primitiveEquivalent(false);
            TypeDescription argRealType = arg.isIn() && !arg.isOut() ? argType : argType.getHolderType();
            cb.invoke(MDKit.conversionMethod(argRealType, targetType));
        }
    }

    private static void generateInputArgsAsArray(JVMCodeBuilder cb, Method method, boolean addSignatures) {
        MethodTypeDescription methodType = method.getMethodType();
        int arrayIndex = 0;
        int argumentCount = methodType.getArgumentCount();
        cb.createArray(TD.OBJECT_ARRAY, addSignatures ? argumentCount * 2 : argumentCount);
        for (int i = 0; i < argumentCount; ++i) {
            if (addSignatures) {
                cb.dup();
                cb.loadConstant(arrayIndex);
                cb.loadConstant("#" + i);
                cb.arrayStore();
                ++arrayIndex;
            }
            cb.dup();
            cb.loadConstant(arrayIndex);
            ClientStubGenerator.generateArgumentReference(cb, method, methodType.getArgument(i));
            cb.arrayStore();
            ++arrayIndex;
        }
    }

    private static void generateReturnFromArray(LocalVariable result, String[] outputArguments, JVMCodeBuilder cb, Method method) {
        TypeDescription resultType;
        if (outputArguments != null) {
            MethodTypeDescription member = method.getMethodType();
            int argc = member.getArgumentCount();
            int argn = 0;
            for (int i = 0; i < argc; ++i) {
                Argument arg = member.getArgument(i);
                if (!arg.isOut()) continue;
                String argType = method.argumentType(arg);
                cb.loadArgument(i);
                cb.loadLocal(result);
                ClientStubGenerator.generateArgumentExtraction(arg.getType().getHolderType(), cb, ++argn);
                cb.storeField(TDKit.valueField(TD.valueOf(argType)));
            }
        }
        if (!(resultType = method.getResultType()).isVoid()) {
            cb.loadLocal(result);
            ClientStubGenerator.generateArgumentExtraction(resultType, cb, 0);
        }
        cb.retrn();
    }
}

