/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import oracle.bpm.compiler.CompilerExceptionShell;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.ConstGenerator;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.TypeDescription;

public class ClassConst
extends Const {
    private String javaType;
    private static TypeDescription JAVA_LANG_CLASS;
    static final long serialVersionUID = 4375856523182571504L;
    static final long serialCheck = 5240753880846757764L;

    ClassConst(TypeDescription type, Node init) {
        this(type.isInvokeable() ? Invokeable.class.getName() : type.getJavaType(), init);
    }

    ClassConst(String javaType, Node init) {
        this.setParent(init);
        try {
            if (JAVA_LANG_CLASS == null) {
                JAVA_LANG_CLASS = init.findType("Java.Lang.Class");
            }
            this.setTypeDescription(JAVA_LANG_CLASS);
        }
        catch (TypeException e) {
            init.reportError(e);
        }
        this.javaType = javaType;
        this.initialize(init);
    }

    @Override
    public String getText() {
        return this.javaType;
    }

    public String getTypeToCast() {
        return this.javaType;
    }

    @Override
    public void generate(ConstGenerator cg) {
        cg.generate(this);
    }

    @Override
    public void generate(SourceGenerator cg) {
    }

    final boolean equals(Node b) {
        ClassConst cc = b instanceof ClassConst ? (ClassConst)b : null;
        return cc != null && this.javaType.equals(cc.javaType);
    }

    @Override
    boolean isCollectable() {
        return false;
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        return this.run(rm, true);
    }

    Object run(RunningMonitor rm, boolean failIfClassNotFound) throws ExecutionException {
        Class<?> cl;
        block2: {
            cl = null;
            try {
                cl = JavaClass.loadByJavaType(this.javaType);
            }
            catch (ClassNotFoundException e) {
                if (!failIfClassNotFound) break block2;
                throw new CompilerExceptionShell((Node)this, (Throwable)e);
            }
        }
        return cl;
    }
}

