/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.Diadic;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.MemberReference;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.Scope;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.sql.ColumnReference;

public class Alias
extends Diadic {
    private ColumnReference columnReference;
    static final long serialVersionUID = -5391973359970650570L;
    static final long serialCheck = 4034936251336083623L;

    public Alias(Token t) {
        super(t);
    }

    Alias() {
    }

    Alias(Node expr, String name) {
        boolean condition;
        boolean bl = condition = !(expr instanceof MemberReference);
        assert (condition);
        this.setFirst(expr);
        Scope scp = expr.getScope();
        expr.setNext(new Identifier(name, scp));
        this.initialize(expr);
    }

    @Override
    public String getText() {
        return "as";
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this, this.getOp1(), this.getOp2());
    }

    @Override
    void setColumnReference(ColumnReference columnReference) {
        this.columnReference = columnReference;
    }

    @Override
    ColumnReference getColumnReference() {
        return this.columnReference;
    }

    String getName() {
        return this.getOp2() != null ? this.getOp2().getText() : "";
    }

    @Override
    Node checkType() throws TypeException {
        if (this.getKind() != -1) {
            return this;
        }
        Node op = this.getOp1();
        Node id = this.getOp2();
        op = op.checkType();
        this.getSymbolTable().push(id.getText(), op.getTypeDescription());
        this.setTypeDescription(op.getTypeDescription());
        this.setOperands(op, id);
        ColumnReference ref = op.getColumnReference();
        if (ref != null) {
            String signature = id.getText();
            this.setColumnReference(ref.rename(id.getText(), signature));
        } else {
            this.setColumnReference(new ColumnReference(op.getTypeDescription(), id.getText(), 8L));
        }
        return this;
    }

    @Override
    void generateSQLCode(StringBuffer sql) {
        this.getOp1().generateSQLCode(sql);
        sql.append(" AS ");
        this.getOp2().generateSQLCode(sql);
    }
}

