/*
 * Decompiled with CFR 0.152.
 */
package fuego.debugger;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequestManager;
import fuego.debugger.Breakpoint;
import fuego.debugger.DebugSession;
import fuego.debugger.LineBreakpoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.bpm.lang.MethodTypeDescription;
import org.jetbrains.annotations.NotNull;

public class BreakpointManager {
    private final Map<String, List<Breakpoint>> breakpoints = new HashMap<String, List<Breakpoint>>();
    private final Object lock = new Object();
    private DebugSession session;

    public void attach(DebugSession session) {
        if (this.session != null) {
            throw new IllegalStateException("already attached");
        }
        if (session == null) {
            throw new IllegalArgumentException("session is not optional");
        }
        this.session = session;
        session.addBreakpointManager(this);
        if (session.isConnected()) {
            this.connected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach() {
        DebugSession session = this.session;
        if (session == null) {
            throw new IllegalStateException("no session attached");
        }
        EventRequestManager requestManager = session.getRequestManager();
        session.removeBreakpointManager(this);
        Object object = this.lock;
        synchronized (object) {
            for (List<Breakpoint> breakpoints : this.breakpoints.values()) {
                for (Breakpoint breakpoint : breakpoints) {
                    breakpoint.detach(requestManager);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLineBreakpoint(@NotNull LineBreakpoint lineBreakpoint) {
        if (lineBreakpoint == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of fuego/debugger/BreakpointManager.removeLineBreakpoint must not be null");
        }
        String relatedClass = lineBreakpoint.getRelatedClass();
        Object object = this.lock;
        synchronized (object) {
            List<Breakpoint> breakpointList = this.breakpoints.get(relatedClass);
            if (breakpointList == null) {
                return;
            }
            EventRequestManager requestManager = this.session.getRequestManager();
            Iterator<Breakpoint> it = breakpointList.iterator();
            while (it.hasNext()) {
                Breakpoint breakpoint = it.next();
                if (!lineBreakpoint.equals(breakpoint)) continue;
                breakpoint.detach(requestManager);
                it.remove();
            }
            if (breakpointList.isEmpty()) {
                this.breakpoints.remove(relatedClass);
            }
        }
    }

    public LineBreakpoint createLineBreakpoint(MethodTypeDescription method, int line) {
        LineBreakpoint lineBreakpoint = new LineBreakpoint(method, line);
        this.bind(lineBreakpoint);
        return lineBreakpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connected() {
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry<String, List<Breakpoint>> entry : this.breakpoints.entrySet()) {
                String className = entry.getKey();
                List<Breakpoint> breakpoints = entry.getValue();
                this.bindByClass(className, breakpoints);
            }
        }
    }

    List<Breakpoint> findBreakpoint(BreakpointEvent event) {
        ArrayList<Breakpoint> result = new ArrayList<Breakpoint>();
        List<Breakpoint> breakpointList = this.breakpoints.get(event.location().declaringType().name());
        for (Breakpoint breakpoint : breakpointList) {
            for (BreakpointRequest request : breakpoint.getRequests()) {
                if (!((Object)request.location()).equals(event.location())) continue;
                result.add(breakpoint);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindType(ReferenceType referenceType) {
        Object object = this.lock;
        synchronized (object) {
            List<Breakpoint> breakpoints = this.breakpoints.get(referenceType.name());
            if (breakpoints != null) {
                this.bindAll(referenceType, breakpoints);
            }
        }
    }

    private static Location getFirstLocation(Method method, int line) {
        Location location;
        try {
            List<Location> locations = method.locationsOfLine(line);
            location = locations.isEmpty() ? null : locations.get(0);
        }
        catch (AbsentInformationException e) {
            location = null;
        }
        return location;
    }

    private void bindByClass(String className, List<Breakpoint> breakpoints) {
        List<ReferenceType> classes = this.session.getVirtualMachine().classesByName(className);
        for (ReferenceType referenceType : classes) {
            this.bindAll(referenceType, breakpoints);
        }
    }

    private void bindAll(ReferenceType referenceType, List<Breakpoint> breakpoints) {
        for (Breakpoint breakpoint : breakpoints) {
            Breakpoint.Type breakpointType = breakpoint.getType();
            List<Method> methods = referenceType.methodsByName(breakpoint.getMethodName(), breakpoint.getMethodSignature());
            for (Method method : methods) {
                if (breakpointType == Breakpoint.Type.LINE || breakpointType == Breakpoint.Type.CONDITIONAL) {
                    int line = ((LineBreakpoint)breakpoint).getLine();
                    Location location = BreakpointManager.getFirstLocation(method, line);
                    if (location == null) continue;
                    BreakpointRequest request = this.session.getRequestManager().createBreakpointRequest(location);
                    request.setSuspendPolicy(2);
                    request.enable();
                    breakpoint.addBreakpointRequest(request);
                    continue;
                }
                if (breakpointType == Breakpoint.Type.METHOD) continue;
                throw new IllegalStateException("unexpected breakpoint type: " + (Object)((Object)breakpointType));
            }
        }
    }

    private void bind(Breakpoint breakpoint) {
        this.addUnbound(breakpoint);
        if (this.session != null) {
            this.bindByClass(breakpoint.getRelatedClass(), Collections.singletonList(breakpoint));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUnbound(Breakpoint breakpoint) {
        Object object = this.lock;
        synchronized (object) {
            String relatedClass = breakpoint.getRelatedClass();
            List<Breakpoint> breakpointsByClass = this.breakpoints.get(relatedClass);
            if (breakpointsByClass == null) {
                breakpointsByClass = new ArrayList<Breakpoint>();
                this.breakpoints.put(relatedClass, breakpointsByClass);
            }
            breakpointsByClass.add(breakpoint);
        }
    }
}

