/*
 * Decompiled with CFR 0.152.
 */
package fuego.debugger;

import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequestManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import oracle.bpm.lang.MethodTypeDescription;

public abstract class Breakpoint {
    private final MethodTypeDescription method;
    private String methodName;
    private String methodSignature;
    private final Set<BreakpointRequest> requests;

    protected Breakpoint(MethodTypeDescription method) {
        this.method = method;
        this.requests = new HashSet<BreakpointRequest>();
    }

    public abstract Type getType();

    public String toString() {
        return "Breakpoint{method=" + this.method + '}';
    }

    public MethodTypeDescription getMethod() {
        return this.method;
    }

    public Set<BreakpointRequest> getRequests() {
        return Collections.unmodifiableSet(this.requests);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Breakpoint other = (Breakpoint)obj;
        String signature = this.getMethodSignature();
        String otherSignature = other.getMethodSignature();
        return signature == null ? otherSignature == null : signature.equals(otherSignature);
    }

    public int hashCode() {
        return this.getMethodSignature().hashCode();
    }

    String getRelatedClass() {
        return this.method.getParent().getJavaType();
    }

    String getMethodSignature() {
        this.initSignature();
        return this.methodSignature;
    }

    void addBreakpointRequest(BreakpointRequest request) {
        this.requests.add(request);
    }

    String getMethodName() {
        this.initSignature();
        return this.methodName;
    }

    void detach(EventRequestManager eventRequestManager) {
        Set<BreakpointRequest> requests = this.requests;
        eventRequestManager.deleteEventRequests(new ArrayList<BreakpointRequest>(requests));
        requests.clear();
    }

    private void initSignature() {
        if (this.methodSignature == null) {
            String name;
            String signature = this.method.getJavaSignature();
            char marker = signature.charAt(0);
            int argStart = signature.indexOf(40);
            if (marker == 'K') {
                name = "<init>";
            } else if (marker == 'M') {
                name = signature.substring(1, argStart);
            } else {
                throw new IllegalStateException("unexpected signature: " + signature);
            }
            this.methodName = name;
            this.methodSignature = signature.substring(argStart).replace('.', '/');
        }
    }

    public static enum Type {
        LINE,
        CONDITIONAL,
        METHOD;

    }
}

