/*
 * Decompiled with CFR 0.152.
 */
package fuego.bcgen;

import fuego.bcgen.TryBlock;
import java.util.ArrayList;

class TryBlockStack {
    private ArrayList<TryBlock> stack;
    private TryBlock topFinally;
    private static final String EMPTY_MSG = "Not currently active try block";

    TryBlockStack() {
    }

    public void callFinally() {
        if (this.hasFinally()) {
            this.topFinally.callFinally();
        }
    }

    boolean hasFinally() {
        return this.topFinally != null;
    }

    boolean isEmpty() {
        return this.stack == null || this.stack.isEmpty();
    }

    TryBlock pop() {
        if (this.isEmpty()) {
            throw new IllegalStateException(EMPTY_MSG);
        }
        TryBlock result = this.stack.remove(this.stack.size() - 1);
        this.topFinally = null;
        for (int last = this.stack.size() - 1; last > 0; --last) {
            TryBlock tryBlock = this.stack.get(last);
            if (!tryBlock.hasFinally()) continue;
            this.topFinally = tryBlock;
        }
        return result;
    }

    void push(TryBlock tryBlock) {
        if (this.stack == null) {
            this.stack = new ArrayList(5);
        }
        if (tryBlock.hasFinally()) {
            this.topFinally = tryBlock;
        }
        this.stack.add(tryBlock);
    }

    TryBlock top() {
        if (this.isEmpty()) {
            throw new IllegalStateException(EMPTY_MSG);
        }
        return this.stack.get(this.stack.size() - 1);
    }
}

