/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.client.impl;

import oracle.bpel.services.workflow.activityguide.query.IAGQueryService;
import oracle.bpel.services.workflow.client.RemoteWorkflowServiceClient;
import oracle.bpel.services.workflow.runtimeconfig.IRuntimeConfigService;
import oracle.bpel.services.workflow.user.IUserMetadataService;
import oracle.bpm.client.BPMServiceClientContext;
import oracle.bpm.client.internal.processmodel.ProcessModelServiceRemoteClient;
import oracle.bpm.services.client.IBPMServiceClient;
import oracle.bpm.services.common.exception.BPMRuntimeException;
import oracle.bpm.services.instancemanagement.IInstanceManagementService;
import oracle.bpm.services.instancequery.IInstanceQueryService;
import oracle.bpm.services.internal.processmodel.IProcessModelService;
import oracle.bpm.services.internal.processmodel.ejb.IProcessModelServiceRemote;
import oracle.bpm.services.organization.IBPMOrganizationService;
import oracle.bpm.services.processdashboard.IProcessDashboardService;
import oracle.bpm.services.processmetadata.IProcessMetadataService;

public class BPMServiceRemoteClient
implements IBPMServiceClient {
    BPMServiceClientContext context = null;

    public BPMServiceRemoteClient(BPMServiceClientContext context) {
        this.context = context;
    }

    @Override
    public IUserMetadataService getUserMetadataService() {
        return new RemoteWorkflowServiceClient(this.context.getWorkflowServiceClientContext()).getUserMetadataService();
    }

    @Override
    public IRuntimeConfigService getRuntimeConfigService() {
        return new RemoteWorkflowServiceClient(this.context.getWorkflowServiceClientContext()).getRuntimeConfigService();
    }

    @Override
    public IAGQueryService getAGQueryService() {
        return new RemoteWorkflowServiceClient(this.context.getWorkflowServiceClientContext()).getAGQueryService();
    }

    @Override
    public IProcessMetadataService getProcessMetadataService() {
        try {
            IProcessMetadataService service = (IProcessMetadataService)this.context.getJNDIInitialContext().lookup("ejb/bpm/services/ProcessMetadataServiceBean");
            return service;
        }
        catch (Exception exc) {
            Object[] obj = new String[]{"remote", "ProcessMetadataService"};
            throw new BPMRuntimeException(70203, obj, exc);
        }
    }

    @Override
    public IProcessModelService getProcessModelService() {
        try {
            IProcessModelServiceRemote remoteStub = (IProcessModelServiceRemote)this.context.getJNDIInitialContext().lookup("ejb/bpm/services/ProcessModelServiceBean");
            ProcessModelServiceRemoteClient remoteClient = new ProcessModelServiceRemoteClient(remoteStub);
            return remoteClient;
        }
        catch (Exception exc) {
            Object[] obj = new String[]{"remote", "ProcessModelService"};
            throw new BPMRuntimeException(70203, obj, exc);
        }
    }

    @Override
    public IBPMOrganizationService getBPMOrganizationService() {
        try {
            IBPMOrganizationService service = (IBPMOrganizationService)this.context.getJNDIInitialContext().lookup("ejb/bpm/services/BPMOrganizationServiceBean");
            return service;
        }
        catch (Exception exc) {
            Object[] obj = new String[]{"remote", "BPMOrganizationService"};
            throw new BPMRuntimeException(70203, obj, exc);
        }
    }

    @Override
    public IInstanceQueryService getInstanceQueryService() {
        try {
            IInstanceQueryService service = (IInstanceQueryService)this.context.getJNDIInitialContext().lookup("ejb/bpm/services/InstanceQueryServiceBean");
            return service;
        }
        catch (Exception exc) {
            Object[] obj = new String[]{"remote", "InstanceQueryService"};
            throw new BPMRuntimeException(70203, obj, exc);
        }
    }

    @Override
    public IInstanceManagementService getInstanceManagementService() {
        try {
            IInstanceManagementService service = (IInstanceManagementService)this.context.getJNDIInitialContext().lookup("ejb/bpm/services/InstanceManagementServiceBean");
            return service;
        }
        catch (Exception exc) {
            Object[] obj = new String[]{"remote", "InstanceManagementService"};
            throw new BPMRuntimeException(70203, obj, exc);
        }
    }

    @Override
    public IProcessDashboardService getProcessDashboardService() {
        try {
            IProcessDashboardService service = (IProcessDashboardService)this.context.getJNDIInitialContext().lookup("ejb/bpm/services/ProcessDashboardServiceBean");
            return service;
        }
        catch (Exception exc) {
            Object[] obj = new String[]{"remote", "ProcessDashboardService"};
            throw new BPMRuntimeException(70203, obj, exc);
        }
    }
}

