/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.client;

import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.ws.spi.ServiceDelegate;
import oracle.bpel.services.workflow.client.IWorkflowServiceClientConstants;
import oracle.bpel.services.workflow.client.WorkflowServiceClientContext;
import oracle.bpel.services.workflow.client.config.ClientConfigurationUtil;
import oracle.bpel.services.workflow.client.config.ServerType;
import oracle.bpel.services.workflow.client.config.SoapClientType;
import oracle.bpel.services.workflow.client.config.WorkflowServicesClientConfigurationType;
import oracle.bpm.client.common.BPMServiceClientException;
import oracle.j2ee.ws.common.jaxws.ServiceDelegateImpl;
import oracle.webservices.OracleService;
import org.w3c.dom.Element;

public class BPMServiceClientContext
implements Serializable {
    private static Map<BPM_SERVICE, String> sServicesEndPointSuffix = new HashMap<BPM_SERVICE, String>();
    private static final String BPM_SERVICE_ROOT = "integration/services/";
    private static Map<String, ServiceCacheEntry> sServiceCache;
    private WorkflowServiceClientContext mWorkflowServiceClientContext = null;

    private BPMServiceClientContext() {
    }

    public BPMServiceClientContext(WorkflowServicesClientConfigurationType wsClientConfig, Logger logger) throws BPMServiceClientException {
        this.mWorkflowServiceClientContext = new WorkflowServiceClientContext(wsClientConfig, logger);
    }

    public BPMServiceClientContext(Map<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> properties, Logger logger) throws BPMServiceClientException {
        this.mWorkflowServiceClientContext = new WorkflowServiceClientContext(properties, logger);
    }

    public BPMServiceClientContext(Map<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> properties, String serverName, Logger logger) throws BPMServiceClientException {
        this.mWorkflowServiceClientContext = serverName == null ? new WorkflowServiceClientContext(properties, logger) : new WorkflowServiceClientContext(properties, serverName, logger);
    }

    public WorkflowServicesClientConfigurationType getWorkflowServicesClientConfiguration() {
        return this.mWorkflowServiceClientContext.getWorkflowServicesClientConfiguration();
    }

    public WorkflowServiceClientContext getWorkflowServiceClientContext() {
        return this.mWorkflowServiceClientContext;
    }

    public InitialContext getJNDIInitialContext() throws BPMServiceClientException {
        return this.mWorkflowServiceClientContext.getJNDIInitialContext();
    }

    public boolean isDiscoveryOfEndPoint() {
        return this.mWorkflowServiceClientContext.isDiscoveryOfEndPoint();
    }

    public boolean isDiscoveryOfEndPoint(Map<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> map) {
        return this.mWorkflowServiceClientContext.isDiscoveryOfEndPoint(map);
    }

    public String getSOAPEndPoint(BPM_SERVICE service) throws BPMServiceClientException {
        try {
            WorkflowServicesClientConfigurationType clientConfig = this.getWorkflowServicesClientConfiguration();
            ServerType server = ClientConfigurationUtil.getDefaultServerType((WorkflowServicesClientConfigurationType)clientConfig);
            SoapClientType soapClient = server.getSoapClient();
            if (soapClient == null) {
                throw new BPMServiceClientException("soapClient is null");
            }
            String root = soapClient.getRootEndPointURL();
            if (root.endsWith("/")) {
                return root + sServicesEndPointSuffix.get((Object)service);
            }
            return root + "/" + sServicesEndPointSuffix.get((Object)service);
        }
        catch (Exception e) {
            throw new BPMServiceClientException(e);
        }
    }

    public static String getServiceUriSuffix(BPM_SERVICE service) {
        return sServicesEndPointSuffix.get((Object)service);
    }

    public Logger getLogger() {
        return this.mWorkflowServiceClientContext.getLogger();
    }

    public String getSOAPIdentityPropagationMode() throws BPMServiceClientException {
        return this.mWorkflowServiceClientContext.getSOAPIdentityPropagationMode();
    }

    public Element getSOAPSecurityPolicy() throws BPMServiceClientException {
        return this.mWorkflowServiceClientContext.getSOAPSecurityPolicy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceDelegate getService(BPM_SERVICE service1, URL wsdlURL, String endPoint, QName portQName, QName serviceQName, Logger logger) {
        String cacheServiceKey = endPoint + "/" + portQName;
        ServiceCacheEntry serviceCacheEntry = sServiceCache.get(cacheServiceKey);
        ServiceDelegate jaxwsService = null;
        boolean cachedEntry = true;
        if (serviceCacheEntry == null) {
            Map<String, ServiceCacheEntry> map = sServiceCache;
            synchronized (map) {
                serviceCacheEntry = sServiceCache.get(cacheServiceKey);
                if (serviceCacheEntry == null) {
                    cachedEntry = false;
                    jaxwsService = new ServiceDelegateImpl(wsdlURL, serviceQName, OracleService.class);
                    serviceCacheEntry = new ServiceCacheEntry(wsdlURL, jaxwsService);
                    sServiceCache.put(cacheServiceKey, serviceCacheEntry);
                }
            }
        }
        URL cacheEndPoint = serviceCacheEntry.wsdlURL;
        if (!cachedEntry) {
            if (logger != null) {
                logger.log(Level.FINEST, "WorkflowServiceClientContext: getService(): Returning new javax.xml.ws.Service for " + (Object)((Object)service1));
            }
            jaxwsService = serviceCacheEntry.service;
        } else if (wsdlURL.sameFile(cacheEndPoint)) {
            if (logger != null) {
                logger.log(Level.FINEST, "WorkflowServiceClientContext: getService(): Returning cached javax.xml.ws.Service for " + (Object)((Object)service1));
            }
            jaxwsService = serviceCacheEntry.service;
        } else {
            if (logger != null && logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "WorkflowServiceClientContext: getService(): Creating new javax.xml.ws.Service for " + (Object)((Object)service1) + " as cached end point " + cacheEndPoint + " is different from new end point " + wsdlURL);
            }
            jaxwsService = new ServiceDelegateImpl(wsdlURL, serviceQName, OracleService.class);
            jaxwsService.addPort(portQName, "http://schemas.xmlsoap.org/wsdl/soap/http", endPoint);
            sServiceCache.put(cacheServiceKey, new ServiceCacheEntry(wsdlURL, jaxwsService));
        }
        return jaxwsService;
    }

    static {
        sServicesEndPointSuffix.put(BPM_SERVICE.instanceManagementService, "integration/services/InstanceManagementService/InstanceManagementServicePort");
        sServicesEndPointSuffix.put(BPM_SERVICE.instanceQueryService, "integration/services/InstanceQueryService/InstanceQueryServicePort");
        sServicesEndPointSuffix.put(BPM_SERVICE.processDashboardService, "integration/services/ProcessDashboardService/ProcessDashboardServicePort");
        sServicesEndPointSuffix.put(BPM_SERVICE.processMetadataService, "integration/services/ProcessMetadataService/ProcessMetadataServicePort");
        sServicesEndPointSuffix.put(BPM_SERVICE.bpmUserAutenticationService, "integration/services/BPMUserAuthenticationService/BPMUserAuthenticationServicePort");
        sServicesEndPointSuffix.put(BPM_SERVICE.organizationService, "integration/services/OrganizationService/OrganizationServicePort");
        sServiceCache = new ConcurrentHashMap<String, ServiceCacheEntry>();
    }

    protected static class ServiceCacheEntry {
        protected URL wsdlURL;
        protected ServiceDelegate service;

        ServiceCacheEntry(URL wsdlURL, ServiceDelegate service) {
            this.wsdlURL = wsdlURL;
            this.service = service;
        }
    }

    public static enum BPM_SERVICE {
        bpmUserAutenticationService,
        instanceManagementService,
        instanceQueryService,
        processMetadataService,
        processDashboardService,
        userMetadataService,
        runtimeConfigService,
        agQueryService,
        organizationService;

    }
}

