/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.workflow.editor.org;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import oracle.bpm.fusion.soa.msg.FusionSoaMsg;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.services.organization.model.OrganizationalUnit;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.services.connections.Connection;
import oracle.tip.tools.ide.common.services.lookup.LookupDataProvider;
import oracle.tip.tools.ide.common.services.lookup.LookupManager;
import oracle.tip.tools.ide.common.services.lookup.LookupResult;
import oracle.tip.tools.ide.common.services.lookup.OrganizationLookupContext;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.ConnectionNode;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.LookupConnectionNode;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.LookupUtil;
import oracle.tip.tools.ide.workflow.api.IValidator;
import oracle.tip.tools.ide.workflow.editor.org.ConnectionComponent;
import oracle.tip.tools.ide.workflow.editor.org.OrganizationLookup;

public class OrganizationsDetailPanel
extends JPanel
implements IValidator {
    private Container container;
    private ConnectionComponent mConnectionPanel = null;
    private List<OrganizationData> mData = null;
    private DefaultListModel mOrgUnitListModel = null;
    private JPanel mOrgUnitsPanel;
    private Project mProject = null;
    private JComboBox mRealmBox = null;
    private Object mRealmLock = new Object();
    private Thread mRealmRunnable = null;
    private JScrollPane mScrollPane = null;
    private JPanel mSearchPanel;
    private JList orgList;
    private JPanel realmPanel;
    private JTextField searchField;

    public OrganizationsDetailPanel(Project project, Container container) {
        this.mProject = project;
        this.container = container;
        this.initializeComponents();
        this.layoutComponents();
    }

    public void validateData() throws Exception {
    }

    public OrganizationData getData() {
        OrganizationData oData = null;
        Object value = this.orgList.getSelectedValue();
        if (value instanceof OrganizationData) {
            oData = (OrganizationData)value;
        }
        return oData;
    }

    public void initializeAttributeCombo(Connection c) {
        this.populateRealms();
    }

    public Container getContainer() {
        return this.container;
    }

    private void initializeComponents() {
        this.mConnectionPanel = new ConnectionComponent(this.mProject, this, this.getContainer());
        this.mRealmBox = new JComboBox();
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        this.mRealmBox.setModel(model);
        this.mRealmBox.addItemListener(new LocalRealmItemListener());
        this.initOrgUnitsPanel();
        this.initRealmsPanel();
        this.initSearchPanel();
    }

    private void initRealmsPanel() {
        this.realmPanel = new JPanel();
        this.realmPanel.setLayout(new GridBagLayout());
        JLabel lbl = new JLabel(FusionSoaMsg.REALMS.toString());
        GraphUtils.addComponent((Container)this.realmPanel, (Component)lbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 10), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this.realmPanel, (Component)this.mRealmBox, (int)1, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    private void layoutComponents() {
        GridBagLayout gl = new GridBagLayout();
        this.setLayout(gl);
        int x = 0;
        int y = 0;
        Insets insets = new Insets(0, 10, 10, 0);
        Component topStrut = Box.createVerticalStrut(2);
        gl.setConstraints(topStrut, new GridBagConstraints(x, y, 0, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add(topStrut);
        this.add(topStrut);
        ++y;
        if (this.mConnectionPanel != null) {
            gl.setConstraints(this.mConnectionPanel, new GridBagConstraints(x, y, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 10, 0), 0, 0));
            this.add(this.mConnectionPanel);
        }
        x = 0;
        gl.setConstraints(this.realmPanel, new GridBagConstraints(x, ++y, 0, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        this.add(this.realmPanel);
        x = 0;
        gl.setConstraints(this.mSearchPanel, new GridBagConstraints(x, ++y, 0, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        this.add(this.mSearchPanel);
        x = 0;
        gl.setConstraints(this.mOrgUnitsPanel, new GridBagConstraints(x, ++y, 0, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        this.add(this.mOrgUnitsPanel);
        Box box = Box.createVerticalBox();
        gl.setConstraints(box, new GridBagConstraints(x, ++y, 0, 0, 1.0, 1.0, 21, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add(box);
    }

    private LookupResult handleOrganization(OrganizationLookupContext pContext) {
        Object realm;
        String realmName;
        List<String> attributes;
        LookupResult lookupResult = new LookupResult();
        Connection c = pContext.getConnection();
        ConnectionNode cNode = new ConnectionNode(c.getName(), c.getDescriptor());
        LookupConnectionNode connectionNode = new LookupConnectionNode(cNode);
        OrganizationLookup lookup = new OrganizationLookup();
        String searchStr = this.searchField.getText();
        if (searchStr == null || searchStr.trim().equals("")) {
            searchStr = "%";
        }
        if ((attributes = lookup.listOrganizations(connectionNode, realmName = (realm = this.mRealmBox.getSelectedItem()) != null ? realm.toString() : "", searchStr)) == null) {
            return null;
        }
        Iterator<String> iter = attributes.iterator();
        ArrayList<OrganizationalUnit> list = new ArrayList<OrganizationalUnit>();
        while (iter.hasNext()) {
            OrganizationalUnit itemToAdd = (OrganizationalUnit)iter.next();
            list.add(itemToAdd);
        }
        lookupResult.setData(list);
        return lookupResult;
    }

    private void initOrgUnitsPanel() {
        this.mOrgUnitsPanel = new JPanel();
        this.mOrgUnitsPanel.setLayout(new GridBagLayout());
        this.mOrgUnitListModel = new DefaultListModel();
        this.orgList = new JList(this.mOrgUnitListModel);
        this.orgList.setSelectionMode(0);
        this.mScrollPane = new JScrollPane(this.orgList);
        GraphUtils.addComponent((Container)this.mOrgUnitsPanel, (Component)this.mScrollPane, (int)0, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    private void initSearchPanel() {
        this.mSearchPanel = new JPanel();
        this.mSearchPanel.setLayout(new GridBagLayout());
        JLabel lbl = new JLabel(LibMsg.SEARCH.toString());
        GraphUtils.addComponent((Container)this.mSearchPanel, (Component)lbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 10), (int)0, (int)0, (double)0.0, (double)0.0);
        this.searchField = new JTextField();
        GraphUtils.addComponent((Container)this.mSearchPanel, (Component)this.searchField, (int)1, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        JButton searchBtn = new JButton(LibMsg.SEARCH.toString());
        searchBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrganizationsDetailPanel.this.populateOrgUnits();
            }
        });
        GraphUtils.addComponent((Container)this.mSearchPanel, (Component)searchBtn, (int)2, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateRealms() {
        Object object = this.mRealmLock;
        synchronized (object) {
            if (this.mRealmRunnable != null) {
                this.mRealmRunnable.interrupt();
            }
        }
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (OrganizationsDetailPanel.this.mRealmBox != null) {
                    List l;
                    DefaultComboBoxModel model;
                    block8: {
                        LookupConnectionNode node;
                        block7: {
                            Connection connection;
                            block6: {
                                model = (DefaultComboBoxModel)OrganizationsDetailPanel.this.mRealmBox.getModel();
                                try {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            OrganizationsDetailPanel.this.getContainer().setCursor(Cursor.getPredefinedCursor(3));
                                            model.removeAllElements();
                                        }
                                    });
                                    connection = OrganizationsDetailPanel.this.mConnectionPanel.getSelectedConnection();
                                    if (connection != null) break block6;
                                }
                                catch (Throwable throwable) {
                                    Runnable rend = new Runnable(){

                                        @Override
                                        public void run() {
                                            OrganizationsDetailPanel.this.getContainer().setCursor(Cursor.getDefaultCursor());
                                        }
                                    };
                                    SwingUtilities.invokeLater(rend);
                                    throw throwable;
                                }
                                Runnable rend = new /* invalid duplicate definition of identical inner class */;
                                SwingUtilities.invokeLater(rend);
                                return;
                            }
                            node = new LookupConnectionNode(new ConnectionNode(connection.getName(), connection.getDescriptor()));
                            if (node != null) break block7;
                            Runnable rend = new /* invalid duplicate definition of identical inner class */;
                            SwingUtilities.invokeLater(rend);
                            return;
                        }
                        l = LookupUtil.getRealms((LookupConnectionNode)node);
                        if (!Thread.currentThread().isInterrupted()) break block8;
                        Runnable rend = new /* invalid duplicate definition of identical inner class */;
                        SwingUtilities.invokeLater(rend);
                        return;
                    }
                    Runnable r1 = new Runnable(){

                        @Override
                        public void run() {
                            model.removeAllElements();
                            for (String name : l) {
                                model.addElement(name);
                            }
                        }
                    };
                    SwingUtilities.invokeLater(r1);
                    Runnable rend = new /* invalid duplicate definition of identical inner class */;
                    SwingUtilities.invokeLater(rend);
                }
            }
        };
        this.mRealmRunnable = new Thread(r);
        this.mRealmRunnable.start();
    }

    private void populateOrgUnits() {
        this.mOrgUnitListModel.removeAllElements();
        Connection c = this.mConnectionPanel.getSelectedConnection();
        if (c != null) {
            LookupManager manager = LookupManager.getInstance();
            LookupDataProvider provider = manager.getProvider();
            if (provider == null) {
                return;
            }
            OrganizationLookupContext flexContext = new OrganizationLookupContext(this, null, c);
            LookupResult result = this.handleOrganization(flexContext);
            if (result == null) {
                return;
            }
            for (OrganizationalUnit flex : result.getData()) {
                OrganizationData data = new OrganizationData();
                data.setName(flex.getOrganizationalUnitName());
                data.setId(flex.getOrganizationalUnitId());
                this.mOrgUnitListModel.addElement(data);
            }
        }
    }

    public class OrganizationData {
        private String id = null;
        private String mName = null;

        public String getName() {
            return this.mName;
        }

        public String getId() {
            return this.id;
        }

        public void setName(String name) {
            this.mName = name;
        }

        public String toString() {
            return this.getName();
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public class LocalRealmItemListener
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent pEvent) {
            OrganizationsDetailPanel.this.mOrgUnitListModel.removeAllElements();
        }
    }
}

