/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.workflow.editor.org;

import java.util.HashMap;
import java.util.List;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.client.IWorkflowServiceClientConstants;
import oracle.bpm.client.BPMServiceClientFactory;
import oracle.bpm.services.authentication.IBPMUserAuthenticationService;
import oracle.bpm.services.client.IBPMServiceClient;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.organization.IBPMOrganizationService;
import oracle.bpm.services.organization.model.OrganizationEntityTypeEnum;
import oracle.bpm.services.organization.model.SearchModeTypeEnum;
import oracle.jdeveloper.server.connection.AppServer;
import oracle.jdeveloper.server.connection.AppServerManager;
import oracle.rc.asadapter.connection.AppServerConnection;
import oracle.rc.asadapter.connection.Presentation;
import oracle.rc.asadapter.connection.PresentationType;
import oracle.rc.asadapter.http.HttpConnectionManager;
import oracle.tip.tools.ide.fabric.asbrowser.ASBrowserHelper;
import oracle.tip.tools.ide.fabric.asbrowser.SOAServerObject;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.ConnectionNode;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.LookupConnectionNode;
import oracle.tip.tools.ide.workflow.api.IOrganizationLookup;

public class OrganizationLookup
implements IOrganizationLookup {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HostInfo getHostInfo(LookupConnectionNode connection) {
        Presentation pres;
        AppServerConnection conn;
        HostInfo hi;
        block10: {
            HostInfo hostInfo;
            block9: {
                if (connection == null) {
                    return null;
                }
                hi = null;
                ConnectionNode node = connection.getConnNode();
                conn = null;
                pres = null;
                try {
                    AppServer selAppServ = AppServerManager.getInstance().getAppServer(node.getName());
                    conn = selAppServ.getConnection();
                    hi = OrganizationLookup.getAdminServerInfo(conn);
                    if (hi != null) {
                        hostInfo = hi;
                        if (pres == null) return hostInfo;
                        break block9;
                    }
                    pres = conn.getPresentation(PresentationType.HTTP);
                    HttpConnectionManager httpMgr = (HttpConnectionManager)pres.get();
                    String hostName = httpMgr.getHostname();
                    int port = httpMgr.getHttpPort();
                    hi = new HostInfo();
                    hi.setName(hostName);
                    hi.setHttpPort(port);
                    if (pres == null) return hi;
                    break block10;
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    return hi;
                }
            }
            conn.releasePresentation(pres);
            return hostInfo;
        }
        conn.releasePresentation(pres);
        return hi;
        finally {
            if (pres != null) {
                conn.releasePresentation(pres);
            }
        }
    }

    public List listOrganizations(LookupConnectionNode connection, String realmName, String searchStr) {
        HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> properties = new HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String>();
        connection.getConnNode().getConnectionDescriptor().getHTTPPort();
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.MODE, "dynamic");
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_PROVIDER_URL, OrganizationLookup.getEjbEndPoint(connection));
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.SOAP_END_POINT_ROOT, OrganizationLookup.getSoapEndPoint(connection));
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_SECURITY_PRINCIPAL, connection.getConnNode().getConnectionDescriptor().getUserName());
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_SECURITY_CREDENTIALS, connection.getConnNode().getConnectionDescriptor().getPassword());
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.CLIENT_TYPE, "REMOTE");
        BPMServiceClientFactory bpmServiceClientFactory = BPMServiceClientFactory.getInstance(properties, null, null);
        IBPMServiceClient svcClient = bpmServiceClientFactory.getBPMServiceClient();
        IBPMOrganizationService bpmOrganizationService = svcClient.getBPMOrganizationService();
        IBPMUserAuthenticationService bpmUserAuthenticationService = bpmServiceClientFactory.getBPMUserAuthenticationService();
        try {
            IBPMContext adminCtx = bpmUserAuthenticationService.authenticate(connection.getConnNode().getConnectionDescriptor().getUserName(), connection.getConnNode().getConnectionDescriptor().getPassword().toCharArray(), realmName);
            return bpmOrganizationService.searchOrganizationEntity(adminCtx, OrganizationEntityTypeEnum.ORGANIZATIONAL_UNIT, SearchModeTypeEnum.LIKE, searchStr, 0, 0);
        }
        catch (BPMException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getSoapEndPoint(LookupConnectionNode connection) {
        HostInfo hi = OrganizationLookup.getHostInfo(connection);
        if (hi == null) {
            return null;
        }
        if (hi.getHttpPort() == -1) {
            return null;
        }
        if (hi.getName() == null) {
            return null;
        }
        return hi.toString();
    }

    private static String getEjbEndPoint(LookupConnectionNode connection) {
        HostInfo hi = OrganizationLookup.getHostInfo(connection);
        if (hi == null) {
            return null;
        }
        if (hi.getHttpPort() == -1) {
            return null;
        }
        if (hi.getName() == null) {
            return null;
        }
        return hi.toT3String();
    }

    private static HostInfo getAdminServerInfo(AppServerConnection conn) {
        HostInfo hi = null;
        try {
            List l = ASBrowserHelper.listSOAServers((AppServerConnection)conn);
            for (SOAServerObject soa : l) {
                if (soa == null || !soa.isServerRunning() || soa.getHttpURL() == null) continue;
                hi = new HostInfo();
                hi.setName(soa.getHostName());
                hi.setHttpPort(soa.getPort());
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hi;
    }

    static class HostInfo {
        private int httpPort = -1;
        private String name = null;
        private boolean useSSL = false;

        HostInfo() {
        }

        public String getName() {
            return this.name;
        }

        public int getHttpPort() {
            return this.httpPort;
        }

        public String toString() {
            String protocol = this.useSSL ? "https:" : "http:";
            return protocol + "//" + this.name + ":" + this.httpPort;
        }

        public String toT3String() {
            return "t3://" + this.name + ":" + this.httpPort;
        }

        private void setName(String name) {
            this.name = name;
        }

        private void setHttpPort(int httpPort) {
            this.httpPort = httpPort;
        }
    }
}

