/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.ui.extension;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bpm.designer.action.ModuleAction;
import oracle.bpm.fusion.soa.model.OperationDetails;
import oracle.bpm.fusion.soa.model.OperationInfo;
import oracle.bpm.fusion.soa.model.OperationsTableModel;
import oracle.bpm.fusion.soa.msg.FusionSoaMsg;
import oracle.bpm.fusion.soa.ui.extension.OperationDetailsDialog;
import oracle.bpm.fusion.soa.util.AdapterExtensionUtil;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.ide.Context;
import oracle.tip.tools.ide.common.ui.UIHelper;
import org.jetbrains.annotations.NotNull;

public class AdapterExtensionPanel
extends JPanel {
    public AbstractAction editAction;
    public JButton editButton;
    JTable operationsTable;
    OperationsTableModel operationsTableModel;
    int rowSelected = -1;
    OperationDetails selectedOperationDetails;
    private ObjectTypeDescription adapterBasicInfo = null;
    private AbstractAction browseAction;
    private JButton browseButton;
    private Panel cellPanel;
    private GridBagConstraints constraints = new GridBagConstraints();
    private Context context;
    private JTextArea descriptionTextArea;
    private Boolean editMode;
    private JTextField moduleText;
    private JTextField nameText;
    private String moduleName;
    private static final Icon flashLightIcon = UIHelper.loadIcon((String)"images/flashlight14.png", UIHelper.class);
    public static final int ROW_HEIGHT = 40;

    public AdapterExtensionPanel(Context ideContext, OperationsTableModel opnsTableModel, ObjectTypeDescription otd, Boolean eMode, String modName) {
        this.context = ideContext;
        this.operationsTableModel = opnsTableModel;
        this.adapterBasicInfo = otd;
        this.editMode = eMode;
        this.moduleName = modName;
        this.initGUI();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        OperationsTableModel tableModel = new OperationsTableModel(1);
        tableModel.setValueAt(Boolean.FALSE, 0, 0);
        tableModel.setValueAt("label1", 0, 1);
        tableModel.setValueAt("txtfield11", 0, 2);
        tableModel.setValueAt("txtfield12", 0, 3);
        tableModel.setValueAt("txtfield13", 0, 4);
        AdapterExtensionPanel adapterExtensionPanel = new AdapterExtensionPanel(Context.newIdeContext(), tableModel, new ObjectTypeDescription("Test"), false, null);
        frame.getContentPane().add(adapterExtensionPanel);
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public JComponent getInitialFocusComponent() {
        JTextField jTextField = this.nameText;
        if (jTextField == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/fusion/soa/ui/extension/AdapterExtensionPanel.getInitialFocusComponent must not return null");
        }
        return jTextField;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getBpmObjectName() {
        String string = Str.null2empty(this.nameText.getText());
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/fusion/soa/ui/extension/AdapterExtensionPanel.getBpmObjectName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getBpmObjectModule() {
        String string = Str.null2empty(this.moduleText.getText());
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/fusion/soa/ui/extension/AdapterExtensionPanel.getBpmObjectModule must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getBpmObjectDesc() {
        String string = Str.null2empty(this.descriptionTextArea.getText());
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/fusion/soa/ui/extension/AdapterExtensionPanel.getBpmObjectDesc must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public AbstractTableModel getModel() {
        OperationsTableModel operationsTableModel = this.operationsTableModel;
        if (operationsTableModel == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/fusion/soa/ui/extension/AdapterExtensionPanel.getModel must not return null");
        }
        return operationsTableModel;
    }

    private void initGUI() {
        GridBagLayout thisLayout = new GridBagLayout();
        this.setPreferredSize(new Dimension(550, 400));
        this.setLayout(thisLayout);
        JLabel nameLabel = new JLabel();
        nameLabel.setText(FusionSoaMsg.ADAPTER_NAME.toString());
        nameLabel.setHorizontalTextPosition(10);
        nameLabel.setHorizontalAlignment(2);
        this.setInsets(0, 8, 0, 0);
        this.setConstraints(0, 0, 1, 1, 0.0, 0.5, 21, 0);
        this.add((Component)nameLabel, this.constraints);
        this.nameText = new JTextField();
        this.nameText.setText(this.adapterBasicInfo.getName());
        if (this.editMode.booleanValue()) {
            this.nameText.setEditable(false);
            this.setInsets(0, 0, 0, 10);
        } else {
            this.nameText.setEditable(true);
            this.setInsets(0, 0, 0, 0);
        }
        this.setConstraints(1, 0, 1, 1, 0.25, 0.5, 10, 2);
        this.add((Component)this.nameText, this.constraints);
        JLabel moduleLabel = new JLabel();
        moduleLabel.setText(FusionSoaMsg.MODULE_NAME.toString());
        moduleLabel.setHorizontalAlignment(2);
        this.setInsets(0, 8, 0, 0);
        this.setConstraints(0, 1, 1, 1, 0.0, 0.5, 21, 0);
        this.add((Component)moduleLabel, this.constraints);
        this.moduleText = new JTextField();
        if (this.editMode.booleanValue()) {
            this.moduleText.setText(this.moduleName);
            this.setInsets(0, 0, 0, 10);
        } else {
            this.setInsets(0, 0, 0, 0);
        }
        this.moduleText.setEditable(false);
        this.setConstraints(1, 1, 1, 1, 0.25, 0.5, 10, 2);
        this.add((Component)this.moduleText, this.constraints);
        if (!this.editMode.booleanValue()) {
            this.browseButton = new JButton();
            this.browseButton.setText(FusionSoaMsg.BROWSE.toString());
            this.browseButton.setAction(this.getBrowseAction());
            this.setInsets(0, 9, 0, 0);
            this.setConstraints(2, 1, 1, 1, 0.1, 0.5, 21, 0);
            this.add((Component)this.browseButton, this.constraints);
        }
        JLabel descriptionLabel = new JLabel();
        descriptionLabel.setText(FusionSoaMsg.ADAPTER_DESC.toString());
        descriptionLabel.setHorizontalAlignment(2);
        descriptionLabel.setVerticalAlignment(1);
        this.setInsets(7, 8, 0, 0);
        this.setConstraints(0, 2, 1, 1, 0.0, 0.5, 21, 0);
        this.add((Component)descriptionLabel, this.constraints);
        this.descriptionTextArea = new JTextArea();
        this.descriptionTextArea.setText(this.adapterBasicInfo.getDescription());
        this.descriptionTextArea.setEditable(true);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setWrapStyleWord(true);
        JScrollPane descScrollPane = new JScrollPane(this.descriptionTextArea);
        descScrollPane.setBounds(10, 60, 780, 500);
        this.setInsets(7, 0, 0, 10);
        this.setConstraints(1, 2, 0, 2, 1.0, 2.0, 10, 1);
        this.add((Component)descScrollPane, this.constraints);
        MultiLineLabel messageLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), FusionSoaMsg.DISPLAY_MESSAGE.toString());
        messageLabel.setAlignment(1);
        this.setInsets(14, 0, 0, 7);
        this.setConstraints(1, 5, 0, 1, 0.0, 0.6, 21, 1);
        this.add((Component)messageLabel, this.constraints);
        Image editDispNameImage = ImageUtils.getImageResource(FusionSoaMsg.class, (String)"/oracle/bpm/fusion/soa/msg/images/edit16.png");
        ImageIcon editDispImageIcon = new ImageIcon(editDispNameImage);
        this.editButton = new JButton(editDispImageIcon);
        this.editButton.setBorderPainted(false);
        this.editButton.setAction(this.getEditAction());
        this.editButton.setIcon(editDispImageIcon);
        this.setConstraints(1, 5, 0, 1, 0.1, 0.5, 22, 0);
        this.add((Component)this.editButton, this.constraints);
        JLabel operationsLabel = new JLabel();
        operationsLabel.setText(FusionSoaMsg.OPERATION_TABLE_LABEL.toString());
        operationsLabel.setHorizontalAlignment(2);
        this.setInsets(0, 8, 0, 0);
        this.setConstraints(0, 7, 1, 1, 0.0, 0.5, 22, 1);
        this.add((Component)operationsLabel, this.constraints);
        JScrollPane operationsScrollPane = new JScrollPane();
        this.operationsTable = new JTable();
        operationsScrollPane.setViewportView(this.operationsTable);
        this.operationsTable.setModel(this.operationsTableModel);
        this.operationsTable.setRowSelectionAllowed(true);
        this.operationsTable.setColumnSelectionAllowed(false);
        this.operationsTable.getTableHeader().setReorderingAllowed(false);
        this.operationsTable.getTableHeader().setBounds(0, 0, 453, 15);
        this.operationsTable.setShowGrid(true);
        for (int r = 0; r < this.operationsTableModel.getRowCount(); ++r) {
            for (int c = 0; c < this.operationsTableModel.getColumnCount(); ++c) {
                TableColumn column = this.operationsTable.getColumnModel().getColumn(c);
                if (c == 0) {
                    column.setResizable(false);
                    column.setPreferredWidth(16);
                    column.setMaxWidth(16);
                    column.setMinWidth(16);
                    column.setCellRenderer(new CheckBoxRenderer());
                    continue;
                }
                if (c == 1) {
                    column.setPreferredWidth(140);
                    column.setCellRenderer(new BasicOperationCellRenderer());
                    continue;
                }
                if (this.operationsTableModel.isCellEditable(r, c)) {
                    column.setPreferredWidth(105);
                    column.setCellRenderer(new TextAreaCellRenderer());
                    continue;
                }
                column.setPreferredWidth(130);
                column.setCellRenderer(new DisabledCellRenderer());
            }
        }
        this.setInsets(0, 0, 5, 10);
        this.setConstraints(1, 7, 0, 2, 5.5, 5.5, 10, 1);
        this.add((Component)operationsScrollPane, this.constraints);
    }

    private AbstractAction getBrowseAction() {
        if (this.browseAction == null) {
            this.browseAction = new AbstractAction(FusionSoaMsg.BROWSE.toString(), null){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Project project;
                    CatalogModule object;
                    if (evt.getSource().equals(AdapterExtensionPanel.this.browseButton) && (object = ModuleAction.selectModule((Project)(project = AdapterExtensionUtil.getProject(AdapterExtensionPanel.this.context)))) != null) {
                        AdapterExtensionPanel.this.moduleText.setText(object.getText());
                    }
                }
            };
        }
        return this.browseAction;
    }

    private AbstractAction getEditAction() {
        if (this.editAction == null) {
            this.editAction = new AbstractAction(FusionSoaMsg.EDIT.toString(), null){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (evt.getSource().equals(AdapterExtensionPanel.this.editButton)) {
                        Boolean operSelected = AdapterExtensionPanel.this.populateSelectedOperation();
                        if (!operSelected.booleanValue()) {
                            String message = "Please select an operation first";
                            JOptionPane.showMessageDialog(new JFrame(), FusionSoaMsg.ERROR_NO_OPER_SELECTED.toString(), FusionSoaMsg.ERROR_TITLE.toString(), 0);
                            return;
                        }
                        JFrame frame = new JFrame();
                        OperationDetailsDialog dlg = new OperationDetailsDialog(frame, AdapterExtensionPanel.this.rowSelected, AdapterExtensionPanel.this.operationsTableModel, AdapterExtensionPanel.this.selectedOperationDetails);
                    }
                }
            };
        }
        return this.editAction;
    }

    private Boolean populateSelectedOperation() {
        Boolean selectionFlag = false;
        block0: for (int i = 0; i < this.operationsTable.getRowCount(); ++i) {
            if (!this.operationsTable.isRowSelected(i)) continue;
            selectionFlag = true;
            if (this.operationsTableModel.getValueAt(i, 1) != null) {
                this.rowSelected = i;
                continue;
            }
            int j = i - 1;
            while (i < this.operationsTableModel.getRowCount()) {
                if (this.operationsTableModel.getValueAt(j, 1) != null) {
                    this.rowSelected = j;
                    continue block0;
                }
                --j;
            }
        }
        if (!selectionFlag.booleanValue()) {
            return false;
        }
        OperationInfo operationInfo = (OperationInfo)this.operationsTableModel.getValueAt(this.rowSelected, 1);
        String inArgName = null;
        String inArgDesc = null;
        String inArgBOName = null;
        String outArgName = null;
        String outArgBOName = null;
        String outArgDesc = null;
        String errorArgName = null;
        String errorArgBOName = null;
        String errorArgDesc = null;
        int argCt = 0;
        for (int j = this.rowSelected + 1; j < this.operationsTableModel.getRowCount() && this.operationsTableModel.getValueAt(j, 1) == null; ++j) {
            ++argCt;
            String argName = (String)this.operationsTableModel.getValueAt(j, 2);
            if (argName.substring(0, FusionSoaMsg.IN_ARGUMENT_PREFIX.toString().length()).equals(FusionSoaMsg.IN_ARGUMENT_PREFIX.toString())) {
                inArgName = argName.substring(FusionSoaMsg.IN_ARGUMENT_PREFIX.toString().length());
                inArgBOName = (String)this.operationsTableModel.getValueAt(j, 3);
                inArgBOName = (String)this.operationsTableModel.getValueAt(j, 3);
                inArgDesc = (String)this.operationsTableModel.getValueAt(j, 4);
                continue;
            }
            if (argName.substring(0, FusionSoaMsg.OUT_ARGUMENT_PREFIX.toString().length()).equals(FusionSoaMsg.OUT_ARGUMENT_PREFIX.toString())) {
                outArgName = argName.substring(FusionSoaMsg.OUT_ARGUMENT_PREFIX.toString().length());
                outArgBOName = (String)this.operationsTableModel.getValueAt(j, 3);
                outArgDesc = (String)this.operationsTableModel.getValueAt(j, 4);
                continue;
            }
            errorArgName = argName.substring(FusionSoaMsg.BUS_OBJ_ERROR_PREFIX.toString().length());
            inArgBOName = (String)this.operationsTableModel.getValueAt(j, 3);
            errorArgBOName = (String)this.operationsTableModel.getValueAt(j, 3);
            errorArgDesc = (String)this.operationsTableModel.getValueAt(j, 4);
        }
        this.selectedOperationDetails = new OperationDetails(operationInfo.getOperationName(), operationInfo.getDisplayName(), (String)this.operationsTableModel.getValueAt(this.rowSelected, 4), inArgName, inArgDesc, inArgBOName, outArgName, outArgDesc, outArgBOName, errorArgName, errorArgDesc, errorArgBOName);
        return true;
    }

    private void setConstraints(int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill) {
        this.constraints.gridx = gridx;
        this.constraints.gridy = gridy;
        this.constraints.gridwidth = gridwidth;
        this.constraints.gridheight = gridheight;
        this.constraints.weightx = weightx;
        this.constraints.weighty = weighty;
        this.constraints.anchor = anchor;
        this.constraints.fill = fill;
    }

    private void setInsets(int top, int left, int bottom, int right) {
        this.constraints.insets = new Insets(top, left, bottom, right);
    }

    public static class TextAreaCellRenderer
    extends JTextArea
    implements TableCellRenderer {
        public TextAreaCellRenderer() {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setForeground(Color.BLACK);
            this.setBackground(Color.WHITE);
            this.setEditable(false);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (String.valueOf(value) != null) {
                this.setText(String.valueOf(value));
            } else {
                this.setText(" ");
            }
            int width = table.getColumnModel().getColumn(column).getWidth();
            this.setSize(width, 1000);
            int height = this.getPreferredSize().height;
            if (table.getRowHeight(row) != height) {
                table.setRowHeight(row, height);
            }
            return this;
        }
    }

    public static class OperationCellRenderer
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor,
    ActionListener {
        public JPanel cellPanel;
        String dispName;
        JButton editButton;
        JLabel editDisplayName = new JLabel();
        GridBagLayout gb = new GridBagLayout();
        OperationInfo operationInfo;
        String operationName;
        JLabel operNameLabel = new JLabel();
        JLabel operTypeLabel = new JLabel();
        Icon serviceImageIcon;
        Icon callbackImageIcon;
        private GridBagConstraints constraints = new GridBagConstraints();
        protected static final String EDIT = "edit";

        public OperationCellRenderer() {
            Image serviceImage = ImageUtils.getImageResource(FusionSoaMsg.class, (String)"/oracle/bpm/fusion/soa/msg/images/to_reference.png");
            this.serviceImageIcon = new ImageIcon(serviceImage);
            Image callbackImage = ImageUtils.getImageResource(FusionSoaMsg.class, (String)"/oracle/bpm/fusion/soa/msg/images/from_reference.png");
            this.callbackImageIcon = new ImageIcon(callbackImage);
            Image editDispNameImage = ImageUtils.getImageResource(FusionSoaMsg.class, (String)"/oracle/bpm/fusion/soa/msg/images/edit16.png");
            ImageIcon editDispImageIcon = new ImageIcon(editDispNameImage);
            this.editButton = new JButton(editDispImageIcon);
            this.editButton.setBorderPainted(false);
            this.editButton.setBackground(Color.WHITE);
            this.editButton.setActionCommand(EDIT);
            this.editButton.addActionListener(this);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            table.setRowHeight(row, 40);
            this.cellPanel = new JPanel();
            this.cellPanel.setLayout(this.gb);
            this.cellPanel.setBackground(Color.WHITE);
            this.cellPanel.setForeground(Color.BLACK);
            this.operNameLabel = new JLabel();
            this.operTypeLabel = new JLabel();
            this.editDisplayName = new JLabel();
            if (value != null) {
                this.operationInfo = (OperationInfo)value;
                this.operationName = this.operationInfo.getOperationName();
                this.operNameLabel = new JLabel(this.operationName);
                this.dispName = this.operationInfo.getDisplayName();
                this.operTypeLabel = this.operationInfo.belongsToCallbackPortType() ? new JLabel(this.callbackImageIcon) : new JLabel(this.serviceImageIcon);
                this.editDisplayName = this.dispName != null ? new JLabel(this.dispName) : new JLabel(FusionSoaMsg.OPERATION_DISPLAY_NAME_MSG.toString());
                this.setConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0);
                this.cellPanel.add((Component)this.operTypeLabel, this.constraints);
                this.setConstraints(1, 0, 0, 1, 1.0, 1.0, 10, 2);
                this.cellPanel.add((Component)this.operNameLabel, this.constraints);
                this.setConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0);
                this.cellPanel.add((Component)this.editButton, this.constraints);
                this.setConstraints(1, 1, 0, 1, 1.0, 1.0, 17, 2);
                this.cellPanel.add((Component)this.editDisplayName, this.constraints);
            }
            table.repaint();
            return this.cellPanel;
        }

        public boolean isCellEditable() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String message;
            String input;
            if (EDIT.equals(e.getActionCommand()) && (input = JOptionPane.showInputDialog(message = FusionSoaMsg.CUSTOMIZE_OPERATION_NAME_MSG.toString() + "'" + this.operationName + "'", (Object)this.dispName)) != null && !input.trim().equals("")) {
                this.dispName = input;
            }
            this.stopCellEditing();
        }

        @Override
        public Object getCellEditorValue() {
            this.operationInfo.setDisplayName(this.dispName);
            return this.operationInfo;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.operationInfo = (OperationInfo)value;
            this.dispName = this.operationInfo.getDisplayName();
            this.operationName = this.operationInfo.getOperationName();
            table.repaint();
            return this.editButton;
        }

        private void setConstraints(int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill) {
            this.constraints.gridx = gridx;
            this.constraints.gridy = gridy;
            this.constraints.gridwidth = gridwidth;
            this.constraints.gridheight = gridheight;
            this.constraints.weightx = weightx;
            this.constraints.weighty = weighty;
            this.constraints.anchor = anchor;
            this.constraints.fill = fill;
            this.constraints.ipadx = 0;
            this.constraints.ipady = 0;
            this.constraints.insets = new Insets(0, 0, 0, 0);
        }
    }

    public static class DisabledCellRenderer
    extends DefaultTableCellRenderer {
        public DisabledCellRenderer() {
            this.setForeground(Color.LIGHT_GRAY);
            this.setBackground(Color.WHITE);
            this.setEnabled(false);
        }
    }

    public static class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public CheckBoxRenderer() {
            this.setForeground(Color.BLACK);
            this.setBackground(Color.WHITE);
            this.setEnabled(false);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                boolean selected = (Boolean)value;
                this.setText("");
                this.setSelected(selected);
                this.setEnabled(true);
                return this;
            }
            JLabel dummyLabel = new JLabel("");
            dummyLabel.setEnabled(false);
            dummyLabel.setVisible(false);
            return dummyLabel;
        }
    }

    public static class BasicOperationCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Image serviceImage = ImageUtils.getImageResource(FusionSoaMsg.class, (String)"/oracle/bpm/fusion/soa/msg/images/to_reference.png");
            ImageIcon serviceImageIcon = new ImageIcon(serviceImage);
            Image callbackImage = ImageUtils.getImageResource(FusionSoaMsg.class, (String)"/oracle/bpm/fusion/soa/msg/images/from_reference.png");
            ImageIcon callbackImageIcon = new ImageIcon(callbackImage);
            if (value != null) {
                OperationInfo operationInfo = (OperationInfo)value;
                this.setText(operationInfo.getOperationName());
                if (operationInfo.belongsToCallbackPortType()) {
                    this.setIcon(callbackImageIcon);
                } else {
                    this.setIcon(serviceImageIcon);
                }
            } else {
                this.setIcon(null);
                this.setText("");
            }
            return this;
        }
    }
}

