/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.humantask;

import oracle.bpm.adapter.Adaptable;
import oracle.bpm.designer.HumanTaskData;
import oracle.bpm.designer.HumanTaskPreferences;
import oracle.bpm.designer.HumanTaskService;
import oracle.bpm.fusion.soa.humantask.HumanTaskDialog;
import oracle.bpm.fusion.soa.humantask.HumanTaskPanel;
import oracle.bpm.fusion.soa.msg.FusionSoaMsg;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.ide.model.Project;

public class HumanTaskServiceImpl
implements HumanTaskService {
    private static HumanTaskServiceImpl instance = null;

    private HumanTaskServiceImpl() {
    }

    public static HumanTaskServiceImpl getInstance() {
        if (instance == null) {
            instance = new HumanTaskServiceImpl();
        }
        return instance;
    }

    public HumanTaskData createHumanTask(UiWindow parent, UserTask userTask, HumanTaskPreferences humanTaskPreferences) {
        HumanTaskData result = null;
        oracle.bpm.project.model.Project project = userTask.getProject();
        if (project instanceof Adaptable) {
            Adaptable adaptable = (Adaptable)project;
            Project jdevProject = adaptable.as(Project.class);
            if (jdevProject != null) {
                HumanTaskDialog dialog = HumanTaskPanel.createDialog(parent, userTask, humanTaskPreferences);
                dialog.setVisible(true);
                if (dialog.userAccepted()) {
                    result = dialog.getHumanTaskData();
                }
            } else {
                MessageDialog.showError((UiContainer)parent, (Msg)FusionSoaMsg.ERROR_NO_JDEV_PROJECT_HUMANTASK(project.getId()));
            }
        }
        return result;
    }
}

