/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.action;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.bpa.bpmn.util.BPELWriter;
import oracle.bpa.sync.BPELSync;
import oracle.bpm.fusion.repository.fs.FusionFileSystem;
import oracle.bpm.project.model.processes.Process;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.bpeldesignerplugins.plugins.outliner.plugin.OutlinerBPELModelerPlugin;
import oracle.tip.tools.ide.bpeldesignerplugins.plugins.outliner.util.BPAServerDownloadUtil;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.IDE;
import oracle.tip.tools.ide.common.ide.IDEResolver;
import oracle.tip.tools.ide.common.jdev.JDevHelper;
import oracle.tip.tools.ide.common.ui.BaseDialog;
import oracle.tip.tools.ide.fabric.addin.SCAProject;
import oracle.tip.tools.ide.fabricplugins.plugins.bpa.app.BPELDetailsPanel;
import oracle.tip.tools.ide.fabricplugins.plugins.bpa.app.MergeNotNeededException;
import oracle.tip.tools.ide.pm.addin.model.BPELNode;
import oracle.tip.tools.ide.pm.addin.view.BPELXmlVisualEditor;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class MergeDialog
extends BaseDialog
implements ActionListener {
    protected Project jdev_project;
    protected BPELDetailsPanel m_bpelDetailsPnl;
    protected JButton m_cancelBtn;
    protected JButton m_okBtn;
    protected Process m_process;
    protected oracle.bpm.project.model.Project m_project;
    protected int m_retVal = 1;
    protected String m_uiMergeDir;
    public boolean merge_ok = true;
    private BPELSync sync;
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private static final String BPEL = "bpel";
    private static final String BPEL_EXT = ".bpel";

    public MergeDialog(JFrame f, oracle.bpm.project.model.Project project, Process process, Project p) {
        super(f, BPELStringTranslator.getString((String)"OUTLINER_REFRESH_FROM_BPMN"), true);
        this.m_project = project;
        this.m_process = process;
        this.jdev_project = p;
        this.createControls();
        this.layoutControls();
        this.updateControls();
    }

    public int display() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                MergeDialog.this.loadControls();
            }
        };
        new Thread(r).start();
        this.setVisible(true);
        return this.m_retVal;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_okBtn) {
            this.handleOK();
        }
    }

    public void doMerge() {
        this.enableUserInput(false);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    MergeDialog.this.mergeComposites();
                }
                catch (Throwable e) {
                    MergeDialog.this.merge_ok = false;
                    GraphUtils.displayError((Component)((Object)MergeDialog.this), (Throwable)e);
                }
                finally {
                    MergeDialog.this.enableUserInput(true);
                    MergeDialog.this.updateControls();
                }
            }
        };
        new Thread(r).run();
    }

    protected void loadControls() {
    }

    protected void createControls() {
        this.m_bpelDetailsPnl = new BPELDetailsPanel();
        this.m_okBtn = new JButton();
        this.m_okBtn.setEnabled(false);
        BPELStringTranslator.setButton((AbstractButton)this.m_okBtn, (String)BPELStringTranslator.getString((String)"OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton();
        BPELStringTranslator.setButton((AbstractButton)this.m_cancelBtn, (String)BPELStringTranslator.getString((String)"CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container p = this.getContentPane();
        p.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)p, (Component)this.m_bpelDetailsPnl, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(5, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)p, (Component)btnPnl, (int)0, (int)row, (int)2, (int)1, (int)14, (int)0, (Insets)new Insets(0, 0, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(650, 500);
        GraphUtils.centerInScreen((Component)((Object)this));
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    public void handleOK() {
        String msg = BPELStringTranslator.getString((String)"OUTLINER_ACCEPT_MERGE_MSG");
        this.m_retVal = 0;
        this.dispose();
        try {
            List editors = JDevHelper.getEditorsEditingProject((Project)this.jdev_project);
            this.reloadWithMergedComposite(editors);
        }
        catch (Exception e) {
            GraphUtils.displayError((Component)IDEResolver.getIDE().getFrame(), (Throwable)e);
        }
    }

    protected void updateControls() {
        this.m_okBtn.setEnabled(true);
    }

    protected void mergeComposites() throws MergeNotNeededException, Exception {
        URL uiMergingDirURL;
        URL mergeDir = OutlinerBPELModelerPlugin.getMergeOutputDir();
        if (!URLFileSystem.exists((URL)mergeDir) && !URLFileSystem.mkdir((URL)mergeDir)) {
            throw new Exception(BPELStringTranslator.formatString((String)"OUTLINER_UNABLE_TO_CREATE_DIR", (String)mergeDir.toExternalForm()));
        }
        String tempDirName = this.getUniqueDirName(Helper.getFile((URL)mergeDir));
        URL tempDir = URLFactory.newDirURL((URL)mergeDir, (String)tempDirName);
        if (!URLFileSystem.mkdir((URL)tempDir)) {
            throw new Exception(BPELStringTranslator.formatString((String)"OUTLINER_UNABLE_TO_CREATE_DIR", (String)mergeDir.toExternalForm()));
        }
        URL outDirURL = URLFactory.newDirURL((URL)tempDir, (String)"output");
        URL logDirURL = URLFactory.newDirURL((URL)tempDir, (String)"log");
        URLFileSystem.mkdir((URL)logDirURL);
        URL logFileURL = URLFactory.newURL((URL)logDirURL, (String)"log.txt");
        File logFile = Helper.getFile((URL)logFileURL);
        URL downloadDirURL = URLFactory.newDirURL((URL)tempDir, (String)"server_download");
        if (!URLFileSystem.exists((URL)downloadDirURL)) {
            URLFileSystem.mkdir((URL)downloadDirURL);
        }
        if (!URLFileSystem.exists((URL)(uiMergingDirURL = URLFactory.newDirURL((URL)tempDir, (String)"uimerge")))) {
            URLFileSystem.mkdir((URL)uiMergingDirURL);
        }
        URL downloadZipURL = URLFactory.newURL((URL)downloadDirURL, (String)"serverComposite.zip");
        new File(downloadZipURL.getPath()).createNewFile();
        String itDir = ((FusionFileSystem)this.m_project.getLoader().getProjectFileSystem().getDataFileSystem()).getFileSystemRoot().toString();
        if (!itDir.endsWith(File.separator)) {
            itDir = itDir + File.separator;
        }
        ZipOutputStream os = new ZipOutputStream(new FileOutputStream(new File(downloadZipURL.getPath())));
        BPELWriter bpelWriter = new BPELWriter(os, Boolean.valueOf(true), Locale.US, new File(itDir));
        bpelWriter.parse(this.m_process);
        bpelWriter.save();
        URL serverExtractionDir = URLFactory.newDirURL((URL)downloadDirURL, (String)"extraction");
        BPAServerDownloadUtil.extractZipFile((File)Helper.getFile((URL)downloadZipURL), (File)Helper.getFile((URL)serverExtractionDir));
        String outputDir = Helper.getPath((URL)outDirURL);
        String analystDir = Helper.getPath((URL)serverExtractionDir);
        this.sync = new BPELSync(this.getBpel(itDir), this.getBpel(analystDir), this.getBpel(itDir), itDir, analystDir, outputDir, logFile);
        this.sync.setCompareAnnotations(true);
        this.sync.setBpelOnly(true);
        this.sync.identifyDifferences();
        this.m_bpelDetailsPnl.setBPELSync(this.sync);
        this.sync.merge();
        String target = Helper.getPath((URL)uiMergingDirURL);
        BPAServerDownloadUtil.copyFiles((String)analystDir, (String)target);
        BPAServerDownloadUtil.copyFiles((String)outputDir, (String)target);
        this.m_uiMergeDir = target;
    }

    protected String getUniqueDirName(File parentDir) {
        String prefix = "merge_output_";
        int cnt = 0;
        String name = prefix + cnt;
        boolean bExists = false;
        block0: do {
            File[] lst;
            bExists = false;
            name = prefix + ++cnt;
            for (File f : lst = parentDir.listFiles()) {
                String dirName;
                if (!f.isDirectory() || !(dirName = f.getName()).equalsIgnoreCase(name)) continue;
                bExists = true;
                continue block0;
            }
        } while (bExists);
        return name;
    }

    private void reloadWithMergedComposite(List<Editor> editors) throws Exception {
        ArrayList<Node> closedNodes = new ArrayList<Node>();
        for (Editor e : editors) {
            Node node;
            Context ct;
            if (!(e instanceof BPELXmlVisualEditor) || (ct = e.getContext()) == null || !((node = ct.getNode()) instanceof BPELNode)) continue;
            if (!closedNodes.contains(node)) {
                closedNodes.add(node);
            }
            node.close();
        }
        SCAProject project = SCAProject.getSCAProject((Project)this.jdev_project);
        Project p = this.jdev_project;
        Iterator it = p.getChildren();
        while (it.hasNext()) {
            Node n;
            Object o = it.next();
            if (o instanceof Node && !(n = (Node)o).isOpen()) continue;
        }
        URL projectURL = project.getProjectRoot();
        String target = Helper.getPath((URL)projectURL);
        String source = this.m_uiMergeDir;
        BPAServerDownloadUtil.copyFiles((String)source, (String)target);
        IDE ide = IDEResolver.getIDE();
        for (Node n : closedNodes) {
            URL url = n.getURL();
            ide.openEditor(url);
        }
    }

    private void openComposite(URL u) {
        final Node n = NodeFactory.find((URL)u);
        System.out.println("n = " + n + " url=" + u);
        if (n != null) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        n.open();
                        IDEResolver.getIDE().openEditor(n.getURL());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    private oracle.tip.tools.ide.common.bpelparser.iface.Process getBpel(String dir) throws Exception {
        oracle.tip.tools.ide.common.bpelparser.iface.Process p = BPELParser.load((InputStream)new FileInputStream(new File(dir, this.m_process.getDefaultLabel() + BPEL_EXT)));
        return p;
    }
}

