/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.action;

import java.awt.Component;
import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import javax.swing.SwingUtilities;
import oracle.bpa.bpmn.util.BPELWriter;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.fusion.repository.fs.FusionFileSystem;
import oracle.bpm.fusion.soa.action.MergeDialog;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.resources.Msg;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.IDE;
import oracle.tip.tools.ide.common.ide.IDEResolver;
import oracle.tip.tools.ide.fabric.api.SCAControllerImpl;

public class ExportProcessAsBPELAction
extends DesignerAction {
    private static final String BPEL = "bpel";
    private static final String BPEL_EXT = ".bpel";

    public ExportProcessAsBPELAction() {
        super(DesignerMsg.EXPORT_PROCESS_AS_BPEL);
        this.requires(Process.class);
    }

    public ExportProcessAsBPELAction(Msg msg) {
        super(msg);
        this.requires(Process.class);
    }

    public void run() {
        this.exportProcessAsBpel();
    }

    public Process getProcess() {
        return (Process)this.getSelection().as(Process.class);
    }

    private static Project getProject(URL projectURL) throws Exception {
        Project p = null;
        URL[] urls = URLFileSystem.list((URL)projectURL);
        if (urls != null) {
            for (URL url : urls) {
                if (!URLFileSystem.hasSuffix((URL)url, (String)".jpr")) continue;
                p = (Project)NodeFactory.findOrCreate((URL)url);
                break;
            }
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportProcessAsBpel() {
        block11: {
            try {
                Process process = this.getProcess();
                oracle.bpm.project.model.Project project = process.getProject();
                File projectDirectory = ((FusionFileSystem)project.getLoader().getProjectFileSystem().getDataFileSystem()).getFileSystemRoot();
                boolean previouslyExported = new File(projectDirectory, this.getProcess().getDefaultLabel() + BPEL_EXT).exists();
                if (previouslyExported) {
                    Project p = ExportProcessAsBPELAction.getProject(projectDirectory.toURI().toURL());
                    MergeDialog dlg = new MergeDialog(IDEResolver.getIDE().getFrame(), project, process, p);
                    dlg.doMerge();
                    if (dlg.merge_ok) {
                        dlg.display();
                    }
                    IDE ide = IDEResolver.getIDE();
                    URL bpelURL = new File(projectDirectory, this.getProcess().getDefaultLabel() + BPEL_EXT).toURI().toURL();
                    ide.openEditor(bpelURL);
                    break block11;
                }
                BPELWriter bpelWriter = new BPELWriter(projectDirectory, Boolean.valueOf(true), project.getDefaultLanguage());
                bpelWriter.parse(this.getProcess());
                String name = process.getDefaultLabel() + BPEL_EXT;
                File file = new File(projectDirectory, name);
                URL url = file.toURI().toURL();
                OutputStream out = null;
                try {
                    out = URLFileSystem.openOutputStream((URL)url);
                    bpelWriter.save(out);
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
                IDE ide = IDEResolver.getIDE();
                URL bpelURL = new File(projectDirectory, this.getProcess().getDefaultLabel() + BPEL_EXT).toURI().toURL();
                ide.openEditor(bpelURL);
                final Project p = ExportProcessAsBPELAction.getProject(projectDirectory.toURI().toURL());
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        UpdateMessage.fireStructureChanged((Subject)p);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    r.run();
                } else {
                    SwingUtilities.invokeLater(r);
                }
                SCAControllerImpl si = new SCAControllerImpl(p);
                si.updateComponent(this.getProcess().getDefaultLabel(), BPEL, this.getProcess().getDefaultLabel() + BPEL_EXT);
                if (this.getProcess().getAnnotationValue("BPEL.IMPLEMENTATION", false) == null) {
                    this.getProcess().addAnnotation("BPEL.IMPLEMENTATION", this.getProcess().getDefaultLabel() + BPEL_EXT, false);
                }
            }
            catch (Throwable e) {
                GraphUtils.displayError((Component)IDEResolver.getIDE().getFrame(), (Throwable)e);
            }
        }
    }
}

