/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmltype;

import java.io.File;
import java.net.MalformedURLException;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Insets;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.ui.BorderPanel;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.IdentifierModuleTextField;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.filechooser.FileChooser;
import oracle.bpm.ui.layout.GridBagConstraints;
import oracle.bpm.ui.layout.GridBagLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.wizards.model.Wizard;
import oracle.bpm.ui.wizards.model.WizardStep;
import oracle.bpm.ui.wizards.ui.WizardStepPanel;
import oracle.bpm.util.FileFilter;
import oracle.bpm.util.Identifier;
import oracle.bpm.xml.msg.XmlMsg;

class URLStepPanel
extends WizardStepPanel {
    Button browseButton;
    IdentifierTextField moduleTextField;
    TextField urlTextField;

    public URLStepPanel(UiContainer parent, WizardStep wizardStep) {
        super(parent, wizardStep);
    }

    public String getModule() {
        return this.moduleTextField.getText();
    }

    public String getURL() {
        return this.urlTextField.getText();
    }

    @Override
    public UiComponent createCenterPage(UiContainer parent) {
        String schema;
        this.setPageTitle(XmlMsg.XML_PROPERTIES);
        this.setPageDesc(XmlMsg.XML_PROPERTIES_DESCR);
        BorderPanel centerPanel = new BorderPanel(parent);
        centerPanel.setLayout(new GridBagLayout());
        this.urlTextField = new TextField(centerPanel);
        Object wizard = this.getWizardStep().getWizard();
        String fileToIntrospect = (String)((Wizard)wizard).getProperty("File_To_Introspect");
        String module = (String)((Wizard)wizard).getProperty("moduleName");
        boolean reintrospect = ((Wizard)wizard).getProperty("reintrospecting") != null;
        File projectBaseDir = (File)((Wizard)wizard).getProperty("projectBaseDir");
        String string = schema = fileToIntrospect != null ? fileToIntrospect : (String)((Wizard)wizard).getProperty("xmlschema");
        if (!schema.startsWith("http:") && projectBaseDir != null && schema.startsWith("PROJECT_BASE_DIR")) {
            schema = projectBaseDir.getAbsolutePath() + schema.substring("PROJECT_BASE_DIR".length());
        }
        this.urlTextField.setText(schema);
        this.urlTextField.addDocumentListener(new DocumentListener.Default(){

            @Override
            public void anyUpdate(DocumentEvent e) {
                URLStepPanel.this.urlUpdated();
            }
        });
        this.browseButton = new Button(centerPanel);
        this.browseButton.setText("...");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                URLStepPanel.this.chooseFile();
            }
        });
        this.moduleTextField = new IdentifierModuleTextField(centerPanel);
        if (module != null) {
            this.moduleTextField.setText(module);
            this.moduleTextField.setEnabled(!reintrospect);
        } else {
            this.moduleTextField.setText("Unnamed");
        }
        Label label = Label.create((UiContainer)centerPanel, LibMsg.TYPE_MODULE);
        LabelMultiline msgTextArea = URLStepPanel.createTextArea((UiContainer)centerPanel, XmlMsg.URL_STEP_MSG);
        centerPanel.add(msgTextArea, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        centerPanel.add(Box.createVerticalStrut(centerPanel, 20), new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        centerPanel.add(Label.create((UiContainer)centerPanel, XmlMsg.URL_STEP_WSDL_URL), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        centerPanel.add(this.urlTextField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 1), 0, 0));
        centerPanel.add(this.browseButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 1, 5, 5), 0, 0));
        centerPanel.add(label, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 1), 0, 0));
        centerPanel.add(this.moduleTextField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 1), 0, 0));
        return centerPanel;
    }

    @Override
    public boolean validateInput() {
        String url = this.urlTextField.getText().trim();
        String moduleName = this.moduleTextField.getText().trim();
        if ("".equals(url)) {
            MessageDialog.showError(XmlMsg.URL_STEP_EMTPY_ADDRESS);
            return false;
        }
        if ("".equals(moduleName)) {
            MessageDialog.showError(XmlMsg.EMPTY_MODULE);
            return false;
        }
        return true;
    }

    @Override
    public Dimension getMinimumSize() {
        return Dimension.valueOf(350, 200);
    }

    private void chooseFile() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setFileFilter(FileFilter.create(UIMsg.XSD_FILES, "xsd"));
        int returnVal = fileChooser.showOpenDialog(Ui.getRoot());
        if (returnVal != 0) {
            return;
        }
        String fileChosen = null;
        try {
            fileChosen = fileChooser.getSelectedFile().toURL().toString();
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        this.urlTextField.setText(fileChosen);
    }

    private void urlUpdated() {
        if ("Unnamed".equals(this.moduleTextField.getText())) {
            String text = this.urlTextField.getText();
            if ((text = Identifier.classnameFromUrl(text)) != null && text.length() > 0) {
                this.moduleTextField.setText(text);
            }
        }
    }
}

