/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlschema;

import java.net.URL;
import oracle.bpm.lang.DefaultException;
import oracle.bpm.resources.Msg;
import oracle.bpm.xmlschema.Schema;
import oracle.bpm.xmlschema.SchemaElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeException
extends DefaultException {
    protected SchemaElement element;
    static final long serialVersionUID = -7598313651784993183L;
    static final long serialCheck = -5293016391988301756L;

    public TypeException(@Nullable SchemaElement element, @NotNull Msg msgCode) {
        if (msgCode == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/xmlschema/TypeException.<init> must not be null");
        }
        this.setKey(msgCode);
        this.element = element;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (this.element != null) {
            message = message + "\nfile: " + this.getFile();
            message = message + "\npath: " + this.getPath();
        }
        return message;
    }

    URL getDocumentURL() {
        Schema schema;
        URL url = null;
        if (this.element != null && (schema = this.element.getSchema()) != null) {
            url = schema.getLocation();
        }
        return url;
    }

    void setElement(SchemaElement element) {
        this.element = element;
    }

    String getFile() {
        String file = null;
        URL url = this.getDocumentURL();
        if (url != null && (file = url.getFile()) != null) {
            int index = file.lastIndexOf(47);
            file = file.substring(index + 1);
        }
        return file;
    }

    String getPath() {
        return this.element != null ? this.element.contextPath() : "";
    }
}

