/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlschema;

import oracle.bpm.lang.JavaEnumTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.util.Identifier;
import oracle.bpm.xmlschema.ElementType;
import oracle.bpm.xmlschema.Restriction;
import oracle.bpm.xmlschema.SchemaElement;
import oracle.bpm.xmlschema.TypeException;

public class SimpleType
extends SchemaElement {
    public Restriction getRestriction() {
        return (Restriction)this.getElement(ElementType.findByType(32));
    }

    @Override
    protected TypeDescription buildType(TypeDescription current) throws TypeException {
        TypeDescription result;
        if (this.type != null) {
            return this.type;
        }
        String type = this.getType();
        String name = this.getName();
        name = Identifier.classname(name);
        TypeDescription simpleType = type != null ? this.findType(type, TypeFactory.getString()) : this.buildSubElements(current);
        if (simpleType != null && simpleType.isEnum() && name != null) {
            JavaEnumTypeDescription enumType = (JavaEnumTypeDescription)simpleType;
            enumType.setName(name);
        }
        this.type = result = SimpleType.ensureIsSimple(simpleType);
        return result;
    }

    @Override
    protected void declare() throws TypeException {
        String name = this.getName();
        if (name != null) {
            this.getTarget().declareType(name, this);
        }
    }

    static TypeDescription ensureIsSimple(TypeDescription type) {
        if (type == null) {
            type = TypeFactory.getString();
        }
        if (!(type.isPredefined() || type.isEnum() || type.isArray())) {
            type = TypeFactory.getString();
        } else if (type.isAny()) {
            type = TypeFactory.getString();
        }
        return type;
    }

    private String getName() {
        return this.getAttribute("name");
    }

    private String getType() {
        return this.getAttribute("type");
    }
}

