/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlschema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.lang.Literals;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeWriter;
import oracle.bpm.util.ProgressMonitor;
import oracle.bpm.xml.XmlWriter;
import oracle.bpm.xml.msg.XmlMsg;
import oracle.bpm.xmlparser.DefaultElement;
import oracle.bpm.xmlparser.MessageListener;
import oracle.bpm.xmlparser.NamespaceContext;
import oracle.bpm.xmlparser.Parser;
import oracle.bpm.xmlparser.ParserException;
import oracle.bpm.xmlschema.Context;
import oracle.bpm.xmlschema.ExtendedNamespace;
import oracle.bpm.xmlschema.InvalidRootException;
import oracle.bpm.xmlschema.Schema;
import oracle.bpm.xmlschema.SchemaElement;
import oracle.bpm.xmlschema.SchemaElementFactory;
import oracle.bpm.xmlschema.TypeException;
import oracle.bpm.xmltype.EntityResolver;
import oracle.bpm.xmltype.ModuleResolver;
import org.xml.sax.SAXException;

public class SchemaParser
extends Parser {
    private boolean dumpTree;
    private ModuleResolver moduleResolver;
    private ProgressMonitor monitor;
    private Context parentCtx;
    private Map<URL, Schema> parsedFiles = new LinkedHashMap<URL, Schema>();
    private EntityResolver resolver;
    private NamespaceContext rootNamespaceContext;
    private Map<URL, String> schemaLocationKeys = new LinkedHashMap<URL, String>();

    public SchemaParser() {
        this.moduleResolver = new DefaultModuleResolver();
        super.setElementFactory(new SchemaElementFactory());
        this.setMessageListener(new MessageListener(){

            @Override
            public void error(int line, int column, String message) {
                if (SchemaParser.this.monitor != null) {
                    SchemaParser.this.monitor.error(XmlMsg.EMPTY(message));
                }
            }

            @Override
            public void warning(int line, int column, String message) {
                if (SchemaParser.this.monitor != null) {
                    SchemaParser.this.monitor.warning(XmlMsg.EMPTY(message));
                }
            }

            @Override
            public void info(String message) {
                if (SchemaParser.this.monitor != null) {
                    SchemaParser.this.monitor.info(0, XmlMsg.EMPTY(message));
                }
            }
        });
    }

    public static void main(String[] args) throws Exception {
        try {
            if (args.length < 1) {
                System.err.println("Usage: fuegoxml [options] <xmlFiles>");
                System.err.println();
                System.err.println("\t-t     print generated types.");
                System.err.println("\t-d     dump xml tree.");
                System.err.println("\t-v     verbose mode.");
                System.err.println();
                System.exit(1);
            }
            StringList files = StringList.create();
            boolean printTypes = false;
            boolean dumpTree = false;
            boolean verbose = false;
            for (String arg : args) {
                if ("-t".equals(arg)) {
                    printTypes = true;
                    continue;
                }
                if ("-d".equals(arg)) {
                    dumpTree = true;
                    continue;
                }
                if ("-v".equals(arg)) {
                    verbose = true;
                    continue;
                }
                if (arg.startsWith("-")) {
                    System.err.println("Unknown option : " + arg);
                    System.exit(1);
                    continue;
                }
                files.add(arg);
            }
            SchemaParser schemaParser = new SchemaParser();
            schemaParser.setDumpTree(dumpTree);
            if (verbose) {
                schemaParser.setMessageListener(new MessageListener(){

                    @Override
                    public void error(int line, int column, String message) {
                    }

                    @Override
                    public void warning(int line, int column, String message) {
                    }

                    @Override
                    public void info(String message) {
                        System.out.println(message);
                    }
                });
            }
            for (String elem : files) {
                String file = elem.toString();
                URL location = new File(file).toURL();
                System.out.println("parsing " + file + "...");
                Schema schema = schemaParser.compile(location);
                ExtendedNamespace target = schema.getContext().getTarget();
                for (SAXException error : schemaParser.getErrors()) {
                    System.out.println("error: " + error.getMessage());
                }
                for (SAXException warning : schemaParser.getWarnings()) {
                    System.out.println("warning: " + warning.getMessage());
                }
                if (!printTypes) continue;
                Map<String, TypeDescription> definedTypes = target.getDefinedTypes();
                Set<Map.Entry<String, TypeDescription>> entries = definedTypes.entrySet();
                for (Map.Entry<String, TypeDescription> entry : entries) {
                    String name = entry.getKey();
                    TypeDescription type = entry.getValue();
                    if (name.length() < 15) {
                        name = Str.pad(name, 15);
                    }
                    System.out.print(name + " : ");
                    if (type.isObject() || type.isEnum()) {
                        StringWriter out = new StringWriter();
                        XmlWriter xml = new XmlWriter(out, Literals.DEFAULT_ENCODING);
                        xml.setIndentAttributes(true);
                        TypeWriter.writeXml(xml, type.asObject());
                        xml.close();
                        System.out.println(out.toString());
                        System.out.println("\n" + out.toString());
                        continue;
                    }
                    System.out.println(type.getText());
                }
            }
        }
        catch (Throwable e) {
            System.out.println("error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void setMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public ProgressMonitor getMonitor() {
        return this.monitor;
    }

    public Schema compile(URL location) throws ParserException, TypeException {
        try {
            Schema result = this.parsedFiles.get(location);
            if (result == null) {
                this.info("parsing " + location);
                result = this.compile(location, location.openStream());
            }
            return result;
        }
        catch (IOException e) {
            throw new ParserException(e);
        }
    }

    public String getSchemaLocationKey(URL location) {
        return this.schemaLocationKeys.get(location);
    }

    public void putSchemaLocationKey(URL location, String key) {
        assert (location != null) : "location can not be null";
        assert (key != null) : "schema location key can not be null";
        this.schemaLocationKeys.put(location, key);
    }

    public Schema parseSchema(URL location, InputStream source) throws InvalidRootException, ParserException {
        SchemaElement root = (SchemaElement)super.parse(location, source);
        if (!(root instanceof Schema)) {
            throw new InvalidRootException(root.getTagName());
        }
        return (Schema)root;
    }

    public Schema parseSchema(URL location, String schemaText) throws ParserException, InvalidRootException {
        DefaultElement root = (DefaultElement)super.parse(location, schemaText);
        if (!(root instanceof Schema)) {
            throw new InvalidRootException(root.getTagName());
        }
        return (Schema)root;
    }

    public Schema compile(URL location, InputStream source) throws ParserException, TypeException {
        Schema schema = this.parseSchema(location, source);
        this.parsedFiles.put(location, schema);
        if (this.dumpTree) {
            schema.dump(new IndentedPrintWriter(System.out, true), "utf-8");
        }
        this.info("analyzing " + location);
        schema.declare();
        schema.buildType(null);
        ExtendedNamespace target = schema.getContext().getTarget();
        this.info(target.getUri() + " compiled");
        return schema;
    }

    public ExtendedNamespace importSchema(Context ctx, URL schemaLocation) throws ParserException, TypeException {
        Schema schema = this.compile(schemaLocation);
        ExtendedNamespace ns = schema.getContext().getTarget();
        ctx.setNamespace(ns);
        return ns;
    }

    public ExtendedNamespace importSchema(Context ctx, URL location, InputStream reader) throws ParserException, TypeException {
        Schema result = this.parsedFiles.get(location);
        if (result == null) {
            this.info("parsing " + location);
            result = this.compile(location, reader);
        }
        ExtendedNamespace ns = result.getContext().getTarget();
        ctx.setNamespace(ns);
        return ns;
    }

    public ExtendedNamespace includeSchema(Context ctx, URL schemaLocation) throws ParserException, TypeException {
        Context oldContext = this.parentCtx;
        this.parentCtx = ctx;
        Schema schema = this.compile(schemaLocation);
        ExtendedNamespace nspace = schema.getContext().getTarget();
        ctx.updateNamespace(nspace);
        this.parentCtx = oldContext;
        return nspace;
    }

    public void interrupt() {
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        if (this.parentCtx != null) {
            this.pushContext(this.parentCtx);
            this.parentCtx = null;
        }
    }

    public Schema[] getParsedSchemas() {
        Collection<Schema> values = this.parsedFiles.values();
        Schema[] result = new Schema[values.size()];
        values.toArray(result);
        return result;
    }

    public Map<URL, Schema> getParsedFiles() {
        return this.parsedFiles;
    }

    public void setXsdImportResolver(EntityResolver resolver) {
        this.resolver = resolver;
    }

    public void setModuleResolver(ModuleResolver moduleResolver) {
        this.moduleResolver = moduleResolver != null ? moduleResolver : new DefaultModuleResolver();
    }

    public ModuleResolver getModuleResolver() {
        return this.moduleResolver;
    }

    public EntityResolver getXsdImportResolver() {
        return this.resolver;
    }

    @Override
    public NamespaceContext getRootNamespaceContext() {
        return this.rootNamespaceContext;
    }

    public void setNamespaceContext(NamespaceContext context) {
        this.rootNamespaceContext = context;
    }

    protected void setDumpTree(boolean dumpTree) {
        this.dumpTree = dumpTree;
    }

    @Override
    protected NamespaceContext createContext(NamespaceContext parent) {
        return new Context(parent);
    }

    static class DefaultModuleResolver
    implements ModuleResolver {
        DefaultModuleResolver() {
        }

        @Override
        public ObjectTypeDescription resolveModule(ObjectTypeDescription introspectionRootModule, ObjectTypeDescription wsdlRootModule, ObjectTypeDescription type) {
            return wsdlRootModule;
        }

        @Override
        public TypeDescription resolveType(SchemaElement element, Context context) throws TypeException {
            return null;
        }
    }
}

