/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlschema;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import oracle.bpm.extension.Extension;
import oracle.bpm.extensionpoint.metadata.IntrospectorMetadata;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.Literals;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.IntrospectionException;
import oracle.bpm.type.Introspector;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.SourceCode;
import oracle.bpm.type.TypeBeautifier;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.type.catalog.DirectoryComponentBundle;
import oracle.bpm.util.ProgressMonitor;
import oracle.bpm.xml.XmlWriter;
import oracle.bpm.xml.msg.XmlMsg;
import oracle.bpm.xmlschema.Schema;
import oracle.bpm.xmlschema.TypeException;

public class SchemaGenerator {
    private String module;
    private ProgressMonitor monitor;
    private File outputFile;
    private MutableComponentCatalog repository;

    public SchemaGenerator(MutableComponentCatalog repository) {
        this.repository = repository;
        this.monitor = new ProgressMonitor(){

            @Override
            public void progress(int percent) {
            }

            @Override
            public void error(Msg message) {
                System.err.println("error: " + message.getString());
            }

            @Override
            public void info(Msg message) {
                System.out.println("info: " + message.getString());
            }

            @Override
            public void info(int logLevel, Msg message) {
                this.info(message);
            }

            @Override
            public void warning(Msg message) {
                System.out.println("warning: " + message.getString());
            }

            @Override
            public void phase(Msg message) {
            }
        };
    }

    public static void main(String[] args) {
        try {
            if (args.length != 3) {
                System.out.println("Usage: schemagenerator <catalogDir> <module> <outputfile>");
                return;
            }
            String catalogDir = args[0];
            String module = args[1];
            MutableComponentCatalog repository = TypeUtils.createComponentCatalog(TypeUtils.getDefaultCatalog());
            repository.setDescription("schema-generator");
            repository.addComponentBundle(new DirectoryComponentBundle(new File(catalogDir)));
            repository.sync();
            SchemaGenerator generator = new SchemaGenerator(repository);
            generator.setModule(module);
            generator.setOutputFile(new File(args[2]));
            generator.generate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getModule() {
        return this.module;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void generate() throws TypeCatalogException, IOException, TypeException, IntrospectionException {
        ObjectTypeDescription module = this.getModuleType();
        TypeRef xmlModule = module.findInnerType("Xml");
        if (xmlModule != null) {
            this.repository.remove(xmlModule.getText());
            module.removeInnerType(xmlModule);
        }
        this.createSchema();
    }

    void updateSourceObjects() throws TypeCatalogException {
        ObjectTypeDescription module = this.getModuleType();
        int count = module.getInnerTypeCount();
        for (int i = 0; i < count; ++i) {
            ObjectTypeDescription innerType = module.getInnerType(i);
            if (innerType.getName().equals("Xml")) continue;
            this.addDelegate(innerType);
            this.updateAttributes(innerType);
        }
    }

    private TypeDescription getDelegateForType(ObjectTypeDescription innerType) throws TypeCatalogException {
        String delegateName = innerType.getParent().getText() + ".Xml.Xml" + innerType.getName();
        TypeRef delegateRef = this.repository.find(delegateName);
        return delegateRef.get();
    }

    private ObjectTypeDescription getModuleType() throws TypeCatalogException {
        return this.repository.find(this.module).get().asObject();
    }

    private void addDelegate(ObjectTypeDescription innerType) throws TypeCatalogException {
        TypeDescription delegateType = this.getDelegateForType(innerType);
        boolean added = false;
        for (SuperType superType : innerType.getSuperTypes()) {
            if (superType.getType() != delegateType) continue;
            added = true;
            break;
        }
        if (!added) {
            innerType.addSuperType(new SuperType(delegateType, 0x800000L));
        }
        this.repository.update(innerType);
    }

    private void createSchema() throws TypeCatalogException, TypeException, IOException {
        ObjectTypeDescription module = this.getModuleType();
        Schema schema = new Schema(module.getText());
        int count = module.getInnerTypeCount();
        for (int i = 0; i < count; ++i) {
            ObjectTypeDescription innerType = module.getInnerType(i);
            schema.addType(innerType);
        }
        schema.declare();
        schema.createXsd();
        XmlWriter xml = new XmlWriter(new FileWriter(this.getOutputFile()), Literals.DEFAULT_ENCODING);
        schema.generateXml(xml);
        xml.close();
    }

    private ObjectTypeDescription[] introspectSchema() throws IntrospectionException {
        Extension<IntrospectorMetadata> extension = Introspector.Extension.find("xml");
        try {
            Introspector introspector = extension.instantiateAs(Introspector.class);
            Map<String, Object> props = introspector.defaultProperties();
            props.put("xmlschema", this.getOutputFile().getAbsolutePath());
            props.put("moduleName", "Xml");
            props.put("TYPE_PREFIX", "Xml");
            ObjectTypeDescription[] objects = introspector.introspect(props, this.repository, this.monitor);
            TypeBeautifier beautifier = new TypeBeautifier();
            beautifier.beautify(objects, this.monitor, props);
            return objects;
        }
        catch (InstantiationException e) {
            throw new IntrospectionException(XmlMsg.INTROSPECTIONEXCEPTION(e.getMessage()), (Throwable)e);
        }
    }

    private void storeSchemaObjects(ObjectTypeDescription[] objects) throws TypeCatalogException {
        ObjectTypeDescription module = this.getModuleType();
        for (ObjectTypeDescription object : objects) {
            module.addInnerType(object);
            this.repository.add(object);
        }
    }

    private void updateAttributes(ObjectTypeDescription innerType) throws TypeCatalogException {
        TypeDescription delegate = this.getDelegateForType(innerType);
        int count = innerType.getMemberCount();
        for (int i = 0; i < count; ++i) {
            MethodTypeDescription member = innerType.getMember(i);
            if (member.isAttribute()) {
                String code;
                AttributeTypeDescription attribute = member.asAttribute();
                String message = "// This code is autogenerated, do not modify...\n";
                String qname = delegate.getText() + "." + attribute.getName();
                if (attribute.getType().isPredefined()) {
                    code = message + "return " + qname + "\n";
                    attribute.setCode(SourceCode.create(code, "Fuego"));
                    code = message + qname + " = value\n";
                    attribute.setWriteCode(SourceCode.create(code, "Fuego"));
                    member.addModifiers(0x20000000000L);
                } else {
                    code = message;
                    code = code + "return " + qname + "\n";
                    attribute.setCode(SourceCode.create(code, "Fuego"));
                    code = message + qname + " = value\n";
                    attribute.setWriteCode(SourceCode.create(code, "Fuego"));
                }
            }
            this.repository.update(innerType);
        }
    }
}

