/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlschema;

import oracle.bpm.xmlschema.InvalidAttrValueException;
import oracle.bpm.xmlschema.SchemaElement;

class Particle
extends SchemaElement {
    public Particle() {
    }

    public Particle(SchemaElement element) {
        super(element);
    }

    static int getMaxOccurs(SchemaElement elem) {
        int max;
        String maxOccurs = elem.getAttribute("maxOccurs");
        if (maxOccurs == null) {
            max = 1;
        } else if (maxOccurs.equals("unbounded") || maxOccurs.equals("*")) {
            max = Integer.MAX_VALUE;
        } else {
            try {
                max = Integer.parseInt(maxOccurs);
                if (max < 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                elem.reportError(new InvalidAttrValueException(elem, "maxOccurs", maxOccurs));
                max = Integer.MAX_VALUE;
            }
        }
        return max;
    }

    static int getMinOccurs(SchemaElement elem) {
        String minOccurs = elem.getAttribute("minOccurs");
        int min = 1;
        if (minOccurs == null) {
            min = 1;
        } else {
            try {
                min = Integer.parseInt(minOccurs);
                if (min < 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                elem.reportError(new InvalidAttrValueException(elem, "minOccurs", minOccurs));
                min = 0;
            }
        }
        return min;
    }

    int getMaxOccurs() {
        return Particle.getMaxOccurs(this);
    }

    int getMinOccurs() {
        return Particle.getMinOccurs(this);
    }
}

