/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlschema;

import oracle.bpm.lang.EnumTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.xmlschema.SchemaElement;

class Facet
extends SchemaElement {
    private int facet;
    static final int FACET_LENGTH = 1;
    static final int FACET_MIN_LENGTH = 2;
    static final int FACET_MAX_LENGTH = 3;
    static final int FACET_PATTERN = 4;
    static final int FACET_ENUMERATION = 5;
    static final int FACET_WHITE_SPACE = 6;
    static final int FACET_MAX_INCLUSIVE = 7;
    static final int FACET_MAX_EXCLUSIVE = 8;
    static final int FACET_MIN_INCLUSIVE = 9;
    static final int FACET_MIN_EXCLUSIVE = 10;
    static final int FACET_TOTAL_DIGITS = 11;
    static final int FACET_FRACTION_DIGITS = 12;

    Facet(int facet) {
        this.facet = facet;
    }

    @Override
    protected TypeDescription buildType(TypeDescription current) {
        switch (this.facet) {
            case 1: 
            case 3: {
                if (current == null || !current.isString()) break;
                try {
                    current = TypeFactory.getString(Integer.parseInt(this.getValue()));
                }
                catch (NumberFormatException e) {
                    this.reportError("Invalid length: '" + this.getValue() + "'");
                }
                break;
            }
            case 12: {
                if (current == null || !current.isDecimal()) break;
                break;
            }
            case 5: {
                if (current == null || !current.isEnum()) break;
                EnumTypeDescription enumType = (EnumTypeDescription)current;
                enumType.addItem(this.getValue(), enumType.getMemberCount());
                break;
            }
        }
        return current;
    }

    String getValue() {
        return this.getAttribute("value");
    }
}

