/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlschema;

import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.ValidationException;
import oracle.bpm.xmlschema.AttrGroupTypeDescription;
import oracle.bpm.xmlschema.ComponentDef;
import oracle.bpm.xmlschema.TypeException;
import oracle.bpm.xmltype.XMLIntrospector;

class Extension
extends ComponentDef {
    Extension() {
    }

    @Override
    protected TypeDescription buildType(TypeDescription current) throws TypeException {
        String base = this.getBase();
        TypeDescription baseType = XMLIntrospector.XMLOBJECT;
        Boolean implementsAbstract = false;
        if (base != null) {
            baseType = this.findType(base, baseType);
        }
        AttrGroupTypeDescription group = this.buildAttributes(baseType, true);
        if (baseType.isObject()) {
            ObjectTypeDescription subclass = super.buildType(current).asObject();
            subclass.addSuperType(new SuperType(baseType, 32768L));
            try {
                group.addTo(subclass);
            }
            catch (ValidationException e) {
                this.reportError("Internal error: " + e.getMessage());
            }
            if (baseType.isAbstract()) {
                implementsAbstract = true;
            }
            baseType = subclass;
            if (implementsAbstract.booleanValue()) {
                ((ObjectTypeDescription)baseType).setProperty("implementsAbstractType", Boolean.TRUE.toString());
            }
        } else if (group.hasAttributes()) {
            try {
                ObjectTypeDescription subclass = super.buildType(current).asObject();
                String signature = "Cvalue";
                AttributeTypeDescription value = new AttributeTypeDescription("value", baseType);
                value.setModifiers(12L);
                value.setReadSignature(signature + ";" + Extension.buildSignature(baseType));
                value.setWriteSignature(signature + ";" + Extension.buildSignature(baseType));
                subclass.addMember(value);
                group.addTo(subclass);
                baseType = subclass;
            }
            catch (ValidationException e) {
                this.reportError("Internal error: " + e.getMessage());
            }
        }
        return baseType;
    }

    String getBase() {
        return this.getAttribute("base");
    }
}

