/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlruntime;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.xmlruntime.SortedChildrenList;
import oracle.bpm.xmlruntime.XMLObject;
import oracle.bpm.xmlruntime.XMLSignatureParser;
import oracle.bpm.xmltype.XMLIntrospector;

public class XMLObjectTypeUpdater {
    private static final QName XSI_NILL_QNAME = new QName("http://www.w3.org/2001/XMLSchema-instance", "nil");

    private XMLObjectTypeUpdater() {
    }

    public static void updateTypeDescription(XMLObject object) {
        ObjectTypeDescription otd = object.getType().asObject();
        XMLObjectTypeUpdater.updateTypeDescription(object, otd);
    }

    public static void updateTypeDescription(XMLObject object, ObjectTypeDescription objectTypeDescription) {
        String objTypeDescName = objectTypeDescription.getQualifiedName();
        boolean isXMLObjectTypeDescription = XMLIntrospector.XMLOBJECT.getQualifiedName().equals(objTypeDescName);
        boolean isSoapFaulException = XMLIntrospector.SOAPFAULT.getQualifiedName().equals(objTypeDescName);
        if (!isXMLObjectTypeDescription && !isSoapFaulException) {
            XMLObjectTypeUpdater.setXMLObjectMetadata(objectTypeDescription, object.getElementNamespace(), object);
            String nativeNamespace = objectTypeDescription.getProperty("namespace");
            object.setNamespace(nativeNamespace);
        }
    }

    private static void setXMLObjectMetadata(ObjectTypeDescription objectTypeDescription, String xmlObjectElementNamespace, XMLObject xmlObject) {
        XMLObjectTypeUpdater.setXsiAttributes(xmlObject);
        SortedChildrenList sortedChildrenList = xmlObject.getChildren();
        List<MethodTypeDescription> attributesList = objectTypeDescription.getAttributes();
        for (MethodTypeDescription typeDescription : attributesList) {
            AttributeTypeDescription attributeTypeDescription = typeDescription.asAttribute();
            String isXsdAttribute = attributeTypeDescription.getProperty("isXsdAttribute");
            boolean isAttribute = Boolean.valueOf(isXsdAttribute);
            if (isAttribute) continue;
            for (XMLObject child : sortedChildrenList) {
                String xsdType = typeDescription.getProperty("xsdType");
                boolean isXsdAnyType = "http://www.w3.org/2001/XMLSchema:anyType".equals(xsdType);
                if (isXsdAnyType) continue;
                String childTagName = child.getTagName();
                String childElementNamespace = child.getElementNamespace();
                String elementNamespace = "".equals(childElementNamespace) ? xmlObjectElementNamespace : childElementNamespace;
                XMLSignatureParser xmlSignatureParser = XMLSignatureParser.buildSignature(attributeTypeDescription, elementNamespace);
                String nativeName = xmlSignatureParser.getName();
                String namespace = xmlSignatureParser.getElementNamespace();
                boolean childElementQualified = xmlSignatureParser.getElementIsQualified();
                if (!nativeName.equals(childTagName) || childElementQualified && (!childElementQualified || !namespace.equals(elementNamespace))) continue;
                XMLObjectTypeUpdater.setXsiAttributes(child);
                XMLObjectTypeUpdater.setXmlObjectFromTypeDescription(child, xmlSignatureParser, typeDescription);
            }
        }
    }

    private static void setXmlObjectFromTypeDescription(XMLObject child, XMLSignatureParser xmlSignatureParser, MethodTypeDescription methodTypeDescription) {
        child.setNamespace(xmlSignatureParser.getNamespace());
        child.setElementNamespace(xmlSignatureParser.getElementNamespace());
        child.setElementIsQualified(xmlSignatureParser.getElementIsQualified());
        TypeDescription resultTypeDescription = methodTypeDescription.getResultType();
        if (resultTypeDescription.isObject() || resultTypeDescription.isArray() || resultTypeDescription.isXmlObject()) {
            ObjectTypeDescription typeDescription = (ObjectTypeDescription)resultTypeDescription;
            if (resultTypeDescription.isArray() || resultTypeDescription.isMap()) {
                typeDescription = resultTypeDescription.getElementType().asObject();
            }
            if (typeDescription.isBpmObject() || typeDescription.isXmlObject()) {
                child.setFuegoName(typeDescription.getQualifiedName());
                XMLObjectTypeUpdater.setXMLObjectMetadata(typeDescription, child.getElementNamespace(), child);
            }
        }
    }

    private static void setNilAttribute(XMLObject child, Map<QName, String> attributes) {
        boolean isNil;
        String nilAttribute = attributes.get(XSI_NILL_QNAME);
        boolean bl = isNil = nilAttribute != null && Boolean.parseBoolean(nilAttribute);
        if (isNil) {
            child.getAttributes().remove(XSI_NILL_QNAME);
            child.setNil(true);
        }
    }

    private static void setXsiAttributes(XMLObject child) {
        boolean hasAttributes;
        Map<QName, String> attributes = child.getAttributes();
        boolean bl = hasAttributes = attributes != null && !attributes.isEmpty();
        if (hasAttributes) {
            XMLObjectTypeUpdater.setNilAttribute(child, attributes);
        }
    }
}

