/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlruntime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.xmlruntime.XMLObjectSerializationUtils;

public class XMLObjectSerializerUtil {
    public static List<AttributeTypeDescription> sortAttributeList(List<AttributeTypeDescription> data) {
        ArrayList<AttributeTypeDescription> orderedData = null;
        if (data != null) {
            orderedData = new ArrayList<AttributeTypeDescription>(data);
            Collections.sort(orderedData, new Comparator<AttributeTypeDescription>(){

                @Override
                public int compare(AttributeTypeDescription attr1, AttributeTypeDescription attr2) {
                    String elementPositionAttr1 = attr1.getProperty("elementPosition");
                    String elementPositionAttr2 = attr2.getProperty("elementPosition");
                    Integer positionAttr1 = elementPositionAttr1 == null ? -1 : Integer.valueOf(elementPositionAttr1);
                    Integer positionAttr2 = elementPositionAttr1 == null ? -1 : Integer.valueOf(elementPositionAttr2);
                    return positionAttr1.compareTo(positionAttr2);
                }
            });
        }
        return orderedData;
    }

    public static List<AttributeTypeDescription> getElements(ObjectTypeDescription objectTypeDescription) {
        ArrayList<AttributeTypeDescription> elementsTypeDescription = new ArrayList<AttributeTypeDescription>();
        List<AttributeTypeDescription> attributes = XMLObjectSerializationUtils.getAllAttributes(objectTypeDescription);
        for (AttributeTypeDescription attribute : attributes) {
            boolean isAttribute = Boolean.valueOf(attribute.getProperty("isXsdAttribute"));
            if (isAttribute) continue;
            elementsTypeDescription.add(attribute);
        }
        return elementsTypeDescription;
    }
}

