/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlruntime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.xmlparser.Namespace;
import oracle.bpm.xmlparser.NamespaceContext;
import oracle.bpm.xmlruntime.SerializationContext;
import oracle.bpm.xmlruntime.SortedChildrenList;
import oracle.bpm.xmlruntime.XMLObject;
import oracle.bpm.xmlruntime.XMLObjectSerializationUtils;
import oracle.bpm.xmlruntime.XMLObjectSerializerUtil;
import oracle.bpm.xmlruntime.XMLObjectV1Serializer;
import oracle.bpm.xmlruntime.XMLObjectV2Serializer;
import oracle.bpm.xmlruntime.XMLSignatureParser;
import oracle.bpm.xmlruntime.XMLText;
import oracle.bpm.xmlruntime.XmlUtils;
import oracle.bpm.xmltype.XMLIntrospector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XMLObjectBaseSerializer {
    private static final String XSI_PREFIX = "xsi";
    private static final String XMLSCHEMA_INSTANCE_NS = "http://www.w3.org/2001/XMLSchema-instance";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String WSDL_SCHEMA = "http://schemas.xmlsoap.org/wsdl/";

    public abstract void serialize(ObjectTypeDescription var1, XMLObject var2, boolean var3, SerializationContext var4);

    public static XMLObjectBaseSerializer create(XMLObject xmlObject, ObjectTypeDescription typeDescription) {
        boolean hasXMLVersion;
        boolean hasTypeDescriptionVersion = false;
        XMLObjectBaseSerializer serializer = XMLObjectV1Serializer.getInstance();
        if (typeDescription != null) {
            hasTypeDescriptionVersion = typeDescription.getProperty("xmlObjectVersion") != null;
        }
        boolean bl = hasXMLVersion = xmlObject.getModelVersion() == 2;
        if (hasTypeDescriptionVersion && hasXMLVersion) {
            serializer = XMLObjectV2Serializer.getInstance();
        }
        return serializer;
    }

    protected String findOrCreatePrefix(SerializationContext context, String currentNamespace) {
        return this.findOrCreatePrefix(context, currentNamespace, null);
    }

    protected String findOrCreatePrefix(SerializationContext context, String currentNamespace, XMLObject xmlObject) {
        XMLObject.NSMap nspaces = context.getNSMap();
        String result = (String)nspaces.get(currentNamespace);
        if (result == null) {
            if (XMLSCHEMA_INSTANCE_NS.equals(currentNamespace)) {
                result = XSI_PREFIX;
            } else {
                Map<String, String> prefixToUriMap = null;
                if (xmlObject != null && xmlObject.getNSContext() != null) {
                    prefixToUriMap = xmlObject.getNSContext().getLocalDeclaredPrefixToUriMap();
                }
                while (result == null) {
                    String candidatePrefix = "ns" + nspaces.lastNumber++;
                    if (prefixToUriMap != null && prefixToUriMap.get(candidatePrefix) != null) continue;
                    result = candidatePrefix;
                }
            }
            nspaces.put(currentNamespace, result);
            String declaration = " xmlns:" + result + "=\"" + currentNamespace + "\" ";
            Set<String> namespaceDeclaration = context.getNamespaceDeclaration();
            namespaceDeclaration.add(declaration);
        }
        return result;
    }

    protected void serialize(@NotNull SerializationContext context, @Nullable ObjectTypeDescription typeDescription, @NotNull XMLObject xmlObject, String currentNamespace, boolean elementIsQualified, boolean isRoot) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/xmlruntime/XMLObjectBaseSerializer.serialize must not be null");
        }
        if (xmlObject == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/xmlruntime/XMLObjectBaseSerializer.serialize must not be null");
        }
        String tagName = xmlObject.getTagName();
        context.getOutput().print(tagName);
        this.generateXsiType(xmlObject, typeDescription, context, isRoot);
        SortedChildrenList children = xmlObject.getChildren();
        List<XMLObject> sortedChildren = children.sortChildrenList();
        boolean serializaUsingTypeDescription = false;
        if (typeDescription != null) {
            boolean bl = serializaUsingTypeDescription = !XMLIntrospector.XMLOBJECT.getQualifiedName().equals(typeDescription.getQualifiedName());
        }
        if (serializaUsingTypeDescription) {
            this.serializeAttributes(typeDescription, xmlObject, sortedChildren, currentNamespace, context);
            this.serializeByTypeDescription(typeDescription, sortedChildren, tagName, elementIsQualified, currentNamespace, context);
        } else {
            this.serializeAttributes(sortedChildren, xmlObject, currentNamespace, context);
            this.serializeByXmlObject(sortedChildren, tagName, elementIsQualified, currentNamespace, context);
        }
    }

    private static void serializeChildrenList(List<XMLObject> sortedChildren, SerializationContext context) {
        int length = sortedChildren.size();
        boolean contentIsText = false;
        IndentedPrintWriter out = context.getOutput();
        if (length == 1 && sortedChildren.get(0) instanceof XMLText) {
            contentIsText = true;
        }
        if (!contentIsText) {
            out.indent();
            out.println();
        }
        for (XMLObject child : sortedChildren) {
            XMLObject.NSMap childns = new XMLObject.NSMap(context.getNSMap());
            if (child != null) {
                child.generateXML(out, false, childns);
                continue;
            }
            out.println();
        }
        if (!contentIsText) {
            out.println();
            out.dedent();
        }
    }

    private void generateXsiType(@NotNull XMLObject xmlObject, @Nullable ObjectTypeDescription typeDescription, @NotNull SerializationContext context, boolean isRoot) {
        if (xmlObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/xmlruntime/XMLObjectBaseSerializer.generateXsiType must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/xmlruntime/XMLObjectBaseSerializer.generateXsiType must not be null");
        }
        if (typeDescription != null) {
            boolean isXsiTypeDeclared;
            String name = "";
            String isImplementedTypeStr = typeDescription.getProperty("implementsAbstractType");
            boolean isImplementedType = Boolean.valueOf(isImplementedTypeStr);
            String elemType = typeDescription.getProperty("elementType");
            String nativeName = typeDescription.getProperty("nativeName");
            String elementName = xmlObject.getTagName();
            boolean isComplexType = "complexType".equals(elemType) && elementName != null && elementName.equals(nativeName);
            boolean bl = isXsiTypeDeclared = xmlObject.getXsiType() != null;
            if ((isImplementedType || isComplexType && isRoot) && !isXsiTypeDeclared) {
                String prefix;
                String namespaceXsiType = typeDescription.getProperty("namespace");
                if (namespaceXsiType != null && !"".equals(namespaceXsiType)) {
                    prefix = this.findOrCreatePrefix(context, namespaceXsiType);
                    name = prefix + ":";
                }
                name = name + nativeName;
                prefix = this.findOrCreatePrefix(context, XMLSCHEMA_INSTANCE_NS);
                String xsiType = prefix + ":type";
                IndentedPrintWriter writer = context.getOutput();
                writer.print(' ');
                writer.print(xsiType);
                writer.print('=');
                writer.print('\"');
                writer.print(name);
                writer.print('\"');
            }
        }
    }

    private void serializeAttributes(List<XMLObject> sortedChildren, XMLObject xmlObject, String elementNamespace, SerializationContext context) {
        Map<QName, String> xmlObjectAttributes = xmlObject.getAttributes();
        if (xmlObjectAttributes != null) {
            Set<Map.Entry<QName, String>> entries = xmlObjectAttributes.entrySet();
            for (Map.Entry<QName, String> entry : entries) {
                QName qname = entry.getKey();
                String value = entry.getValue();
                context.getOutput().print(' ');
                String namespaceURI = qname.getNamespaceURI();
                if (!"".equals(namespaceURI)) {
                    String attPrefix = this.findOrCreatePrefix(context, namespaceURI);
                    context.getOutput().print(attPrefix + ":");
                    if (XMLSCHEMA_INSTANCE_NS.equals(namespaceURI) || W3C_XML_SCHEMA.equals(namespaceURI) || WSDL_SCHEMA.equals(namespaceURI)) {
                        this.addNamespaceDeclarationFromAttribute(xmlObject, context, value);
                    }
                }
                context.getOutput().print(qname.getLocalPart());
                context.getOutput().print('=');
                context.getOutput().print('\"');
                context.getOutput().print(Str.toXMLString(value));
                context.getOutput().print('\"');
            }
        }
        XMLObjectSerializationUtils.addEncodingAttributes(xmlObject, elementNamespace, sortedChildren, context, null);
        XMLObjectSerializationUtils.dumpNamespaceDefinition(context);
    }

    private void serializeByXmlObject(List<XMLObject> sortedChildren, String tagName, boolean elementIsQualified, String elementNamespace, SerializationContext context) {
        if (sortedChildren.isEmpty()) {
            context.getOutput().println("/>");
        } else {
            context.getOutput().print('>');
            XMLObjectBaseSerializer.serializeChildrenList(sortedChildren, context);
            XMLObjectSerializationUtils.closeTag(tagName, elementIsQualified, elementNamespace, context);
        }
    }

    private void serializeAttributes(ObjectTypeDescription objectTypeDescription, XMLObject xmlObject, List<XMLObject> sortedChildren, String elementNamespace, SerializationContext context) {
        List<AttributeTypeDescription> attributesTypeDescription = XMLObjectSerializationUtils.findMembersByProperty(objectTypeDescription, "isXsdAttribute", Boolean.TRUE.toString());
        HashMap<QName, String> xmlObjectAttributes = new HashMap<QName, String>();
        if (xmlObject != null) {
            xmlObjectAttributes.putAll(xmlObject.getAttributes());
        }
        for (AttributeTypeDescription attributeTypeDescription : attributesTypeDescription) {
            String attributeName = attributeTypeDescription.getProperty("nativeName");
            String attrElementNamespace = attributeTypeDescription.getProperty("elementNamespace");
            QName qname = new QName(attrElementNamespace, attributeName);
            String value = (String)xmlObjectAttributes.get(qname);
            if (value != null) {
                String formQualified = attributeTypeDescription.getProperty("qualified");
                boolean attributeIsFormQualified = Boolean.valueOf(formQualified);
                boolean hasDiferentNamespaces = !elementNamespace.equals(attrElementNamespace) && !"".equals(attrElementNamespace);
                context.getOutput().print(' ');
                if (attributeIsFormQualified || hasDiferentNamespaces) {
                    String attPrefix = this.findOrCreatePrefix(context, attrElementNamespace);
                    context.getOutput().print(attPrefix + ":");
                }
                this.dumpAttribute(context.getOutput(), attributeName, value);
            }
            xmlObjectAttributes.remove(qname);
        }
        if (!xmlObjectAttributes.isEmpty()) {
            Set entries = xmlObjectAttributes.entrySet();
            for (Map.Entry entry : entries) {
                QName qName = (QName)entry.getKey();
                String attributeValue = (String)entry.getValue();
                String attributeName = qName.getLocalPart();
                context.getOutput().print(' ');
                String namespaceURI = qName.getNamespaceURI();
                if (!"".equals(namespaceURI)) {
                    String attPrefix = this.findOrCreatePrefix(context, namespaceURI);
                    if (XMLSCHEMA_INSTANCE_NS.equals(namespaceURI) || W3C_XML_SCHEMA.equals(namespaceURI) || WSDL_SCHEMA.equals(namespaceURI)) {
                        this.addNamespaceDeclarationFromAttribute(xmlObject, context, attributeValue);
                    }
                    attributeName = attPrefix + ":" + attributeName;
                }
                this.dumpAttribute(context.getOutput(), attributeName, attributeValue);
            }
        }
        if (xmlObject != null) {
            XMLObjectSerializationUtils.addEncodingAttributes(xmlObject, elementNamespace, sortedChildren, context, objectTypeDescription);
        }
        XMLObjectSerializationUtils.dumpNamespaceDefinition(context);
    }

    private void serializeByTypeDescription(ObjectTypeDescription objectTypeDescription, List<XMLObject> sortedChildren, String tagName, boolean elementIsQualified, String elementNamespace, SerializationContext context) {
        List<AttributeTypeDescription> elements = XMLObjectSerializerUtil.getElements(objectTypeDescription);
        if (elements == null || elements.isEmpty()) {
            if (!sortedChildren.isEmpty()) {
                this.serializeByXmlObject(sortedChildren, tagName, elementIsQualified, elementNamespace, context);
            } else {
                context.getOutput().println("/>");
            }
        } else {
            List<AttributeTypeDescription> attributeTypeDescList = new ArrayList<AttributeTypeDescription>();
            boolean serializeByElementPosition = true;
            for (AttributeTypeDescription attributeTypeDescription : elements) {
                String elementPosition = attributeTypeDescription.getProperty("elementPosition");
                if (elementPosition == null) {
                    serializeByElementPosition = false;
                    break;
                }
                AttributeTypeDescription attTypeDesc = attributeTypeDescription.asAttribute();
                attributeTypeDescList.add(attTypeDesc);
            }
            boolean areMissingElementsInTypeDescription = false;
            if (serializeByElementPosition) {
                for (XMLObject sortedChild : sortedChildren) {
                    MethodTypeDescription attr = objectTypeDescription.findMemberByProperty("nativeName", sortedChild.getTagName());
                    if (attr != null) continue;
                    areMissingElementsInTypeDescription = true;
                    break;
                }
            }
            if (!serializeByElementPosition || areMissingElementsInTypeDescription) {
                this.serializeByXmlObject(sortedChildren, tagName, elementIsQualified, elementNamespace, context);
            } else {
                attributeTypeDescList = XMLObjectSerializerUtil.sortAttributeList(attributeTypeDescList);
                context.getOutput().println('>');
                for (AttributeTypeDescription attributeTypeDescription : attributeTypeDescList) {
                    if (attributeTypeDescription == null) continue;
                    this.serializeElementsByTypeDescription(attributeTypeDescription, sortedChildren, context);
                }
                XMLObjectSerializationUtils.closeTag(tagName, elementIsQualified, elementNamespace, context);
            }
        }
    }

    private void serializeXmlObject(XMLObject xmlObject, SerializationContext context) {
        boolean contentIsText = false;
        IndentedPrintWriter out = context.getOutput();
        if (xmlObject instanceof XMLText) {
            contentIsText = true;
        }
        if (!contentIsText) {
            out.indent();
            out.println();
        }
        XMLObject.NSMap childns = new XMLObject.NSMap(context.getNSMap());
        if (xmlObject != null) {
            xmlObject.generateXML(out, false, childns);
        } else {
            out.println();
        }
        if (!contentIsText) {
            out.println();
            out.dedent();
        }
    }

    private void serializeElementsByTypeDescription(AttributeTypeDescription attribute, List<XMLObject> sortedChildren, SerializationContext context) {
        XMLSignatureParser xmlSignatureParser = XMLSignatureParser.buildSignature(attribute, null);
        TypeDescription resultTypeDescription = attribute.getResultType();
        String nativeName = xmlSignatureParser.getName();
        String elementNamespace = xmlSignatureParser.getElementNamespace();
        Boolean isNilable = Boolean.parseBoolean(attribute.getProperty("isNilable"));
        boolean elementNotSetted = true;
        if (!sortedChildren.isEmpty()) {
            for (XMLObject child : sortedChildren) {
                String childElementNamespace = child.getElementNamespace();
                boolean childElementQualified = child.getElementIsQualified();
                String childTagName = child.getTagName();
                if (!nativeName.equals(childTagName) || childElementQualified && (!childElementQualified || !elementNamespace.equals(childElementNamespace))) continue;
                elementNotSetted = false;
                if (child.isNil()) {
                    this.serializeNilElement(resultTypeDescription, child, xmlSignatureParser, nativeName, context);
                    continue;
                }
                this.serializeXmlObject(child, context);
            }
        }
        if (elementNotSetted && isNilable.booleanValue()) {
            this.serializeNilElement(resultTypeDescription, null, xmlSignatureParser, nativeName, context);
        }
    }

    private void serializeTypeDescription(TypeDescription typeDescription, XMLSignatureParser xmlSignatureParser, String nativeName, SerializationContext context) {
        this.serializeTypeDescription(typeDescription, null, xmlSignatureParser, nativeName, context);
    }

    private void serializeTypeDescription(TypeDescription typeDescription, XMLObject xmlObject, XMLSignatureParser xmlSignatureParser, String nativeName, SerializationContext context) {
        SerializationContext ctx = new SerializationContext(context);
        this.serializeTypeDescriptionByContext(typeDescription, xmlObject, xmlSignatureParser, nativeName, ctx);
    }

    private void serializeTypeDescriptionByContext(TypeDescription typeDescription, XMLObject xmlObject, XMLSignatureParser xmlSignatureParser, String nativeName, SerializationContext context) {
        IndentedPrintWriter out = context.getOutput();
        out.print('<');
        Boolean elementIsQualified = xmlSignatureParser.getElementIsQualified();
        String elementNamespace = xmlSignatureParser.getElementNamespace();
        if (elementIsQualified.booleanValue()) {
            String prefix = this.findOrCreatePrefix(context, elementNamespace);
            out.print(prefix + ":");
        }
        out.print(nativeName);
        ObjectTypeDescription resultTypeDescr = null;
        if (typeDescription.isArray() || typeDescription.isMap()) {
            resultTypeDescr = typeDescription.getElementType().asObject();
        } else if (typeDescription.isObject()) {
            resultTypeDescr = typeDescription.asObject();
        }
        if (resultTypeDescr != null && (resultTypeDescr.isBpmObject() || resultTypeDescr.isXmlObject())) {
            this.serializeAttributes(resultTypeDescr, xmlObject, null, elementNamespace, context);
        } else {
            XMLObjectSerializationUtils.dumpNamespaceDefinition(context);
        }
    }

    private void addNamespaceDeclarationFromAttribute(XMLObject xmlObject, SerializationContext context, String attributeValue) {
        String valuePrefix;
        NamespaceContext nsContext = xmlObject.getNSContext();
        if (nsContext != null && !"".equals(valuePrefix = XmlUtils.prefix(attributeValue))) {
            Namespace namespace = nsContext.findNamespace(valuePrefix);
            context.addNamespaceToNamespaceDeclaration(valuePrefix, namespace);
        }
    }

    private void serializeFixedElement(TypeDescription typeDescription, XMLSignatureParser xmlSignatureParser, String nativeName, String elementNamespace, String fixedValue, SerializationContext context) {
        IndentedPrintWriter out = context.getOutput();
        this.serializeTypeDescription(typeDescription, xmlSignatureParser, nativeName, context);
        out.print(">");
        out.print(fixedValue);
        XMLObjectSerializationUtils.closeTag(nativeName, xmlSignatureParser.getElementIsQualified(), elementNamespace, context);
    }

    private void serializeNilElement(TypeDescription typeDescription, XMLObject xmlObject, XMLSignatureParser xmlSignatureParser, String nativeName, @NotNull SerializationContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of oracle/bpm/xmlruntime/XMLObjectBaseSerializer.serializeNilElement must not be null");
        }
        IndentedPrintWriter out = context.getOutput();
        SerializationContext ctx = new SerializationContext(context);
        String prefix = this.findOrCreatePrefix(ctx, XMLSCHEMA_INSTANCE_NS);
        this.serializeTypeDescriptionByContext(typeDescription, xmlObject, xmlSignatureParser, nativeName, ctx);
        out.print(" " + prefix + ":nil=\"true\" ");
        out.println("/>");
    }

    private void dumpAttribute(IndentedPrintWriter out, String attributeName, String attributeValue) {
        out.print(attributeName);
        out.print('=');
        out.print('\"');
        out.print(Str.toXMLString(attributeValue));
        out.print('\"');
    }
}

