/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlruntime;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.UnsupportedCharsetException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import javax.xml.namespace.QName;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.component.metadata.Hidden;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.runtime.Displayable;
import oracle.bpm.type.FuegoClass;
import oracle.bpm.type.TypeRef;
import oracle.bpm.xml.msg.XmlMsg;
import oracle.bpm.xmlparser.Namespace;
import oracle.bpm.xmlparser.NamespaceContext;
import oracle.bpm.xmlruntime.AttributeList;
import oracle.bpm.xmlruntime.ElementList;
import oracle.bpm.xmlruntime.SortedChildrenList;
import oracle.bpm.xmlruntime.StringElementList;
import oracle.bpm.xmlruntime.XMLInstantiator;
import oracle.bpm.xmlruntime.XMLSignatureParser;
import oracle.bpm.xmlruntime.XMLText;
import oracle.bpm.xmlruntime.XMLValue;
import oracle.bpm.xmlruntime.XPathUtils;
import oracle.bpm.xmlruntime.XmlAttribute;
import oracle.bpm.xmlruntime.XmlDocument;
import oracle.bpm.xmlruntime.XmlNode;
import oracle.bpm.xmlruntime.XmlObjectErrorHandler;
import oracle.bpm.xmlruntime.XmlObjectNavigator;
import oracle.bpm.xmltype.XMLIntrospector;
import oracle.bpm.xmltype.XmlConstants;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.parser.v2.XMLDOMImplementation;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XMLPrintDriver;
import org.jaxen.BaseXPath;
import org.jaxen.JaxenException;
import org.jaxen.Navigator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLObject
extends XmlNode
implements oracle.bpm.xmlparser.Element,
Displayable,
Cloneable {
    int elementPosition = -1;
    @Nullable
    private transient AbstractMap<QName, String> attributesMap;
    @Nullable
    private transient SortedChildrenList children;
    @Nullable
    private transient Map<String, XMLObject> childrenByName;
    private String complexTypeName;
    private NamespaceContext context;
    private transient Element element;
    private boolean elementFormDefaultIsQualified;
    @Deprecated
    private boolean elementIsQualified;
    private String elementXsiType;
    private transient TypeDescription fuegoType;
    private boolean isNil;
    private String namespace;
    private int xmlModelVersion = -1;
    private static final ThreadLocal<Reference<Document>> currentDocument = new ThreadLocal();
    public static final int XML_MODEL_VERSION = 2;
    private static final int CHILD_ELEMENT_NOT_FOUND = -1;
    public static final String XMLSCHEMA_INSTANCE_NS = "http://www.w3.org/2001/XMLSchema-instance";
    private static final QName XSI_TYPE_Q_NAME = new QName("http://www.w3.org/2001/XMLSchema-instance", "type", "xsi");
    static final long serialVersionUID = -4160811479623150011L;
    static final long serialCheck = -4755415065330578371L;

    public XMLObject() {
        this((String)null);
    }

    public XMLObject(String name) {
        this(name, null);
    }

    public XMLObject(String name, Map<QName, String> attr) {
        this(name, attr, null, false);
    }

    public XMLObject(String name, String namespace, boolean elementsAreQualified) {
        this(name, null, namespace, elementsAreQualified);
    }

    public XMLObject(String name, Map<QName, String> attributes, String namespace, boolean elementsAreQualified) {
        if (Str.isEmpty(name)) {
            name = this.getClass().getSimpleName();
        }
        if (Str.isEmpty(namespace)) {
            namespace = null;
        }
        this.setElement(XMLObject.getCurrentDocument().createElementNS(namespace, name));
        this.complexTypeName = name;
        this.setAttributes(attributes);
        this.namespace = namespace;
        this.elementFormDefaultIsQualified = elementsAreQualified;
        this.elementIsQualified = elementsAreQualified;
        this.xmlModelVersion = 2;
        this.fixPrefixes();
    }

    XMLObject(Element element) {
        this.setElement(element);
        this.xmlModelVersion = 2;
        if (element != null) {
            this.complexTypeName = element.getLocalName();
            String namespaceURI = element.getNamespaceURI();
            if (!Str.isEmpty(namespaceURI)) {
                this.setElementIsQualified(true);
                this.setElementFormDefaultIsQualified(true);
                this.setNamespace(namespaceURI);
            }
        }
    }

    public static String getNameFromSignature(String signature) {
        int index = signature.lastIndexOf(59);
        return signature.substring(1, index);
    }

    @Exclude
    public static XMLObject fromjava_lang_String(String xml) throws ComponentExecutionException {
        return XMLInstantiator.createTree(xml);
    }

    public int getModelVersion() {
        return this.xmlModelVersion;
    }

    @Deprecated
    public void setElementIsQualified(boolean qualified) {
        this.elementIsQualified = qualified;
    }

    public boolean getElementIsQualified() {
        return this.elementIsQualified;
    }

    @Override
    public void setAttributeValue(String signature, int index, Object value) {
    }

    @Override
    public Object getAttributeValue(String signature, int index) {
        return this.getAttributeValue(signature);
    }

    @Override
    public Object getAttributeValue(String signatureStr, String setter) {
        Cloneable value = this.getAttributeValue(signatureStr);
        if (value == null) {
            XMLSignatureParser signature = XMLSignatureParser.buildSignature(setter, this.namespace, this.elementIsQualified);
            String name = signature.getName();
            String type = signature.getElemType();
            String elementNamespace = signature.getElementNamespace();
            String namespace = signature.getNamespace();
            boolean elementIsQualified = signature.getElementIsQualified();
            char firstChar = type.charAt(0);
            if (firstChar == '[' || firstChar == '{') {
                value = new ArrayList(1);
            } else if (type.charAt(0) == 'X') {
                XMLObject xmlObject = new XMLObject(name, null, namespace, this.elementFormDefaultIsQualified);
                xmlObject.setElementNamespace(elementNamespace);
                xmlObject.setElementIsQualified(elementIsQualified);
                value = xmlObject;
            } else {
                value = null;
            }
            this.setAttributeValue(setter, value);
        }
        return value;
    }

    @Override
    public Object getAttributeValue(String signature, String setter, int index) {
        return this.getAttributeValue(signature);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Map<QName, String> getAttributes() {
        AbstractMap<QName, String> result = this.attributesMap;
        if (result == null) {
            this.attributesMap = result = this.createAttributesMap();
        }
        AbstractMap<QName, String> abstractMap = result;
        if (abstractMap == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/xmlruntime/XMLObject.getAttributes must not return null");
        }
        return abstractMap;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public SortedChildrenList getChildren() {
        SortedChildrenList result = this.children;
        if (result == null) {
            this.children = result = new SortedChildrenList(this);
        }
        SortedChildrenList sortedChildrenList = result;
        if (sortedChildrenList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/xmlruntime/XMLObject.getChildren must not return null");
        }
        return sortedChildrenList;
    }

    public void setChildren(@Nullable SortedChildrenList childrenList) {
        SortedChildrenList myChildren = this.getChildren();
        myChildren.clear();
        if (childrenList != null) {
            myChildren.addAll(childrenList);
        }
    }

    public void setAttributes(@Nullable Map<QName, String> attributes) {
        Map<QName, String> attrMap = this.getAttributes();
        attrMap.clear();
        if (attributes != null) {
            attrMap.putAll(attributes);
        }
    }

    @Override
    public DynamicObject getContentToShow() {
        XMLObject first;
        DynamicObject object = DynamicObject.create();
        object.setJavaClassName(this.getTagName());
        for (Map.Entry<QName, String> pair : this.getAttributes().entrySet()) {
            object.setField(pair.getKey().getLocalPart(), pair.getValue());
        }
        HashSet<String> names = new HashSet<String>();
        HashSet<String> duplicated = new HashSet<String>();
        for (XMLObject element : this.getChildren()) {
            String name = element == null ? null : element.getTagName();
            if (name == null) continue;
            if (names.contains(name)) {
                duplicated.add(name);
            }
            names.add(name);
        }
        int length = this.getChildren().size();
        XMLObject xMLObject = first = length > 0 ? this.getChildren().get(0) : null;
        if (names.isEmpty() || !duplicated.isEmpty()) {
            Object content = this.getChildren();
            if (length == 1 && first instanceof XMLText) {
                content = first;
            }
            if (this.getAttributes().isEmpty()) {
                object.setField("content", content);
            } else {
                object = DynamicObject.valueOf(content);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                XMLObject elem = this.getChildren().get(i);
                if (!(elem instanceof XMLObject)) continue;
                XMLObject xmlobject = this.getChildren().get(i);
                String name = xmlobject.getTagName();
                object.setField(name, xmlobject);
            }
        }
        return object;
    }

    public String getEmbeddedXML() {
        Element element = this.element;
        assert (element instanceof XMLNode);
        StringWriter sw = new StringWriter();
        XMLPrintDriver pd = new XMLPrintDriver((Writer)sw);
        pd.setFormatPrettyPrint(true);
        try {
            pd.printElement((XMLElement)element);
            pd.close();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return sw.toString();
    }

    public Object getMessagePartValue(String name, String type) {
        String signature = null;
        TypeDescription description = this.getType();
        int memberCount = description.getMemberCount();
        for (int i = 0; i < memberCount; ++i) {
            MethodTypeDescription memberType = description.getMemberType(i);
            if (!name.equals(memberType.getProperty("partName"))) continue;
            signature = memberType.getSignature();
            break;
        }
        if (signature == null) {
            throw new IllegalArgumentException("Unknown attribute " + name);
        }
        return this.getAttributeValue(signature);
    }

    @Override
    public boolean isInstanceOf(String componentType, String signature) {
        String expectedNamespace;
        String partType;
        if (!ComponentType.XML.getText().equals(componentType)) {
            return false;
        }
        if (this.isObjectFromBlock(signature)) {
            return true;
        }
        String[] parts = signature.split(";");
        if (parts.length < 2) {
            return false;
        }
        String type = this.getXsiType();
        String namespace = null;
        if (type == null) {
            type = this.getTagName();
        } else {
            int colonPos = type.indexOf(58);
            if (colonPos != -1) {
                Namespace namespaceType;
                String prefix = type.substring(0, colonPos);
                if (this.context != null && (namespaceType = this.context.findNamespace(prefix)) != null) {
                    namespace = namespaceType.getUri();
                }
                type = type.substring(colonPos + 1);
            }
        }
        String expectedType = partType = parts[0];
        if (partType.indexOf(58) != -1) {
            expectedType = partType.substring(partType.indexOf(58) + 1);
        }
        if ("http://www.w3.org/2001/XMLSchema".equals(expectedNamespace = parts[1]) || "".equals(expectedNamespace)) {
            namespace = expectedNamespace;
        }
        if (namespace == null) {
            namespace = this.getNamespace();
        }
        if (expectedType.equalsIgnoreCase(type) && (Str.length(namespace) == 0 || expectedNamespace != null && expectedNamespace.equals(namespace))) {
            return true;
        }
        SortedSet<String> set = XMLObject.findNativeName(type);
        if (set == null || set.isEmpty()) {
            return false;
        }
        for (String name : set) {
            ObjectTypeDescription typeDescription = FuegoClass.forName(name);
            String namespaceType = typeDescription.getProperty("namespace");
            if (!namespace.equals(namespaceType)) continue;
            return XMLObject.isInstanceOfSuperType(typeDescription, expectedType, expectedNamespace);
        }
        return false;
    }

    public void setNSContext(NamespaceContext ctx) {
        if (ctx == this.context) {
            return;
        }
        this.context = ctx;
        this.fixPrefixes();
    }

    public NamespaceContext getNSContext() {
        return this.context;
    }

    @Override
    public String getName() {
        return this.getTagName();
    }

    @Override
    public Object setAttributeValue(String signature, Object value) {
        XMLSignatureParser xmlSignature = XMLSignatureParser.buildSignature(signature, this.namespace, this.elementIsQualified);
        String elementNamespace = xmlSignature.getElementNamespace();
        String name = xmlSignature.getName();
        String type = xmlSignature.getElemType();
        boolean elementIsQualified = xmlSignature.getElementIsQualified();
        int signatureType = xmlSignature.getSignatureType();
        int elemPosition = xmlSignature.getElemPosition();
        switch (signatureType) {
            case 65: {
                value = XMLValue.convertTo(value, type);
                this.setPlainAttribute(name, value.toString(), elementNamespace);
                break;
            }
            case 77: {
                Map att = (Map)Cast.force(value);
                Map<QName, String> attributes = this.getAttributes();
                for (String localPart : att.keySet()) {
                    String attValue = (String)att.get(localPart);
                    QName qname = new QName(localPart);
                    attributes.put(qname, attValue);
                }
                break;
            }
            case 66: {
                this.setElementNamespace((String)value);
                break;
            }
            case 69: {
                XMLObject object = (XMLObject)value;
                if (object != null) {
                    object.setTagName(name);
                    object.setElementNamespace(elementNamespace);
                    object.setElementIsQualified(elementIsQualified);
                    if (object.isImplementedType()) {
                        object.fixXsiType();
                    } else {
                        object.setXsiType(null);
                    }
                }
                this.updateOrAddElement(name, object, elemPosition, value);
                break;
            }
            case 86: {
                int elemIndex = this.findElementIndex(name);
                if (value != null) {
                    XMLObject object;
                    if (elemIndex != -1) {
                        object = this.getChildAt(elemIndex);
                    } else {
                        String namespace = xmlSignature.getNamespace();
                        XMLObject xmlObject = new XMLObject(name, namespace, this.elementFormDefaultIsQualified);
                        xmlObject.setElementNamespace(elementNamespace);
                        xmlObject.setElementIsQualified(elementIsQualified);
                        object = xmlObject;
                        this.addChild(object, elemPosition);
                    }
                    Object xmlValue = XMLValue.convertTo(value, type);
                    if (xmlValue instanceof List) {
                        SortedChildrenList children = object.getChildren();
                        children.clear();
                        List xmlList = (List)Cast.force(xmlValue);
                        children.addAll(elemPosition, xmlList);
                        if (type == null || type.length() <= 0 || !XMLValue.isComplexTypeArray(type)) break;
                        String elementType = type.substring(1);
                        String elemNamespace = XMLValue.getNamespace(elementType);
                        String elementXsiType = XMLValue.getXsiType(elementType);
                        object.setNamespace("http://schemas.xmlsoap.org/soap/encoding/");
                        object.setXsiType("Array");
                        object.setXsiElementType(elemNamespace, elementXsiType);
                        break;
                    }
                    object.setContent((XMLObject)xmlValue);
                    break;
                }
                XMLObject object = elemIndex != -1 ? this.getChildAt(elemIndex) : null;
                if (object == null) break;
                this.setChild(elemIndex, null, elemPosition);
                break;
            }
            case 67: {
                this.setContent((XMLObject)XMLValue.convertTo(value, type));
                break;
            }
            case 78: {
                List elemList = (List)Cast.force(XMLValue.convertTo(value, type, name, elementNamespace, elementIsQualified));
                for (XMLObject element : elemList) {
                    element.setElementIsQualified(elementIsQualified);
                    element.setElementNamespace(elementNamespace);
                }
                SortedChildrenList childList = this.getChildren();
                ElementList.clear(childList, name);
                childList.addAll(elemPosition, elemList);
                break;
            }
            case 83: {
                List xmlList = (List)Cast.force(value);
                SortedChildrenList childList = this.getChildren();
                childList.clear();
                childList.addAll(xmlList);
                break;
            }
            case 84: {
                this.setTagName((String)value);
                break;
            }
            case 80: {
                this.setNamespace((String)value);
                break;
            }
            case 85: {
                this.setNil((Boolean)value);
                break;
            }
            case 90: {
                Object obj = XMLValue.convertTo(value, type, name, elementNamespace, elementIsQualified);
                this.getChildren().set(xmlSignature.getElemPosition(), (XMLObject)obj);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal signature: " + signature);
            }
        }
        return value;
    }

    @Override
    public Object getAttributeValue(String signatureStr) {
        Object value = null;
        XMLSignatureParser signature = XMLSignatureParser.buildSignature(signatureStr, this.namespace, this.elementIsQualified);
        String name = signature.getName();
        String type = signature.getElemType();
        String namespace = signature.getElementNamespace();
        switch (signature.getSignatureType()) {
            case 65: {
                Map<QName, String> attributes = this.getAttributes();
                value = this.getAttributes().get(new QName(namespace, name));
                value = XMLValue.convertFrom(value, type);
                if (!(value instanceof List)) break;
                value = new AttributeList(attributes, (List)value, name);
                break;
            }
            case 77: {
                Map<QName, String> attributes = this.getAttributes();
                HashMap<String, String> result = new HashMap<String, String>();
                for (QName qname : attributes.keySet()) {
                    String attrValue = attributes.get(qname);
                    result.put(qname.getLocalPart(), attrValue);
                }
                value = result;
                break;
            }
            case 69: {
                value = this.getChildrenByName().get(name);
                break;
            }
            case 86: {
                value = this.getChildrenByName().get(name);
                if (!(value instanceof XMLObject)) break;
                XMLObject obj = (XMLObject)value;
                boolean arrayOfXMLObject = XMLObject.isArrayOfXMLObject(type);
                value = arrayOfXMLObject ? obj.getChildren() : obj.getContent();
                value = XMLValue.convertFrom(value, type);
                if (arrayOfXMLObject || !(value instanceof List)) break;
                value = new StringElementList(this.getChildren(), (List)value, name);
                break;
            }
            case 67: {
                value = XMLValue.convertFrom(this.getContent(), type);
                break;
            }
            case 78: {
                String elemType = type.substring(1);
                int elemPosition = signature.getElemPosition();
                String elemNamespace = signature.getElementNamespace();
                boolean elementIsQualified = signature.getElementIsQualified();
                value = new ElementList(this.getChildren(), name, elemType, elemPosition, elemNamespace, elementIsQualified);
                break;
            }
            case 83: {
                value = this.getChildren();
                break;
            }
            case 84: {
                value = this.getTagName();
                break;
            }
            case 80: {
                value = this.getNamespace();
                break;
            }
            case 85: {
                value = this.isNil();
                break;
            }
            case 66: {
                value = this.getElementNamespace();
                break;
            }
            case 90: {
                if (signature.getElemPosition() >= this.getChildren().size()) break;
                value = this.getChildren().get(signature.getElemPosition());
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal signature: " + signatureStr);
            }
        }
        return value;
    }

    @Override
    public TypeDescription getType() {
        String fuegoName = this.getFuegoName();
        if (this.fuegoType == null && fuegoName != null) {
            this.fuegoType = FuegoClass.forName(fuegoName);
        }
        return this.fuegoType;
    }

    public void setNamespace(String namespace) {
        this.namespace = Str.isEmpty(namespace) ? null : namespace;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public String getNamespace() {
        String ns = this.namespace;
        if (ns == null) {
            return "";
        }
        String string = ns;
        if (string == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/xmlruntime/XMLObject.getNamespace must not return null");
        return string;
    }

    @Deprecated
    public void setParent(XMLObject parent) {
    }

    public XMLObject getParent() {
        XMLObject parent;
        Node parentNode = this.getElement().getParentNode();
        if (parentNode != null && !((parent = XMLObject.valueOf(parentNode)) instanceof XmlDocument)) {
            return parent;
        }
        return null;
    }

    public boolean isNil() {
        return this.isNil;
    }

    public void setNil(boolean isNil) {
        this.isNil = isNil;
    }

    public void setPlainAttribute(String name, String value) {
        this.setPlainAttribute(name, value, "");
    }

    public String getPlainAttribute(QName qname) {
        return this.getAttributes().get(qname);
    }

    public void removePlainAttribute(QName qname) {
        this.getAttributes().remove(qname);
    }

    public void removePlainAttribute(String name) {
        this.removePlainAttribute(new QName("", name));
    }

    public void setPlainAttribute(String name, String value, String uri) {
        this.getAttributes().put(new QName(uri, name), value);
    }

    public void setTagName(String name) {
        this.setQName(name, this.element.getNamespaceURI());
    }

    public void setQName(String localPart, String namespaceUri) {
        String elementNamespace;
        if (Str.isEmpty(namespaceUri)) {
            namespaceUri = null;
        }
        if (this.getTagName().equals(localPart) && ((elementNamespace = this.getElementNamespace()) == null ? namespaceUri == null : elementNamespace.equals(namespaceUri))) {
            return;
        }
        Element oldElement = this.element;
        Element newElement = (Element)oldElement.getOwnerDocument().renameNode(oldElement, namespaceUri, localPart);
        this.setElement(newElement);
        this.fixPrefixes();
    }

    public String getTagName() {
        return this.element.getLocalName();
    }

    @Override
    public Object getTarget() {
        return this;
    }

    public void setXsiElementType(String namespace, String xsiType) {
        this.setNamespace(namespace);
        this.elementXsiType = xsiType;
    }

    public void setXsiType(String xsiType) {
        QName xsiTypeQName = XSI_TYPE_Q_NAME;
        Map<QName, String> map = this.getAttributes();
        if (xsiType == null) {
            map.remove(xsiTypeQName);
        } else {
            map.put(xsiTypeQName, xsiType);
        }
    }

    public String getXsiType() {
        return this.getAttributes().get(XSI_TYPE_Q_NAME);
    }

    @Override
    public void addChild(oracle.bpm.xmlparser.Element element) {
        this.addChild(element, -1);
    }

    public void addChild(oracle.bpm.xmlparser.Element element, int elemPosition) {
        oracle.bpm.xmlparser.Element lastChild;
        if (element instanceof XMLText && (lastChild = this.getLastChild()) instanceof XMLText) {
            ((XMLText)lastChild).append(element.toString());
            return;
        }
        this.getChildren().add((XMLObject)element, elemPosition);
    }

    public oracle.bpm.xmlparser.Element removeChild(int elemPosition) {
        return this.getChildren().remove(elemPosition);
    }

    public boolean removeChild(oracle.bpm.xmlparser.Element child) {
        return this.getChildren().remove(child);
    }

    @Override
    public Object invoke(String methodSignature, Object ... args) throws ComponentExecutionException, InvocationTargetException {
        switch (methodSignature.charAt(0)) {
            case 'G': {
                return this.generateXMLFor();
            }
            case 'S': {
                if (methodSignature.equals("SS")) {
                    this.store((String)args[0]);
                    break;
                }
                if (methodSignature.equals("SE")) {
                    this.storeEncoded((String)args[0], (String)args[1]);
                    break;
                }
                if (methodSignature.equals("SSN")) {
                    return this.select((String)args[0]);
                }
                if (methodSignature.equals("SQN")) {
                    return this.querySelect((String)args[0]);
                }
                if (methodSignature.equals("SN")) {
                    return this.selectNodes((String)args[0]);
                }
                if (methodSignature.equals("ST")) {
                    return this.selectString((String)args[0]);
                }
                if (methodSignature.equals("SD")) {
                    return this.selectNumber((String)args[0]);
                }
                if (methodSignature.equals("SB")) {
                    return this.selectBoolean((String)args[0]);
                }
                assert (false) : "Invalid Signature:" + methodSignature;
                break;
            }
            case 'L': {
                switch (methodSignature.charAt(1)) {
                    case 'X': {
                        this.load((String)args[0]);
                        break;
                    }
                    case 'U': {
                        this.loadFromURL((String)args[0]);
                    }
                }
                break;
            }
            case 'V': {
                if (!methodSignature.equals("VV")) break;
                break;
            }
            case 'E': {
                return this.getValue((Integer)args[0]);
            }
            case 'M': {
                if (methodSignature.equals("MtoString()Ljava.lang.String;")) {
                    return this.toString();
                }
                return this.getAttributeValue(methodSignature);
            }
            default: {
                return this.getAttributeValue(methodSignature);
            }
        }
        return null;
    }

    public void load(String xmlText) throws ComponentExecutionException {
        XMLObject tree = XMLInstantiator.createTree(xmlText);
        XMLObject.assignFields(this, tree);
        this.setElement(tree.getElement());
    }

    public Object select(String xpath) throws ComponentExecutionException {
        try {
            BaseXPath xmlPath = new BaseXPath(xpath, (Navigator)XmlObjectNavigator.INSTANCE);
            Object result = xmlPath.selectSingleNode((Object)this);
            if (result instanceof XmlAttribute) {
                XmlAttribute attribute = (XmlAttribute)result;
                result = attribute.getValue();
            }
            return result;
        }
        catch (JaxenException e) {
            throw new ComponentExecutionException(e);
        }
    }

    @Hidden
    public Object querySelect(String xpathWithNamespaceDeclarations) throws ComponentExecutionException {
        try {
            BaseXPath xmlPath = XPathUtils.createXPath(xpathWithNamespaceDeclarations);
            return XPathUtils.getTextValue(xmlPath.selectSingleNode((Object)this));
        }
        catch (JaxenException e) {
            throw new ComponentExecutionException(e);
        }
    }

    public boolean selectBoolean(String xpath) throws ComponentExecutionException {
        try {
            BaseXPath xmlPath = new BaseXPath(xpath, (Navigator)XmlObjectNavigator.INSTANCE);
            return xmlPath.booleanValueOf((Object)this);
        }
        catch (JaxenException e) {
            throw new ComponentExecutionException(e);
        }
    }

    public List selectNodes(String xpath) throws ComponentExecutionException {
        try {
            BaseXPath xmlPath = new BaseXPath(xpath, (Navigator)XmlObjectNavigator.INSTANCE);
            return xmlPath.selectNodes((Object)this);
        }
        catch (JaxenException e) {
            throw new ComponentExecutionException(e);
        }
    }

    public BigDecimal selectNumber(String xpath) throws ComponentExecutionException {
        try {
            BaseXPath xmlPath = new BaseXPath(xpath, (Navigator)XmlObjectNavigator.INSTANCE);
            Number number = xmlPath.numberValueOf((Object)this);
            return number != null ? new BigDecimal(number.toString()) : null;
        }
        catch (JaxenException e) {
            throw new ComponentExecutionException(e);
        }
    }

    public String selectString(String xpath) throws ComponentExecutionException {
        try {
            BaseXPath xmlPath = new BaseXPath(xpath, (Navigator)XmlObjectNavigator.INSTANCE);
            return xmlPath.stringValueOf((Object)this);
        }
        catch (JaxenException e) {
            throw new ComponentExecutionException(e);
        }
    }

    public oracle.bpm.xmlparser.Element getLastChild() {
        SortedChildrenList children = this.getChildren();
        return children.isEmpty() ? null : children.get(children.size() - 1);
    }

    public String getComplexTypeName() {
        return this.complexTypeName;
    }

    @Nullable
    public String getElementNamespace() {
        return this.element.getNamespaceURI();
    }

    public boolean hasElementNamespace() {
        return !Str.isEmpty(this.getElementNamespace());
    }

    public void setElementNamespace(String namespace) {
        this.setQName(this.getTagName(), namespace);
    }

    public XMLObject shallowCopy() {
        XMLObject result;
        try {
            result = (XMLObject)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
        result.setAttributes(this.getAttributes());
        return result;
    }

    public XMLObject deepCopy() {
        XMLObject objCopy = this.shallowCopy();
        objCopy.children = null;
        SortedChildrenList children = this.getChildren();
        for (XMLObject child : children) {
            XMLObject childCopy = child.deepCopy();
            objCopy.addChild(childCopy);
        }
        return objCopy;
    }

    public boolean getElementFormDefaultIsQualified() {
        return this.elementFormDefaultIsQualified;
    }

    public void setElementFormDefaultIsQualified(boolean elemFormDefaultIsQualified) {
        this.elementFormDefaultIsQualified = elemFormDefaultIsQualified;
    }

    public String getElementXsiType() {
        return this.elementXsiType;
    }

    public String getXsiTypeValue() {
        return this.getXsiType();
    }

    public Object getValue(int kind) {
        XMLObject xmlObject;
        Object ret = this;
        SortedChildrenList children = this.getChildren();
        if (children.size() == 1 && (xmlObject = this.getChildren().get(0)) instanceof XMLText) {
            ret = xmlObject.getValue(kind);
        }
        return ret;
    }

    public String toString() {
        Node parent = this.element.getParentNode();
        StringWriter sw = new StringWriter();
        this.generateXMLEncoded(sw, !(parent instanceof XMLElement), "UTF-8");
        return sw.toString();
    }

    protected boolean isObjectFromBlock(String signature) {
        return XMLIntrospector.XMLOBJECT.getSignature().equals(signature);
    }

    protected void setContent(XMLObject content) {
        this.getChildren().clear();
        this.addChild(content);
    }

    protected Object getContent() {
        Cloneable content = null;
        int length = this.getChildren().size();
        if (length == 1) {
            content = this.getChildren().get(0);
        } else if (length > 1) {
            content = new ArrayList<XMLObject>(this.getChildren());
        }
        return content;
    }

    protected String getPrefix(String ns) {
        NamespaceContext context = this.getNSContext();
        return context != null ? context.findPrefixByUri(ns) : null;
    }

    static String buildQualifiedName(QName qName) {
        String prefix = qName.getPrefix();
        String localPart = qName.getLocalPart();
        return prefix.length() == 0 ? localPart : prefix + ':' + localPart;
    }

    @NotNull
    static XMLObject valueOf(Node node) {
        short nodeType;
        XMLObject xMLObject;
        XMLObject result = XMLObject.getUserData(node);
        if (!(result != null ? (xMLObject = result) != null : (xMLObject = (result = (nodeType = node.getNodeType()) == 3 ? new XMLText((Text)node) : new XMLObject((Element)node))) != null)) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/xmlruntime/XMLObject.valueOf must not return null");
        }
        return xMLObject;
    }

    static void clearUserData(@Nullable Node node) {
        if (node != null) {
            node.setUserData(XMLObject.class.getName(), null, null);
        }
    }

    static void fixUserData(Node src, Node dst) {
        String key = XMLObject.class.getName();
        Object dstData = dst.getUserData(key);
        if (dstData != null) {
            return;
        }
        Object data = src.getUserData(key);
        if (data == null) {
            return;
        }
        ElementDataHandler.INSTANCE.handle((short)-1, key, data, src, dst);
        NodeList dstChildren = dst.getChildNodes();
        int length = dstChildren.getLength();
        if (length <= 0) {
            return;
        }
        NodeList srcChildren = src.getChildNodes();
        assert (srcChildren.getLength() == length);
        for (int i = 0; i < length; ++i) {
            XMLObject.fixUserData(srcChildren.item(i), dstChildren.item(i));
        }
    }

    @Deprecated
    void generateXML(IndentedPrintWriter out, boolean root, NSMap nspaces) {
        this.generateXMLEncoded(out, root, "UTF-8");
    }

    Element getElement() {
        return this.element;
    }

    void setUserData(@Nullable Node node) {
        if (node != null) {
            node.setUserData(XMLObject.class.getName(), this, ElementDataHandler.INSTANCE);
        }
    }

    void setElement(Element element) {
        Element oldElement = this.element;
        if (element != oldElement) {
            XMLObject.clearUserData(oldElement);
            this.element = element;
            this.setUserData(element);
            XMLObject.setCurrentDocument(element.getOwnerDocument());
        }
    }

    Node getNode() {
        return this.getElement();
    }

    void setNode(Node node) {
        this.setElement((Element)node);
    }

    @Nullable
    private static SortedSet<String> findNativeName(String type) {
        try {
            return FuegoClass.findByPropertyValue("nativeName", type);
        }
        catch (IOException e) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private static Document findCurrentDocument() {
        Reference<Document> documentReference = currentDocument.get();
        return documentReference == null ? null : documentReference.get();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static Document getCurrentDocument() {
        Document document = XMLObject.findCurrentDocument();
        if (document == null) {
            document = DummyDocument.VALUE;
            XMLObject.setCurrentDocument(document);
        }
        Document document2 = document;
        if (document2 == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/xmlruntime/XMLObject.getCurrentDocument must not return null");
        }
        return document2;
    }

    private static void setCurrentDocument(@NotNull Document value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/xmlruntime/XMLObject.setCurrentDocument must not be null");
        }
        if (XMLObject.findCurrentDocument() != value) {
            currentDocument.set(new WeakReference<Document>(value));
        }
    }

    private static void assignFields(XMLObject dest, XMLObject src) {
        dest.context = src.context;
        dest.elementXsiType = src.elementXsiType;
        dest.namespace = src.namespace;
        dest.complexTypeName = src.complexTypeName;
        dest.elementFormDefaultIsQualified = src.elementFormDefaultIsQualified;
        dest.elementIsQualified = src.elementIsQualified;
        dest.elementXsiType = src.elementXsiType;
        dest.isNil = src.isNil;
        dest.namespace = src.namespace;
        dest.xmlModelVersion = src.xmlModelVersion;
    }

    @Nullable
    private static XMLObject getUserData(Node node) {
        return (XMLObject)node.getUserData(XMLObject.class.getName());
    }

    private static RuntimeException buildUnsupported(DOMException e) {
        if (e.code == 7) {
            return new UnsupportedOperationException(e);
        }
        return e;
    }

    private static String changeValue(Node node, String newValue) {
        String result = node.getNodeValue();
        try {
            node.setNodeValue(newValue);
        }
        catch (DOMException e) {
            throw XMLObject.buildUnsupported(e);
        }
        return result;
    }

    private static EntityResolver createResolver(final Map<String, String> properties) {
        return new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                if (systemId == null || !systemId.startsWith("albpmModule_")) {
                    return null;
                }
                String schemaKey = systemId.substring(systemId.indexOf(35));
                Set set = properties.entrySet();
                for (Map.Entry entry : set) {
                    String key = (String)entry.getKey();
                    if (!key.startsWith("schema_") || !key.endsWith(schemaKey)) continue;
                    return new InputSource(new StringReader((String)entry.getValue()));
                }
                return null;
            }
        };
    }

    private static boolean isInstanceOfSuperType(TypeDescription typeDescription, String nativeName, String namespace) {
        for (SuperType superType : typeDescription.getSuperTypes()) {
            TypeDescription type = superType.getType();
            if (!(type instanceof ObjectTypeDescription)) continue;
            ObjectTypeDescription baseType = (ObjectTypeDescription)type;
            String nativeNameType = baseType.getProperty("nativeName");
            String namespaceType = baseType.getProperty("namespace");
            if ((!nativeName.equalsIgnoreCase(nativeNameType) || !namespace.equals(namespaceType)) && !XMLObject.isInstanceOfSuperType(type, nativeName, namespace)) continue;
            return true;
        }
        return false;
    }

    private static ComponentExecutionException wrapException(Throwable throwable) {
        return new ComponentExecutionException(throwable);
    }

    private static boolean isArrayOfXMLObject(String type) {
        char firstChar = type.charAt(0);
        return (firstChar == '{' || firstChar == '[') && type.charAt(1) == 'X';
    }

    private static void checkError(PrintWriter ipw) throws IOException {
        if (ipw.checkError()) {
            throw new IOException("PrintWriter I/O Error");
        }
    }

    private static Charset getCharset(String name) throws ComponentExecutionException {
        try {
            return Charset.forName(name);
        }
        catch (UnsupportedCharsetException e) {
            throw new ComponentExecutionException(e);
        }
    }

    private void generateXMLEncoded(Writer out, String encoding) {
        this.generateXMLEncoded(out, true, encoding);
    }

    private void generateXMLEncoded(Writer out, boolean root, String encoding) {
        Element element = this.element;
        XMLPrintDriver pd = new XMLPrintDriver(out);
        pd.setFormatPrettyPrint(true);
        try {
            pd.setEncoding(encoding);
            XMLDocument doc = (XMLDocument)element.getOwnerDocument();
            doc.setEncoding(encoding);
            pd.printXMLDecl(doc);
            pd.printElement((XMLElement)element);
            pd.flush();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void fixPrefixes() {
        String ns;
        if (this.context == null) {
            this.context = new NamespaceContext(null);
        }
        if ((ns = this.getElementNamespace()) != null && this.getPrefix(ns) == null) {
            this.context.addNamespace("ns1", ns);
        }
        this.fixNodePrefix(this.element);
        NamedNodeMap attributes = this.element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            this.fixNodePrefix(attributes.item(i));
        }
        String type = this.getXsiType();
        if (type == null) {
            return;
        }
        int p = type.indexOf(58);
        if (p < 0) {
            return;
        }
        String prefix = type.substring(0, p);
        String uri = this.context.getAllPrefixToUriMap().get(prefix);
        if (uri == null) {
            return;
        }
        this.getAttributes().put(new QName("http://www.w3.org/2000/xmlns/", prefix, "xmlns"), uri);
    }

    private void fixNodePrefix(Node node) {
        String ns = node.getNamespaceURI();
        String prefix = this.getPrefix(ns);
        if (prefix != null) {
            node.setPrefix(prefix);
        }
    }

    private AbstractMap<QName, String> createAttributesMap() {
        return new AbstractMap<QName, String>(){

            private Node getNode(Object key) {
                if (!(key instanceof QName)) {
                    return null;
                }
                QName qName = (QName)key;
                return XMLObject.this.element.getAttributes().getNamedItemNS(qName.getNamespaceURI(), qName.getLocalPart());
            }

            @Override
            public String put(QName key, String value) {
                String result = this.putAttribute(key, value);
                if (key.equals(XSI_TYPE_Q_NAME)) {
                    XMLObject.this.fixPrefixes();
                }
                return result;
            }

            private String putAttribute(QName key, String value) {
                Node node = this.getNode(key);
                if (node != null) {
                    return XMLObject.changeValue(node, value);
                }
                Element elem = XMLObject.this.element;
                String ns = key.getNamespaceURI();
                try {
                    if (ns == null) {
                        elem.setAttribute(key.getLocalPart(), value);
                    } else {
                        elem.setAttributeNS(ns, XMLObject.buildQualifiedName(key), value);
                    }
                }
                catch (DOMException e) {
                    throw XMLObject.buildUnsupported(e);
                }
                return null;
            }

            @Override
            public boolean containsKey(Object key) {
                return this.getNode(key) != null;
            }

            @Override
            public String get(Object key) {
                Node node = this.getNode(key);
                return node == null ? null : node.getNodeValue();
            }

            @Override
            public Set<Map.Entry<QName, String>> entrySet() {
                final NamedNodeMap map = XMLObject.this.element.getAttributes();
                return new AbstractSet<Map.Entry<QName, String>>(){

                    @Override
                    public Iterator<Map.Entry<QName, String>> iterator() {
                        return new Iterator<Map.Entry<QName, String>>(){
                            private int next;
                            private Node current;

                            @Override
                            public boolean hasNext() {
                                return this.next < this.size();
                            }

                            @Override
                            public Map.Entry<QName, String> next() {
                                Node node;
                                if (!this.hasNext()) {
                                    throw new NoSuchElementException();
                                }
                                this.current = node = map.item(this.next++);
                                return new Map.Entry<QName, String>(){
                                    private final QName key;
                                    {
                                        String prefix = node.getPrefix();
                                        this.key = new QName(node.getNamespaceURI(), node.getLocalName(), prefix == null ? "" : prefix);
                                    }

                                    @Override
                                    public QName getKey() {
                                        return this.key;
                                    }

                                    @Override
                                    public String getValue() {
                                        return node.getNodeValue();
                                    }

                                    @Override
                                    public String setValue(String value) {
                                        return XMLObject.changeValue(node, value);
                                    }
                                };
                            }

                            @Override
                            public void remove() {
                                Node curr = this.current;
                                if (curr == null) {
                                    throw new IllegalStateException();
                                }
                                try {
                                    map.removeNamedItemNS(curr.getNamespaceURI(), curr.getLocalName());
                                }
                                catch (DOMException e) {
                                    short errCode = e.code;
                                    if (errCode == 7 || errCode == 9) {
                                        throw new UnsupportedOperationException(e);
                                    }
                                    if (errCode == 8) {
                                        ConcurrentModificationException exception = new ConcurrentModificationException();
                                        exception.initCause(e);
                                        throw exception;
                                    }
                                    throw e;
                                }
                                this.current = null;
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return map.getLength();
                    }
                };
            }
        };
    }

    private void updateOrAddElement(String name, XMLObject object, int elemPosition, Object value) {
        int elemIndex = this.findElementIndex(name);
        if (elemIndex != -1) {
            this.setChild(elemIndex, object, elemPosition);
        } else if (value != null) {
            this.addChild(object, elemPosition);
        }
    }

    private void setChild(int index, XMLObject value, int elemPosition) {
        SortedChildrenList children = this.getChildren();
        while (index >= children.size()) {
            children.add(null);
        }
        if (value == null) {
            children.remove(index);
        } else {
            children.set(index, value, elemPosition);
        }
    }

    private XMLObject getChildAt(int position) {
        return this.getChildren().get(position);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Map<String, XMLObject> getChildrenByName() {
        Map<String, XMLObject> result = this.childrenByName;
        if (result == null) {
            this.childrenByName = result = this.createChildrenByName();
        }
        Map<String, XMLObject> map = result;
        if (map == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/xmlruntime/XMLObject.getChildrenByName must not return null");
        }
        return map;
    }

    private Map<String, XMLObject> createChildrenByName() {
        return new AbstractMap<String, XMLObject>(){

            @Override
            public Set<Map.Entry<String, XMLObject>> entrySet() {
                return new AbstractSet<Map.Entry<String, XMLObject>>(){

                    @Override
                    public Iterator<Map.Entry<String, XMLObject>> iterator() {
                        final Iterator iterator = XMLObject.this.getChildren().iterator();
                        return new Iterator<Map.Entry<String, XMLObject>>(){

                            @Override
                            public boolean hasNext() {
                                return iterator.hasNext();
                            }

                            @Override
                            public Map.Entry<String, XMLObject> next() {
                                final XMLObject xmlObject = (XMLObject)iterator.next();
                                return new Map.Entry<String, XMLObject>(){

                                    @Override
                                    public String getKey() {
                                        return xmlObject.getName();
                                    }

                                    @Override
                                    public XMLObject getValue() {
                                        return xmlObject;
                                    }

                                    @Override
                                    public XMLObject setValue(XMLObject value) {
                                        xmlObject.setAttributes(value.getAttributes());
                                        xmlObject.setChildren(value.getChildren());
                                        return xmlObject;
                                    }
                                };
                            }

                            @Override
                            public void remove() {
                                iterator.remove();
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return XMLObject.this.getChildren().size();
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate(@NotNull String typeName) throws ComponentExecutionException {
        ObjectTypeDescription schemaModule;
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/xmlruntime/XMLObject.validate must not be null");
        }
        ObjectTypeDescription typeDescription = FuegoClass.forName(typeName);
        Object transientProperty = typeDescription.getTransientProperty("resource_location");
        assert (transientProperty != null) : "Resource localtion can not be null";
        String qualifiedFuegoTypeName = typeDescription.getText();
        String moduleName = qualifiedFuegoTypeName.substring(0, qualifiedFuegoTypeName.lastIndexOf(46));
        ObjectTypeDescription parentModuleRef = FuegoClass.forName(moduleName);
        if (parentModuleRef == null) {
            throw new ComponentExecutionException(XmlMsg.MODULE_NOT_FOUND(moduleName));
        }
        String schemaModuleName = parentModuleRef.getProperty("definitionModule");
        if (schemaModuleName != null && (schemaModule = FuegoClass.forName(schemaModuleName = moduleName.substring(0, moduleName.lastIndexOf(46)) + '.' + schemaModuleName)) != null) {
            parentModuleRef = schemaModule;
        }
        TypeDescription oldFuegoType = this.fuegoType;
        this.fuegoType = typeDescription;
        try {
            this.validate(typeDescription, parentModuleRef);
        }
        finally {
            this.fuegoType = oldFuegoType;
        }
    }

    private void validate() throws ComponentExecutionException {
        this.validate(this.getFuegoName());
    }

    private String getSchema(ObjectTypeDescription module, ObjectTypeDescription type) {
        String schema = module.getProperty("schema");
        if (schema == null) {
            String schemaLocationKey = type.getProperty("schemaLocationKey");
            String nspace = this.namespace;
            if (nspace == null) {
                nspace = this.getElementNamespace();
            }
            String key = XmlConstants.buildSchemaKey(nspace, schemaLocationKey);
            schema = module.getProperty(key);
        }
        return schema;
    }

    private void validateDOM(ObjectTypeDescription objectTypeDescription, ObjectTypeDescription parent) throws ComponentExecutionException {
        XMLSchema xmlSchema;
        XSDBuilder builder;
        if (parent == null) {
            throw new ComponentExecutionException(XmlMsg.MODULE_WITHOUT_SCHEMA);
        }
        String schema = this.getSchema(parent, objectTypeDescription);
        if (schema == null) {
            TypeRef innerType;
            ObjectTypeDescription innerModule;
            String moduleReference = parent.getProperty("definitionModule");
            ObjectTypeDescription rootParent = (ObjectTypeDescription)parent.getParent();
            if (moduleReference != null && (innerModule = (ObjectTypeDescription)(innerType = rootParent.findInnerType(moduleReference)).get()).isXmlObject()) {
                schema = this.getSchema(innerModule, objectTypeDescription);
                ObjectTypeDescription objectTypeDescription2 = parent = schema != null ? innerModule : parent;
            }
            if (schema == null) {
                throw new ComponentExecutionException(XmlMsg.XMLOBJECT_WITHOUT_SCHEMA);
            }
        }
        try {
            builder = new XSDBuilder();
        }
        catch (XSDException e) {
            throw XMLObject.wrapException(e);
        }
        Map<String, String> properties = parent.getProperties();
        if (properties != null) {
            builder.setEntityResolver(XMLObject.createResolver(properties));
        }
        InputSource schemaIS = new InputSource(new StringReader(schema));
        try {
            xmlSchema = builder.build(schemaIS);
        }
        catch (XSDException e) {
            throw XMLObject.wrapException(e);
        }
        this.fixXsiType();
        XMLElement xmlElement = (XMLElement)this.element;
        try {
            xmlElement.validateContent(xmlSchema);
        }
        catch (XMLParseException e) {
            throw XMLObject.wrapException(e);
        }
        XMLError xmlError = xmlElement.getXMLError();
        if (xmlError.getNumMessages() > 0) {
            throw new ComponentExecutionException(XmlMsg.INVALID_XML(xmlError.formatErrorMesg(0)));
        }
    }

    private void validate(ObjectTypeDescription objectTypeDescription, ObjectTypeDescription parent) throws ComponentExecutionException {
        XMLSchema xmlSchema;
        XSDBuilder builder;
        String schema = this.getSchema(parent, objectTypeDescription);
        if (schema == null) {
            TypeRef innerType;
            ObjectTypeDescription innerModule;
            String moduleReference = parent.getProperty("definitionModule");
            ObjectTypeDescription rootParent = (ObjectTypeDescription)parent.getParent();
            if (moduleReference != null && (innerModule = (ObjectTypeDescription)(innerType = rootParent.findInnerType(moduleReference)).get()).isXmlObject()) {
                schema = this.getSchema(innerModule, objectTypeDescription);
                ObjectTypeDescription objectTypeDescription2 = parent = schema != null ? innerModule : parent;
            }
            if (schema == null) {
                throw new ComponentExecutionException(XmlMsg.XMLOBJECT_WITHOUT_SCHEMA);
            }
        }
        try {
            builder = new XSDBuilder();
        }
        catch (XSDException e) {
            throw XMLObject.wrapException(e);
        }
        Map<String, String> properties = parent.getProperties();
        if (properties != null) {
            builder.setEntityResolver(XMLObject.createResolver(properties));
        }
        InputSource schemaIS = new InputSource(new StringReader(schema));
        try {
            xmlSchema = builder.build(schemaIS);
        }
        catch (XSDException e) {
            throw XMLObject.wrapException(e);
        }
        SAXParser parser = new SAXParser();
        parser.setValidationMode(3);
        parser.setXMLSchema((Object)xmlSchema);
        XmlObjectErrorHandler errorHandler = new XmlObjectErrorHandler();
        parser.setErrorHandler((ErrorHandler)errorHandler);
        this.fixXsiType();
        InputSource is = new InputSource(new StringReader(this.toString()));
        try {
            parser.parse(is);
        }
        catch (IOException e) {
            throw XMLObject.wrapException(e);
        }
        catch (SAXException e) {
            throw XMLObject.wrapException(e);
        }
        if (errorHandler.hasMessages()) {
            throw new ComponentExecutionException(XmlMsg.INVALID_XML(errorHandler.getMessagesString()));
        }
    }

    private boolean isImplementedType() {
        ObjectTypeDescription otd = (ObjectTypeDescription)this.getType();
        return otd != null && Boolean.parseBoolean(otd.getProperty("implementsAbstractType"));
    }

    private void fixXsiType() {
        if (this.getXsiType() != null) {
            return;
        }
        ObjectTypeDescription otd = (ObjectTypeDescription)this.getType();
        if (otd == null) {
            return;
        }
        String elementType = otd.getProperty("elementType");
        boolean isComplexType = "complexType".equals(elementType);
        if (!isComplexType) {
            return;
        }
        String nativeName = otd.getProperty("nativeName");
        if (nativeName == null) {
            return;
        }
        String ns = otd.getProperty("namespace");
        String prefix = this.getPrefix(ns);
        String xsiType = Str.isEmpty(prefix) ? nativeName : prefix + ':' + nativeName;
        this.setXsiType(xsiType);
    }

    private int findElementIndex(String name) {
        SortedChildrenList children = this.getChildren();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            XMLObject object = children.get(i);
            if (!name.equals(object.getTagName())) continue;
            return i;
        }
        return -1;
    }

    private Object generateXMLFor() {
        return this.toString();
    }

    private void loadFromURL(String url) throws ComponentExecutionException {
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            throw new ComponentExecutionException(e);
        }
        this.load(url);
    }

    private void store(String targetFile) throws ComponentExecutionException {
        this.fixXsiType();
        this.storeEncoded(targetFile, Charset.defaultCharset().name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeEncoded(String targetFile, String encoding) throws ComponentExecutionException {
        CharsetEncoder encoder = XMLObject.getCharset(encoding).newEncoder();
        try {
            FileOutputStream fw = new FileOutputStream(targetFile);
            try {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fw, encoder);
                this.generateXMLEncoded(writer, encoding);
                writer.flush();
                writer.close();
            }
            catch (Throwable throwable) {
                StreamUtils.close(fw);
                throw throwable;
            }
            StreamUtils.close(fw);
        }
        catch (IOException e) {
            throw new ComponentExecutionException(e);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.complexTypeName == null) {
            this.complexTypeName = this.getTagName();
        }
        if (this.context != null && !this.context.isValid()) {
            this.context = null;
        }
    }

    private static class ElementDataHandler
    implements UserDataHandler {
        static final ElementDataHandler INSTANCE = new ElementDataHandler();

        private ElementDataHandler() {
        }

        @Override
        public void handle(short operation, String key, Object data, Node src, Node dst) {
            if (XMLObject.class.getName().equals(key) && src != dst && dst instanceof Element) {
                XMLObject xmlObject = (XMLObject)data;
                xmlObject.setElement((Element)dst);
                XMLObject.assignFields(XMLObject.valueOf(src), xmlObject);
            }
        }
    }

    private static class DummyDocument {
        static final Document VALUE = new XMLDOMImplementation().createDocument(null, "DummyDocument", null);

        private DummyDocument() {
        }
    }

    public static class NSMap
    extends HashMap<String, String> {
        int lastNumber;

        NSMap() {
            this.lastNumber = 1;
        }

        NSMap(NSMap nsmap) {
            super(nsmap);
            this.lastNumber = nsmap.lastNumber;
        }
    }
}

