/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlgen;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.util.ProgressMonitor;
import oracle.bpm.xmlgen.XmlBeanGenerator;
import oracle.bpm.xmlgen.XmlConfiguration;
import oracle.bpm.xmlgen.XmlElementTypeGenerator;
import oracle.bpm.xmlgen.XmlFactoryGenerator;
import oracle.bpm.xmlruntime.XMLSignatureParser;
import oracle.bpm.xmltype.XMLIntrospector;

public class XmlParserGenerator {
    private XmlConfiguration config;

    public XmlParserGenerator(XmlConfiguration config) {
        this.config = config;
    }

    public static void main(String[] args) throws Exception {
        String xsdFileName = args[0];
        String parserDir = args[1];
        String beansDir = args[2];
        String javaPackage = args[3];
        String prefix = args[4];
        boolean generateBaseClasses = Boolean.valueOf(args[5]);
        XmlConfiguration config = new XmlConfiguration();
        config.setJavaPackage(javaPackage);
        config.setPrefix(prefix);
        config.setParserDir(new File(parserDir));
        config.setBeansDir(new File(beansDir));
        File xsdFile = new File(xsdFileName);
        config.setXsdFile(xsdFile);
        config.setGenerateBaseClasses(generateBaseClasses);
        XmlParserGenerator xml = new XmlParserGenerator(config);
        xml.generate();
    }

    public void generate() throws Exception {
        XMLIntrospector xml = new XMLIntrospector();
        Map<String, Object> properties = xml.defaultProperties();
        properties.put("xmlschema", this.config.getXsdFile().toString());
        properties.put("moduleName", "XmlModule");
        DefaultProgressMonitor monitor = new DefaultProgressMonitor();
        MutableComponentCatalog catalog = TypeUtils.getDefaultCatalog(monitor);
        ObjectTypeDescription[] result = xml.introspect(properties, catalog, monitor);
        Map<String, TypeDescription> elements = xml.getElements();
        Map<String, String> tagNames = this.buildTagNameMapping(result);
        for (String tagName : elements.keySet()) {
            TypeDescription type = elements.get(tagName);
            if (type.getKind() == 12) {
                type = type.getElementType();
            }
            if (!type.isObject()) continue;
            tagNames.put(tagName, this.getPrefix() + type.getName());
        }
        this.generateBeans(result, elements);
        this.generateBaseClass();
        XmlElementTypeGenerator elementGenerator = new XmlElementTypeGenerator(this.config);
        elementGenerator.generate(tagNames);
        XmlFactoryGenerator factoryGenerator = new XmlFactoryGenerator(this.config);
        factoryGenerator.generate(tagNames);
        this.generateParser(elements);
    }

    public void generateBaseClass() throws IOException {
        IndentedPrintWriter out = null;
        if (this.config.isGenerateBaseClasses().booleanValue()) {
            File file = this.config.openBeanFile("BaseElement");
            if (!file.exists()) {
                out = this.config.openBean("BaseElement");
            }
        } else {
            out = this.config.openClass("BaseElement");
        }
        if (out != null) {
            out.println("package " + this.config.getJavaPackage() + ";");
            out.println();
            out.println("import oracle.bpm.xmlparser.DefaultElement;");
            out.println();
            out.println("public class " + this.getPrefix() + "BaseElement extends DefaultElement {");
            out.println("}");
            out.close();
        }
    }

    private Map<String, String> buildTagNameMapping(ObjectTypeDescription[] result) {
        TreeMap<String, String> tags = new TreeMap<String, String>();
        for (ObjectTypeDescription type : result) {
            int count = type.getInnerTypeCount();
            for (int i = 0; i < count; ++i) {
                for (MethodTypeDescription member : type.getInnerType(i).getAttributes()) {
                    TypeDescription resultType = member.getResultType();
                    if (resultType.getKind() == 12) {
                        resultType = resultType.getElementType();
                    }
                    if (!resultType.isObject()) continue;
                    String signature = member.getSignature();
                    XMLSignatureParser xmlSignatureParser = XMLSignatureParser.buildSignature(signature, null);
                    String name = xmlSignatureParser.getName();
                    tags.put(name, this.getPrefix() + resultType.getName());
                }
            }
        }
        return tags;
    }

    private void generateParser(Map<String, TypeDescription> elements) throws IOException {
        IndentedPrintWriter out = this.config.openClass("ElementParser");
        out.println("package " + this.config.getJavaPackage() + ";");
        out.println();
        out.println("import oracle.bpm.xmlparser.ParserException;");
        out.println("import java.io.File;");
        out.println("import java.io.Reader;");
        out.println("import java.net.URL;");
        out.println();
        out.println("public class " + this.getPrefix() + "ElementParser");
        out.println("    extends oracle.bpm.xmlparser.Parser");
        out.println("{");
        out.indent();
        out.println("public " + this.getPrefix() + "ElementParser() {");
        out.println("    setElementFactory(new " + this.getPrefix() + "ElementFactory());");
        out.println("}");
        for (String name : elements.keySet()) {
            TypeDescription type = elements.get(name);
            if (!type.isObject()) continue;
            out.println();
            out.print("public ");
            out.print(this.getPrefix() + type.getName());
            out.print(" parse");
            out.print(type.getName());
            out.println("(URL url)");
            out.println("    throws ParserException");
            out.println("{");
            out.println("    return super.parse(url, " + this.getPrefix() + type.getName() + ".class);");
            out.println("}");
            out.println();
            out.print("public ");
            out.print(this.getPrefix() + type.getName());
            out.print(" parse");
            out.print(type.getName());
            out.println("(URL url, Reader input)");
            out.println("    throws ParserException");
            out.println("{");
            out.println("    return super.parse(url, input, " + this.getPrefix() + type.getName() + ".class);");
            out.println("}");
            out.println();
            out.print("public ");
            out.print(this.getPrefix() + type.getName());
            out.print(" parse");
            out.print(type.getName());
            out.println("(File file)");
            out.println("    throws ParserException");
            out.println("{");
            out.println("    return super.parse(file, " + this.getPrefix() + type.getName() + ".class);");
            out.println("}");
        }
        out.dedent();
        out.println("}");
        out.close();
    }

    private String getPrefix() {
        return this.config.getPrefix();
    }

    private void generateBeans(ObjectTypeDescription[] result, Map<String, TypeDescription> elements) throws Exception {
        XmlBeanGenerator beanGenerator = new XmlBeanGenerator(this.config, elements);
        for (ObjectTypeDescription type : result) {
            int count = type.getInnerTypeCount();
            for (int i = 0; i < count; ++i) {
                beanGenerator.generateBean(type.getInnerType(i).asObject());
            }
        }
    }

    private static final class DefaultProgressMonitor
    implements ProgressMonitor {
        private DefaultProgressMonitor() {
        }

        @Override
        public void error(Msg message) {
            System.err.println(message);
        }

        @Override
        public void info(Msg message) {
        }

        @Override
        public void info(int logLevel, Msg message) {
        }

        @Override
        public void phase(Msg message) {
        }

        @Override
        public void progress(int percent) {
        }

        @Override
        public void warning(Msg message) {
        }
    }
}

