/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlgen;

import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.type.JavaClassGenerator;
import oracle.bpm.xmlgen.XmlConfiguration;

public class XmlEnumGenerator
extends JavaClassGenerator {
    private final XmlConfiguration config;

    XmlEnumGenerator(XmlConfiguration config) {
        this.config = config;
    }

    @Override
    protected void generateClassDeclaration(IndentedPrintWriter out, ObjectTypeDescription type) {
        out.print("public enum ");
        this.generateClassName(out, type);
        out.println();
    }

    @Override
    protected void generateClassName(IndentedPrintWriter out, ObjectTypeDescription type) {
        out.print(this.getClassName(type));
    }

    @Override
    protected void generateClassFields(IndentedPrintWriter out, ObjectTypeDescription type) {
        String[] labels = type.asEnum().getLabels();
        boolean first = true;
        for (String label : labels) {
            if (!first) {
                out.println(",");
            }
            first = false;
            out.print(label);
        }
        out.println(";");
    }

    @Override
    protected void generateClassBody(IndentedPrintWriter out, ObjectTypeDescription type) {
        out.println("{");
        out.indent();
        this.generateClassFields(out, type);
        out.println();
        out.dedent();
        out.println("}");
    }

    private String getClassName(ObjectTypeDescription type) {
        return this.config.getPrefix() + type.getName();
    }
}

