/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlgen;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import oracle.bpm.io.IndentedPrintWriter;

public class XmlConfiguration {
    private File beansDir;
    private Boolean generateBaseClasses = Boolean.FALSE;
    private String javaPackage;
    private File parserDir;
    private String prefix = "";
    private String requires;
    private File xsdFile;

    public File getXsdFile() {
        return this.xsdFile;
    }

    public void setXsdFile(File xsdFile) {
        this.xsdFile = xsdFile;
    }

    public File getParserDir() {
        return this.parserDir;
    }

    public void setParserDir(File targetDir) {
        this.parserDir = targetDir;
    }

    public String getRequires() {
        return this.requires;
    }

    public void setRequires(String requires) {
        this.requires = requires;
    }

    public File getBeansDir() {
        return this.beansDir;
    }

    public void setBeansDir(File beansDir) {
        this.beansDir = beansDir;
    }

    public String getJavaPackage() {
        return this.javaPackage;
    }

    public void setJavaPackage(String javaPackage) {
        this.javaPackage = javaPackage;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setGenerateBaseClasses(Boolean generateBaseClasses) {
        this.generateBaseClasses = generateBaseClasses;
    }

    public Boolean isGenerateBaseClasses() {
        return this.generateBaseClasses;
    }

    public IndentedPrintWriter openClass(String name) throws IOException {
        return this.openClass(name, this.getParserDir());
    }

    public IndentedPrintWriter openBean(String name) throws IOException {
        return this.openClass(name, this.getBeansDir());
    }

    public File openBeanFile(String name) {
        return this.openFile(name, this.getBeansDir());
    }

    public IndentedPrintWriter openClass(String name, File targetDir) throws IOException {
        File file = this.openFile(name, targetDir);
        FileWriter writer = new FileWriter(file);
        IndentedPrintWriter out = new IndentedPrintWriter(writer);
        out.setIndentationString("    ");
        return out;
    }

    public File openFile(String name, File targetDir) {
        String javaPackage = this.getJavaPackage();
        File dir = new File(targetDir, javaPackage.replace('.', File.separatorChar));
        dir.mkdirs();
        return new File(dir, this.getPrefix() + name + ".java");
    }
}

