/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import oracle.bpm.geom.Point;
import oracle.bpm.project.model.features.ProcessLayoutFeature;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.ProcessLayoutOrientation;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.Subprocess;

public class SimpleModelUtils {
    private static long nextSequenceFlowId = -1L;
    private static final String ACTIVITY_ID_PREFIX = "activity";
    private static final String SEQUENCE_FLOW_ID_PREFIX = "sf";

    public static Lane getLane(Process process, Point location) {
        int activityOffset = location.getY();
        if (SimpleModelUtils.isVerticalOrientation(process)) {
            activityOffset = location.getX();
        }
        Lane result = null;
        for (Lane lane : process.getLanes()) {
            if (lane.getOffset() > activityOffset || activityOffset >= lane.getOffset() + lane.getSize()) continue;
            result = lane;
            break;
        }
        return result;
    }

    public static String nextIdForActivity(Process process) {
        String result;
        int i = 0;
        do {
            result = ACTIVITY_ID_PREFIX;
            if (i > 0) {
                result = result + i;
            }
            ++i;
        } while (process.findDescendant(Activity.class, result) != null);
        return result;
    }

    public static Collection<SequenceFlow> getAllSequenceFlows(NodeContainer container) {
        ArrayList<SequenceFlow> all = new ArrayList<SequenceFlow>();
        container.getSequenceFlows().addAllTo(all);
        for (Subprocess sp : container.getActivities(Subprocess.class)) {
            all.addAll(SimpleModelUtils.getAllSequenceFlows(sp));
        }
        return all;
    }

    public static String nextIdForSequenceFlow(Process process) {
        String result;
        while (process.findSequenceFlow(result = SEQUENCE_FLOW_ID_PREFIX + SimpleModelUtils.nextSequenceFlowId(process)) != null) {
        }
        return result;
    }

    private static String nextSequenceFlowId(Process process) {
        if (nextSequenceFlowId == -1L) {
            Collection<SequenceFlow> allSequenceFlows = SimpleModelUtils.getAllSequenceFlows(process);
            if (!allSequenceFlows.isEmpty()) {
                SequenceFlow flow = (SequenceFlow)SimpleModelUtils.getMax(allSequenceFlows);
                nextSequenceFlowId = Long.valueOf(flow.getId().substring(2));
            } else {
                nextSequenceFlowId = 1L;
            }
        }
        return "" + nextSequenceFlowId++;
    }

    private static FlowElement getMax(Collection<? extends FlowElement> allNodes) {
        return Collections.max(allNodes, new Comparator<FlowElement>(){

            @Override
            public int compare(FlowElement o1, FlowElement o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
    }

    private static boolean isVerticalOrientation(Process process) {
        return ((ProcessLayoutOrientation)((Object)process.getFeature(ProcessLayoutFeature.class).getValue())).isVertical();
    }
}

