/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.data.MeasurementType;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.Localizable;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.SimulationsContainer;
import oracle.bpm.project.model.activityguide.ActivityGuide;
import oracle.bpm.project.model.activityguide.MilestoneActivity;
import oracle.bpm.project.model.exception.InvalidTransitionFromLocationException;
import oracle.bpm.project.model.exception.MoreThanOneUnconditionalTransitionToTheSameActivityException;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.ActivityPermissionFeature;
import oracle.bpm.project.model.features.IsCollapsedFeature;
import oracle.bpm.project.model.features.ProcessLayoutFeature;
import oracle.bpm.project.model.features.ProcessSealTypeFeature;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.BusinessRuleTask;
import oracle.bpm.project.model.processes.CallActivity;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.CheckedEventTriggerHandler;
import oracle.bpm.project.model.processes.CheckedFlowNodeHandler;
import oracle.bpm.project.model.processes.ComplexGateway;
import oracle.bpm.project.model.processes.ConversationEnabled;
import oracle.bpm.project.model.processes.Counter;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventBasedGateway;
import oracle.bpm.project.model.processes.EventTriggerHandler;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.ExclusiveGateway;
import oracle.bpm.project.model.processes.FindInPath;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.FlowNodeHandler;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.GatewayDirection;
import oracle.bpm.project.model.processes.InclusiveGateway;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.LaneUtils;
import oracle.bpm.project.model.processes.ManualTask;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.ParallelGateway;
import oracle.bpm.project.model.processes.Positional;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.ProcessSealType;
import oracle.bpm.project.model.processes.ReceiveTask;
import oracle.bpm.project.model.processes.ScriptTask;
import oracle.bpm.project.model.processes.SendTask;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.ServiceTask;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.bpm.project.model.processes.ThrowEvent;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.processes.activities.ActivityLevelFeature;
import oracle.bpm.project.model.processes.activities.ActivityPermissionType;
import oracle.bpm.project.model.processes.activities.FirstActivityInFlowFeature;
import oracle.bpm.project.model.processes.activities.GatewayDirectionFeature;
import oracle.bpm.project.model.processes.activities.HasInstanceAccessFeature;
import oracle.bpm.project.model.processes.activities.NodeAssociationFeature;
import oracle.bpm.project.model.util.SimpleModelUtils;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModelUtils
extends SimpleModelUtils {
    public static final int A = 0;
    public static final int B = 1;
    public static final int C = 2;
    private static final Predicate<FlowNode> IS_START_NODE = new Predicate<FlowNode>(){

        public boolean check(@Nullable FlowNode value) {
            boolean isStart = false;
            if (value != null) {
                boolean bl = isStart = value.isEvent() && value.asAnyNode(StartEvent.class) != null;
                if (!isStart && value.isGateway()) {
                    EventBasedGateway gateway = value.asAnyNode(EventBasedGateway.class);
                    isStart = gateway != null && gateway.isInstantiate();
                }
            }
            return isStart;
        }
    };
    private static final Predicate<SequenceFlow> UNCONDITIONALS_ONLY = new Predicate<SequenceFlow>(){

        public boolean check(@Nullable SequenceFlow value) {
            return value != null && value.isNormalFlow();
        }
    };
    private static final Comparator<Localizable> LOCALIZABLE_COMPARATOR = new Comparator<Localizable>(){

        @Override
        public int compare(@NotNull Localizable lewis, @NotNull Localizable clark) {
            return lewis.getDefaultLabel().compareTo(clark.getDefaultLabel());
        }
    };
    public static final Function<FlowNode, Iterator<FlowNode>> SUB_PROCESS_TRAVERSAL = new Function<FlowNode, Iterator<FlowNode>>(){

        public Iterator<FlowNode> eval(FlowNode flowNode) {
            Activity activity;
            Iterator<FlowNode> result = flowNode.isActivity() ? ((activity = flowNode.asAnyNode(Activity.class)).isSubprocess() ? this.subProcessIterator(flowNode.asAnyNode(Subprocess.class)) : (activity.isCallActivity() ? this.callActivityIterator(activity.asAnyNode(CallActivity.class)) : null)) : null;
            return result;
        }

        private Iterator<FlowNode> subProcessIterator(Subprocess subprocess) {
            assert (subprocess != null);
            return subprocess.getChildrenByType(FlowNode.class).iterator();
        }

        private Iterator<FlowNode> callActivityIterator(CallActivity callActivity) {
            assert (callActivity != null);
            Process process = callActivity.getCalledElement();
            if (process != null) {
                return process.getChildrenByType(FlowNode.class).iterator();
            }
            return null;
        }
    };
    public static final Function<FlowElement, Iterator<FlowElement>> SUB_PROCESS_FLOW_ELEMENT_TRAVERSAL = new Function<FlowElement, Iterator<FlowElement>>(){

        public Iterator<FlowElement> eval(FlowElement flowElement) {
            Activity activity;
            Iterator<FlowElement> result = flowElement instanceof Activity ? ((activity = (Activity)flowElement).isSubprocess() ? this.subProcessIterator(activity.asAnyNode(Subprocess.class)) : (activity.isCallActivity() ? this.callActivityIterator(activity.asAnyNode(CallActivity.class)) : null)) : null;
            return result;
        }

        private Iterator<FlowElement> subProcessIterator(Subprocess subprocess) {
            assert (subprocess != null);
            return subprocess.getChildrenByType(FlowElement.class).iterator();
        }

        private Iterator<FlowElement> callActivityIterator(CallActivity callActivity) {
            assert (callActivity != null);
            Process process = callActivity.getCalledElement();
            if (process != null) {
                return process.getChildrenByType(FlowElement.class).iterator();
            }
            return null;
        }
    };
    public static final Predicate<FlowNode> ACTIVITY_FILTER = new Predicate<FlowNode>(){

        public boolean check(@Nullable FlowNode value) {
            return value != null && value.isActivity();
        }
    };
    public static final Predicate<FlowNode> ACTIVITY_OR_EVENT_FILTER = new Predicate<FlowNode>(){

        public boolean check(@Nullable FlowNode value) {
            return value != null && (value.isActivity() || value.isEvent());
        }
    };
    public static final Predicate<FlowElement> MEASUREMENTS_FILTER = new Predicate<FlowElement>(){

        public boolean check(@Nullable FlowElement value) {
            return value != null && value instanceof Measurement;
        }
    };
    public static final Predicate<FlowNode> ACTIVTY_LIKE_FLOWNODE_FILTER = new Predicate<FlowNode>(){

        public boolean check(@Nullable FlowNode value) {
            return value != null && (value.isActivity() || value.isEvent() || value.isGateway());
        }
    };
    public static final Predicate<FlowNode> ACTIVTY_IS_INTERACTIVE = new Predicate<FlowNode>(){

        public boolean check(@Nullable FlowNode value) {
            return value != null && ModelUtils.isAnyInteractive(value);
        }
    };
    public static final Predicate<FlowNode> FLOWNODE_IS_NOT_INTERACTIVE = new Predicate<FlowNode>(){

        public boolean check(@Nullable FlowNode value) {
            return value != null && !ModelUtils.isStartEvent(value) && !ModelUtils.isAnyInteractive(value);
        }
    };
    public static final Predicate<FlowNode> ACTIVITY_IS_NOT_START_OR_END = new Predicate<FlowNode>(){

        public boolean check(@Nullable FlowNode value) {
            return !ModelUtils.isStartOrEndEvent(value);
        }
    };
    public static final Predicate<Activity> CALL_ACTIVITY_FILTER = new Predicate<Activity>(){

        public boolean check(@Nullable Activity value) {
            return value != null && value.isCallActivity();
        }
    };
    public static final Predicate<FlowNode> MESSAGE_FILTER = new Predicate<FlowNode>(){

        public boolean check(@Nullable FlowNode value) {
            return value != null && value.isEvent() && value.asAnyNode(Event.class).getEventTriggerType() == EventTriggerType.MESSAGE;
        }
    };
    public static final Predicate<FlowNode> EVENT_FILTER = new Predicate<FlowNode>(){

        public boolean check(@Nullable FlowNode value) {
            return value != null && value.isEvent();
        }
    };
    public static final Predicate<FlowNode> INITIATOR_CONVERSATION_FILTER = new Predicate<FlowNode>(){

        public boolean check(@Nullable FlowNode value) {
            return value != null && value.isConversationMember() && ((ConversationEnabled)value).getConversationInitiator() == null;
        }
    };
    public static final Predicate<FlowNode> CONTINUE_CONVERSATION_FILTER = new Predicate<FlowNode>(){

        public boolean check(@Nullable FlowNode value) {
            return value != null && value.isConversationMember() && ((ConversationEnabled)value).getConversationInitiator() != null;
        }
    };
    public static final Predicate<FlowNode> SIGNAL_FILTER = new Predicate<FlowNode>(){

        public boolean check(@Nullable FlowNode value) {
            return value != null && value.isEvent() && value.asAnyNode(Event.class).getEventTriggerType() == EventTriggerType.SIGNAL;
        }
    };

    public static boolean isAnySplit(@NotNull FlowNode node) {
        boolean result = false;
        if (node.isGateway()) {
            Gateway gateway = node.asAnyNode(Gateway.class);
            result = gateway.getDirection() == GatewayDirection.DIVERGING;
        }
        return result;
    }

    public static String generateRoleId(Organization organization, String roleName) {
        String newId = Str.replace((String)roleName, (String)" ", (String)"");
        Role role = organization.findRoleById(newId);
        int counter = 1;
        while (role != null) {
            newId = newId + "_" + counter;
            role = organization.findRoleById(newId);
            ++counter;
        }
        return newId;
    }

    public static String generateOrganizationalUnitId(Organization organization) {
        String newId;
        while (organization.findDescendant(OrganizationalUnit.class, newId = ModelUtils.generateGuid()) != null) {
        }
        return newId;
    }

    public static String generateCalendarRuleId(Organization organization) {
        String newId;
        while (organization.findDescendant(CalendarRule.class, newId = ModelUtils.generateGuid()) != null) {
        }
        return newId;
    }

    public static boolean isAnyJoin(@NotNull FlowNode node) {
        boolean result = false;
        if (node.isGateway()) {
            Gateway gateway = node.asAnyNode(Gateway.class);
            result = gateway.getDirection() == GatewayDirection.CONVERGING;
        }
        return result;
    }

    public static String generateGuid() {
        return UUID.randomUUID().toString();
    }

    public static boolean isAnyParentSubprocessCollapsed(@NotNull FlowNode node) {
        Subprocess subprocess = node.getSubprocess();
        return subprocess != null && (ModelUtils.isCollapsed(subprocess) || ModelUtils.isAnyParentSubprocessCollapsed(subprocess));
    }

    public static <T extends Event> void handleEventTrigger(T event, EventTriggerHandler<T> handler) {
        switch (event.getEventTriggerType()) {
            case CANCEL: {
                handler.handleCancelEvent(event);
                break;
            }
            case COMPENSATION: {
                handler.handleCompensateEvent(event);
                break;
            }
            case CONDITIONAL: {
                handler.handleConditionalEvent(event);
                break;
            }
            case ERROR: {
                handler.handleErrorEvent(event);
                break;
            }
            case ESCALATION: {
                handler.handleEscalationEvent(event);
                break;
            }
            case LINK: {
                handler.handleLinkEvent(event);
                break;
            }
            case MESSAGE: {
                handler.handleMessageEvent(event);
                break;
            }
            case MULTIPLE: {
                handler.handleMultipleEvent(event);
                break;
            }
            case NONE: {
                handler.handleNoneEvent(event);
                break;
            }
            case SIGNAL: {
                handler.handleSignalEvent(event);
                break;
            }
            case TERMINATE: {
                handler.handleTerminateEvent(event);
                break;
            }
            case TIMER: {
                handler.handleTimerEvent(event);
            }
        }
    }

    public static void handleEventTriggerChecked(Event event, CheckedEventTriggerHandler handler) throws ProjectException {
        switch (event.getEventTriggerType()) {
            case CANCEL: {
                handler.handleCancelEvent(event);
                break;
            }
            case COMPENSATION: {
                handler.handleCompensateEvent(event);
                break;
            }
            case CONDITIONAL: {
                handler.handleConditionalEvent(event);
                break;
            }
            case ERROR: {
                handler.handleErrorEvent(event);
                break;
            }
            case ESCALATION: {
                handler.handleEscalationEvent(event);
                break;
            }
            case LINK: {
                handler.handleLinkEvent(event);
                break;
            }
            case MESSAGE: {
                handler.handleMessageEvent(event);
                break;
            }
            case MULTIPLE: {
                handler.handleMultipleEvent(event);
                break;
            }
            case NONE: {
                handler.handleNoneEvent(event);
                break;
            }
            case SIGNAL: {
                handler.handleSignalEvent(event);
                break;
            }
            case TERMINATE: {
                handler.handleTerminateEvent(event);
                break;
            }
            case TIMER: {
                handler.handleTimerEvent(event);
            }
        }
    }

    public static void handleFlowNode(FlowNode node, FlowNodeHandler handler) {
        handler.handleCommon(node);
        switch (node.getBpmnType()) {
            case ABSTRACT_ACTIVITY: {
                handler.handleAbstractActivity(node.asAnyNode(Activity.class));
                break;
            }
            case BOUNDARY_EVENT: {
                handler.handleBoundaryEvent(node.asAnyNode(BoundaryEvent.class));
                break;
            }
            case BUSINESS_RULE_TASK: {
                handler.handleBusinessRuleTask(node.asAnyNode(BusinessRuleTask.class));
                break;
            }
            case CALL_ACTIVITY: {
                handler.handleCallActivity(node.asAnyNode(CallActivity.class));
                break;
            }
            case CATCH_INTERMEDIATE_EVENT: {
                handler.handleCatchIntermediateEvent(node.asAnyNode(CatchEvent.class));
                break;
            }
            case END_EVENT: {
                handler.handleEndEvent(node.asAnyNode(EndEvent.class));
                break;
            }
            case EXCLUSIVE_GATEWAY: {
                handler.handleExclusiveGateway(node.asAnyNode(ExclusiveGateway.class));
                break;
            }
            case INCLUSIVE_GATEWAY: {
                handler.handleInclusiveGateway(node.asAnyNode(InclusiveGateway.class));
                break;
            }
            case PARALLEL_GATEWAY: {
                handler.handleParallelGateway(node.asAnyNode(ParallelGateway.class));
                break;
            }
            case EVENT_BASED_GATEWAY: {
                handler.handleEventBasedGateway(node.asAnyNode(EventBasedGateway.class));
                break;
            }
            case COMPLEX_GATEWAY: {
                handler.handleComplexGateway(node.asAnyNode(ComplexGateway.class));
                break;
            }
            case RECEIVE_TASK: {
                handler.handleReceiveTask(node.asAnyNode(ReceiveTask.class));
                break;
            }
            case SCRIPT_TASK: {
                handler.handleScriptTask(node.asAnyNode(ScriptTask.class));
                break;
            }
            case SEND_TASK: {
                handler.handleSendTask(node.asAnyNode(SendTask.class));
                break;
            }
            case SERVICE_TASK: {
                handler.handleServiceTask(node.asAnyNode(ServiceTask.class));
                break;
            }
            case START_EVENT: {
                handler.handleStartEvent(node.asAnyNode(StartEvent.class));
                break;
            }
            case SUBPROCESS: {
                handler.handleSubprocess(node.asAnyNode(Subprocess.class));
                break;
            }
            case THROW_INTERMEDIATE_EVENT: {
                handler.handleIntermediateThrowEvent(node.asAnyNode(ThrowEvent.class));
                break;
            }
            case USER_TASK: {
                handler.handleUserTask(node.asAnyNode(UserTask.class));
                break;
            }
            case MANUAL_TASK: {
                handler.handleManualTask(node.asAnyNode(ManualTask.class));
            }
        }
    }

    public static void handleFlowNodeChecked(FlowNode node, CheckedFlowNodeHandler handler) throws ProjectException {
        handler.handleCommon(node);
        switch (node.getBpmnType()) {
            case ABSTRACT_ACTIVITY: {
                handler.handleAbstractActivity(node.asAnyNode(Activity.class));
                break;
            }
            case BOUNDARY_EVENT: {
                handler.handleBoundaryEvent(node.asAnyNode(BoundaryEvent.class));
                break;
            }
            case BUSINESS_RULE_TASK: {
                handler.handleBusinessRuleTask(node.asAnyNode(BusinessRuleTask.class));
                break;
            }
            case CALL_ACTIVITY: {
                handler.handleCallActivity(node.asAnyNode(CallActivity.class));
                break;
            }
            case CATCH_INTERMEDIATE_EVENT: {
                handler.handleCatchIntermediateEvent(node.asAnyNode(CatchEvent.class));
                break;
            }
            case END_EVENT: {
                handler.handleEndEvent(node.asAnyNode(EndEvent.class));
                break;
            }
            case EXCLUSIVE_GATEWAY: {
                handler.handleExclusiveGateway(node.asAnyNode(ExclusiveGateway.class));
                break;
            }
            case INCLUSIVE_GATEWAY: {
                handler.handleInclusiveGateway(node.asAnyNode(InclusiveGateway.class));
                break;
            }
            case PARALLEL_GATEWAY: {
                handler.handleParallelGateway(node.asAnyNode(ParallelGateway.class));
                break;
            }
            case EVENT_BASED_GATEWAY: {
                handler.handleEventBasedGateway(node.asAnyNode(EventBasedGateway.class));
                break;
            }
            case COMPLEX_GATEWAY: {
                handler.handleComplexGateway(node.asAnyNode(ComplexGateway.class));
                break;
            }
            case RECEIVE_TASK: {
                handler.handleReceiveTask(node.asAnyNode(ReceiveTask.class));
                break;
            }
            case SCRIPT_TASK: {
                handler.handleScriptTask(node.asAnyNode(ScriptTask.class));
                break;
            }
            case SEND_TASK: {
                handler.handleSendTask(node.asAnyNode(SendTask.class));
                break;
            }
            case SERVICE_TASK: {
                handler.handleServiceTask(node.asAnyNode(ServiceTask.class));
                break;
            }
            case START_EVENT: {
                handler.handleStartEvent(node.asAnyNode(StartEvent.class));
                break;
            }
            case SUBPROCESS: {
                handler.handleSubprocess(node.asAnyNode(Subprocess.class));
                break;
            }
            case THROW_INTERMEDIATE_EVENT: {
                handler.handleIntermediateThrowEvent(node.asAnyNode(ThrowEvent.class));
                break;
            }
            case USER_TASK: {
                handler.handleUserTask(node.asAnyNode(UserTask.class));
                break;
            }
            case MANUAL_TASK: {
                handler.handleManualTask(node.asAnyNode(ManualTask.class));
            }
        }
    }

    public static boolean isExceptionFlow(SequenceFlow flow) {
        CatchEvent catchEvent;
        Event event;
        boolean result = false;
        FlowNode flowNode = flow.getSource();
        if (flowNode.isEvent() && (event = flowNode.asAnyNode(Event.class)).isCatchEvent() && (catchEvent = event.asCatchEvent()) != null) {
            result = catchEvent.isBoundaryEvent() && catchEvent.getEventTriggerType() == EventTriggerType.ERROR;
        }
        return result;
    }

    public static boolean contains(@NotNull NodeContainer container, @NotNull FlowElement flowElement) {
        return container.getChildren().contains((Object)flowElement);
    }

    public static Rectangle getRectangle(List<Positional> objects) {
        int minX = Integer.MAX_VALUE;
        int maxX = 0;
        int minY = Integer.MAX_VALUE;
        int maxY = 0;
        for (Positional positional : objects) {
            Point upperLeft = new Point(positional.getX(), positional.getY());
            Point lowerRight = new Point(positional.getX(), positional.getY());
            if (upperLeft.getX() < minX) {
                minX = upperLeft.getX();
            }
            if (upperLeft.getY() < minY) {
                minY = upperLeft.getY();
            }
            if (lowerRight.getX() > maxX) {
                maxX = lowerRight.getX();
            }
            if (lowerRight.getY() <= maxY) continue;
            maxY = lowerRight.getY();
        }
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }

    @Deprecated
    public static SequenceFlow getClosestTransition(Process model, int cx, int cy) {
        SequenceFlow result = null;
        double minDistance = Double.MAX_VALUE;
        for (SequenceFlow transition : model.getSequenceFlows()) {
            FlowNode from = transition.getSource();
            FlowNode to = transition.getTarget();
            Point middlePoint = new Point(Math.round(from.getX() + (to.getX() - from.getX()) / 2), Math.round(from.getY() + (to.getY() - from.getY()) / 2));
            double distance = middlePoint.distanceSq(new Point(cx, cy));
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            result = transition;
        }
        return result;
    }

    public static SortedSet<FlowNode> buildActivitySortedSet() {
        return new TreeSet<Localizable>(LOCALIZABLE_COMPARATOR);
    }

    public static String nextNameForModel(Project fuegoProject, String name) {
        String validName = name;
        int i = 1;
        while (fuegoProject.findProcess(validName) != null) {
            validName = name + i;
            ++i;
        }
        return validName;
    }

    public static String nextNameForModelSimulation(Process model, String name) {
        String baseName;
        String validName = baseName = Identifier.valid((String)name);
        SimulationsContainer simulationsContainer = model.getProject().getSimulations();
        int i = 1;
        while (simulationsContainer.findModelSimulation(model, validName) != null) {
            validName = baseName + i;
            ++i;
        }
        return validName;
    }

    public static String nextNameForProjectSimulation(Project project, String name) {
        String baseName;
        String validName = baseName = Identifier.valid((String)name);
        int i = 1;
        while (project.getSimulations().findProjectSimulation(validName) != null) {
            validName = baseName + i;
            ++i;
        }
        return validName;
    }

    public static String nextLabelForActivity(NodeContainer container, String name) {
        String validName = Identifier.valid((String)name);
        String nextValidName = validName == null || "".equals(validName) ? "Activity" : validName;
        int i = 1;
        while (container.findNodeByLabel(nextValidName) != null) {
            nextValidName = validName + i;
            ++i;
        }
        return nextValidName;
    }

    public static List<SequenceFlow> getSequenceFlowsBetween(FlowNode from, FlowNode to) {
        ArrayList<SequenceFlow> result = new ArrayList<SequenceFlow>();
        for (SequenceFlow transition : from.getOutgoingSequenceFlows()) {
            if (transition.getTarget() != to) continue;
            result.add(transition);
        }
        return result;
    }

    public static String nextNameForMeasurement(Process model, String suggestedName) {
        String validName;
        String nextValidName = validName = Identifier.valid((String)suggestedName);
        model.getDescendants(Measurement.class);
        int i = 1;
        while (model.findDescendant(Measurement.class, nextValidName) != null) {
            nextValidName = validName + i;
            ++i;
        }
        return nextValidName;
    }

    public static String nextNameForCounter(Process model, String suggestedName) {
        String validName;
        String nextValidName = validName = Identifier.valid((String)suggestedName);
        int i = 1;
        while (model.findCounter(nextValidName) != null) {
            nextValidName = validName + i;
            ++i;
        }
        return nextValidName;
    }

    public static String nextNameForNote(Process model, String suggestedName) {
        String validName;
        String nextValidName = validName = Identifier.valid((String)suggestedName);
        int i = 1;
        while (model.findDescendant(TextAnnotation.class, nextValidName) != null) {
            nextValidName = validName + i;
            ++i;
        }
        return nextValidName;
    }

    public static String getModelTitle(Process process) {
        return ModelUtils.getModelTitle(process, null);
    }

    public static String getModelTitle(Process process, Locale loc) {
        if (process == null) {
            return ProjectModelMsg.PROCESS.getString();
        }
        String title = ModelUtils.getDefaultTitle(process, loc);
        Collection<Process> models = process.getProject().getProcesses();
        for (Process proc : models) {
            if (proc.getId().equals(process.getId()) || !ModelUtils.getDefaultTitle(proc, loc).equals(title)) continue;
            title = title + "(" + process.getId() + ")";
        }
        return title;
    }

    public static String getActivityLevel(FlowNode fuegoNode) {
        ActivityLevelFeature feature = fuegoNode.getFeature(ActivityLevelFeature.class);
        return feature.getValue();
    }

    @Nullable
    public static SequenceFlow findSequenceFlow(FlowNode from, FlowNode to) {
        Sequence<SequenceFlow> sequenceFlowSequence = ModelUtils.getOutgoingSequenceFlows(from);
        for (SequenceFlow sequenceFlow : sequenceFlowSequence) {
            if (sequenceFlow.getTarget() != to) continue;
            return sequenceFlow;
        }
        return null;
    }

    public static boolean isInExceptionHandlerLevel(FlowNode node) {
        String level = ModelUtils.getCurrentLevel(node);
        return level != null && level.equals("Fault Handler Level");
    }

    public static boolean isInCompensateLevel(FlowNode fuegoNode) {
        String firstActivityInFlow = fuegoNode.getFeature(FirstActivityInFlowFeature.class).getValue();
        if (firstActivityInFlow == null) {
            return false;
        }
        Event act = fuegoNode.getProcess().findEvent(firstActivityInFlow);
        return act != null && act.isCatchEvent() && act.getEventTriggerType() == EventTriggerType.COMPENSATION;
    }

    public static String generateDefaultLabel(FlowNode fuegoNode) {
        return ModelUtils.nextLabelForActivity(fuegoNode.getProcess(), fuegoNode.getBpmnType().getString());
    }

    public static boolean isSameObjectInstance(Object object1, Object object2) {
        return object1 == null && object2 == null || object1 != null && object1.equals(object2);
    }

    public static boolean isSameObjectId(ProjectObject projectObject1, ProjectObject projectObject2) {
        return projectObject1 == null && projectObject2 == null || projectObject1 != null && projectObject2 != null && projectObject1.getId().equals(projectObject2.getId());
    }

    public static boolean isConnector(@NotNull FlowNode flowNode) {
        return flowNode.isEvent() && flowNode.asAnyNode(Event.class).getEventTriggerType() == EventTriggerType.LINK;
    }

    public static String getDuplicatedLabel(@NotNull FlowNode flowNode) {
        return flowNode.getLabelMap().getString() + " (" + flowNode.getId() + ")";
    }

    public static void validateTransitionFrom(FlowNode from, SequenceFlow trans) throws MoreThanOneUnconditionalTransitionToTheSameActivityException {
        for (SequenceFlow transition : ModelUtils.getSequenceFlowsBetween(from, trans.getTarget())) {
            if (transition == trans || !transition.isConditionalFlow() && !transition.isNormalFlow() || !trans.isConditionalFlow() && !trans.isNormalFlow()) continue;
            throw new MoreThanOneUnconditionalTransitionToTheSameActivityException(from, trans.getTarget());
        }
    }

    public static double getAngle(Point begin, Point end) {
        double dx = end.getX() - begin.getX();
        double dy = end.getY() - begin.getY();
        return ModelUtils.getAngle(dx, dy);
    }

    public static double getAngle(double dx, double dy) {
        double alfa = dx == 0.0 ? (dy < 0.0 ? -1.5707963267948966 : 1.5707963267948966) : Math.atan(dy / dx);
        if (dx < 0.0) {
            alfa += Math.PI;
        }
        return alfa;
    }

    public static void translateAndRotateControlPoint(SequenceFlow transition, FlowNode objectToBeMoved, Point newLocation) {
        Point pivot;
        if (!transition.isCurve()) {
            return;
        }
        Point oldLocation = new Point(objectToBeMoved.getX(), objectToBeMoved.getY());
        if (transition.getTarget() == objectToBeMoved) {
            FlowNode node = transition.getSource();
            pivot = new Point(node.getX(), node.getY());
        } else if (transition.getSource() == objectToBeMoved) {
            FlowNode nodeTo = transition.getTarget();
            pivot = new Point(nodeTo.getX(), nodeTo.getY());
        } else {
            return;
        }
        Point control = ModelUtils.translateAndRotateControlPoint(newLocation, oldLocation, pivot, transition.getControlPoint());
        transition.setRoutingData(transition.getRoutingMode(), control);
    }

    public static Point translateAndRotateControlPoint(Point newLocation, Point oldLocation, Point pivot, Point ctrlpoint) {
        double pivotToControlPointAngle = ModelUtils.getAngle(pivot, ctrlpoint);
        double pivotToControlPointDistance = Point.distance((double)pivot.getX(), (double)pivot.getY(), (double)ctrlpoint.getX(), (double)ctrlpoint.getY());
        double pivotToOldObjectAngle = ModelUtils.getAngle(pivot, oldLocation);
        double pivotToOldObjectDistance = Point.distance((double)oldLocation.getX(), (double)oldLocation.getY(), (double)pivot.getX(), (double)pivot.getY());
        double pivotToNewObjectAngle = ModelUtils.getAngle(pivot, newLocation);
        double pivotToNewObjectDistance = Point.distance((double)newLocation.getX(), (double)newLocation.getY(), (double)pivot.getX(), (double)pivot.getY());
        double newPivotToControlPointAngle = pivotToControlPointAngle + pivotToNewObjectAngle - pivotToOldObjectAngle;
        double newPivotToControlPointDistance = pivotToControlPointDistance * pivotToNewObjectDistance / pivotToOldObjectDistance;
        double dx = newPivotToControlPointDistance * Math.cos(newPivotToControlPointAngle);
        double dy = newPivotToControlPointDistance * Math.sin(newPivotToControlPointAngle);
        return new Point(pivot.getX() + (int)Math.round(dx), pivot.getY() + (int)Math.round(dy));
    }

    public static boolean isHorizontal(@NotNull Process process) {
        ProcessLayoutFeature feature = process.getFeature(ProcessLayoutFeature.class);
        return !feature.isVertical();
    }

    public static Point calculateControlPoint(SequenceFlow transition, Point ctrl) {
        return ModelUtils.calculateControlPoint(transition.getSource().getLocation(), ctrl, transition.getTarget().getLocation());
    }

    public static Point calculateControlPoint(Point begin, Point middle, Point end) {
        double[] xparams = new double[]{2 * begin.getX() - 4 * middle.getX() + 2 * end.getX(), -3 * begin.getX() + 4 * middle.getX() - end.getX(), begin.getX()};
        double[] yparams = new double[]{2 * begin.getY() - 4 * middle.getY() + 2 * end.getY(), -3 * begin.getY() + 4 * middle.getY() - end.getY(), begin.getY()};
        double ctrlx = (double)end.getX() - xparams[0] - xparams[1] / 2.0;
        double ctrly = (double)end.getY() - yparams[0] - yparams[1] / 2.0;
        return new Point((int)ctrlx, (int)ctrly);
    }

    public static boolean isGroupBegin(@NotNull FlowNode node) {
        return node.getSubprocess() != null && ModelUtils.isStartEvent(node);
    }

    public static boolean isGroupEnd(@NotNull FlowNode node) {
        return node.getSubprocess() != null && ModelUtils.isEndEvent(node);
    }

    @Nullable
    public static Event getSubprocessFirstEndEvent(@NotNull FlowNode node) {
        Activity activity;
        if (node.isActivity() && (activity = node.asAnyNode(Activity.class)).isSubprocess()) {
            Subprocess subprocess = activity.asAnyNode(Subprocess.class);
            return ModelUtils.getAnyEndEvent(subprocess);
        }
        return null;
    }

    @Nullable
    public static Event getSubprocessStartEvent(@NotNull FlowNode node) {
        Activity activity;
        if (node.isActivity() && (activity = node.asAnyNode(Activity.class)).isSubprocess()) {
            Subprocess subprocess = activity.asAnyNode(Subprocess.class);
            return ModelUtils.getStartEvent(subprocess);
        }
        return null;
    }

    public static boolean isStartOrEndEvent(@NotNull FlowNode node) {
        boolean result = node.isEvent();
        if (result) {
            Event event = node.asAnyNode(Event.class);
            result = event.isStart() || event.isEnd();
        }
        return result;
    }

    public static boolean isStartEvent(@NotNull FlowNode node) {
        return node.isEvent() && node.asAnyNode(Event.class).isStart();
    }

    public static boolean isStartFlowNode(@NotNull FlowNode node) {
        return IS_START_NODE.check((Object)node);
    }

    public static boolean isEndEvent(@NotNull FlowNode node) {
        return node.isEvent() && node.asAnyNode(Event.class).isEnd();
    }

    public static boolean isInterGroupTransition(FlowNode source, FlowNode target) {
        Subprocess sourceParent = source.getSubprocess();
        Subprocess targetParent = target.getSubprocess();
        Subprocess sourceGrandParent = sourceParent == null ? null : sourceParent.getSubprocess();
        Subprocess targetGrandParent = targetParent == null ? null : targetParent.getSubprocess();
        return !(sourceParent == targetParent || ModelUtils.isGroupEnd(source) && sourceGrandParent == targetParent || ModelUtils.isGroupBegin(target) && targetGrandParent == sourceParent || ModelUtils.isGroupEnd(source) && ModelUtils.isGroupBegin(target));
    }

    public static boolean checkSourceRelocation(@NotNull SequenceFlow sequenceFlow, @NotNull FlowNode source) throws MoreThanOneUnconditionalTransitionToTheSameActivityException, InvalidTransitionFromLocationException {
        if (ModelUtils.isEndEvent(source)) {
            throw new InvalidTransitionFromLocationException(sequenceFlow, source);
        }
        if (source == sequenceFlow.getSource() || source == sequenceFlow.getTarget()) {
            return false;
        }
        if (sequenceFlow.getTarget() != null && ModelUtils.isInterGroupTransition(source, sequenceFlow.getTarget())) {
            return false;
        }
        ModelUtils.validateTransitionFrom(source, sequenceFlow);
        return true;
    }

    public static boolean canDelete(@NotNull FlowNode node) {
        return !(ModelUtils.isStartEvent(node) && ModelUtils.hasUniqueStartEvent(node.getParentObject()) || ModelUtils.isEndEvent(node) && ModelUtils.hasUniqueEndEvent(node.getParentObject()));
    }

    public static boolean canBeInsertedInATransition(FlowNode fuegoNode) {
        return ModelUtils.canBeInsertedInATransition(fuegoNode, false);
    }

    public static boolean canBeInsertedInATransition(@NotNull FlowNode fuegoNode, boolean relocate) {
        boolean result;
        if (!ModelUtils.shouldHaveIncomingSequenceFlow(fuegoNode) || !ModelUtils.shouldHaveOutgoingSequenceFlow(fuegoNode)) {
            result = false;
        } else {
            Sequence flows = CollectionUtils.concat(fuegoNode.getIncomingSequenceFlows(), fuegoNode.getOutgoingSequenceFlows());
            int incomingAndOutgoing = CollectionUtils.size((Iterable)flows);
            result = fuegoNode.getFeature(NodeAssociationFeature.class) != null ? incomingAndOutgoing <= 1 : incomingAndOutgoing == 0 || relocate;
        }
        return result;
    }

    public static boolean canBeInsertedInTransition(@NotNull FlowNode flowNode, @NotNull SequenceFlow sequenceFlow, boolean relocate) {
        return ModelUtils.canBeInsertedInTransition(flowNode, sequenceFlow, relocate, false);
    }

    public static boolean canBeInsertedInTransition(@NotNull FlowNode flowNode, @NotNull SequenceFlow sequenceFlow, boolean relocate, boolean allowReparenting) {
        boolean result = ModelUtils.canBeInsertedInATransition(flowNode, relocate);
        result &= sequenceFlow.getSource() != flowNode && sequenceFlow.getTarget() != flowNode;
        return result &= allowReparenting || sequenceFlow.getParentObject() == flowNode.getParentObject();
    }

    public static void swap(SequenceFlow transition) {
        FlowNode a = transition.getSource();
        transition.setSource(transition.getTarget());
        transition.setTarget(a);
    }

    public static boolean canBeInParametricRole(FlowNode node) {
        HasInstanceAccessFeature feature = node.getFeature(HasInstanceAccessFeature.class);
        return feature == null || feature.getValue() == false;
    }

    public static void setAssociatedFlowNodes(@NotNull FlowNode node, @NotNull FlowNode associated) {
        NodeAssociationFeature feature = node.getFeature(NodeAssociationFeature.class);
        if (feature != null) {
            feature.setAssociatedNode(associated.getId());
        }
    }

    public static void setPairedAssociatedGateways(@NotNull Gateway split, @NotNull Gateway join) {
        ModelUtils.setAssociatedFlowNodes(split, join);
        ModelUtils.setAssociatedFlowNodes(join, split);
    }

    @Nullable
    public static FlowNode getAssociatedFlowNode(@NotNull FlowNode node) {
        FlowNode result = null;
        NodeAssociationFeature association = node.getFeature(NodeAssociationFeature.class);
        if (association != null) {
            result = association.getAssociatedNode();
        }
        return result;
    }

    public static void setDirectionToPairedAssociatedGateways(@NotNull Gateway split, @NotNull Gateway join) {
        split.getFeature(GatewayDirectionFeature.class).setValue(GatewayDirection.DIVERGING);
        join.getFeature(GatewayDirectionFeature.class).setValue(GatewayDirection.CONVERGING);
    }

    public static boolean hasLane(@NotNull FlowNode flowNode) {
        boolean result = ModelUtils.isAnyInteractive(flowNode);
        if (!result && ModelUtils.isSubprocess(flowNode)) {
            for (FlowNode child : flowNode.asAnyNode(Subprocess.class).getFlowNodes()) {
                if (!ModelUtils.hasLane(child)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static boolean isAnyInteractive(FlowNode node) {
        return node.getBpmnType() == BpmnType.USER_TASK || node.getBpmnType() == BpmnType.MANUAL_TASK;
    }

    public static boolean isInBoundaryFlow(FlowNode node) {
        return !ModelUtils.getSourceBoundaryEvents(node).isEmpty();
    }

    public static Sequence<BoundaryEvent> getSourceBoundaryEvents(FlowNode node) {
        ArrayList<BoundaryEvent> list = new ArrayList<BoundaryEvent>();
        NodeContainer nodeContainer = node.getParentObject();
        Sequence<BoundaryEvent> boundaryEventSequence = nodeContainer.getBoundaryEvents();
        for (BoundaryEvent event : boundaryEventSequence) {
            FindInPath fip = new FindInPath(event, node);
            if (!fip.exists()) continue;
            list.add(event);
        }
        return CollectionUtils.asSequence(list);
    }

    public static Sequence<BoundaryEvent> getBoundaryEventsFor(final FlowNode activity) {
        NodeContainer container = activity.getParentObject();
        Sequence<BoundaryEvent> boundaryEvents = container.getBoundaryEvents();
        Predicate<BoundaryEvent> eventPredicate = new Predicate<BoundaryEvent>(){

            public boolean check(BoundaryEvent event) {
                return event.getBoundaryActivity() == activity;
            }
        };
        return boundaryEvents.select((Predicate)eventPredicate);
    }

    public static boolean shouldHaveIncomingSequenceFlow(@NotNull FlowNode flowNode) {
        Activity activity;
        boolean result = true;
        if (flowNode.isEvent()) {
            Event event = flowNode.asAnyNode(Event.class);
            boolean isBoundary = event.isCatchEvent() && event.asCatchEvent().isBoundaryEvent();
            result = !event.isStart() && !isBoundary;
        } else if (flowNode.isActivity() && (activity = flowNode.asAnyNode(Activity.class)).isSubprocess()) {
            Subprocess subprocess = activity.asActivity(Subprocess.class);
            result = subprocess == null || !subprocess.isTriggeredByEvent();
        }
        return result;
    }

    public static boolean isInEventBasedGateway(Event event) {
        Sequence<SequenceFlow> flowSequence = event.getIncomingSequenceFlows();
        boolean result = false;
        for (SequenceFlow sequenceFlow : flowSequence) {
            if (!ModelUtils.isEventBasedGateway(sequenceFlow.getSource())) continue;
            result = true;
        }
        return result;
    }

    public static boolean isEventBasedGateway(FlowNode source) {
        return source.getBpmnType() == BpmnType.EVENT_BASED_GATEWAY;
    }

    public static boolean shouldHaveOutgoingSequenceFlow(@NotNull FlowNode flowNode) {
        Activity activity;
        boolean result = true;
        if (flowNode.isEvent()) {
            Event event = flowNode.asAnyNode(Event.class);
            result = !event.isEnd();
        } else if (flowNode.isActivity() && (activity = flowNode.asAnyNode(Activity.class)).isSubprocess()) {
            Subprocess subprocess = activity.asActivity(Subprocess.class);
            result = subprocess == null || !subprocess.isTriggeredByEvent();
        }
        return result;
    }

    public static boolean canHaveMoreThanOneOutgoingFlow(@NotNull FlowNode flowNode) {
        boolean result = flowNode.isGateway();
        if (result) {
            result = flowNode.asAnyNode(Gateway.class).getDirection() != GatewayDirection.CONVERGING;
        }
        return result;
    }

    public static boolean canHaveOutgoingConditionalFlows(@NotNull FlowNode flowNode) {
        return ModelUtils.canHaveOutgoingConditionalFlow(flowNode);
    }

    public static boolean isCollapsed(Subprocess subprocess) {
        return subprocess.getFeature(IsCollapsedFeature.class).getValue();
    }

    public static boolean isDueFlow(SequenceFlow flow) {
        boolean result = false;
        FlowNode flowNode = flow.getSource();
        if (ModelUtils.isBoundaryEvent(flowNode)) {
            BoundaryEvent event = flowNode.asAnyNode(BoundaryEvent.class);
            result = event.getEventTriggerType() == EventTriggerType.TIMER;
        }
        return result;
    }

    public static boolean isLink(FlowNode node) {
        Event event;
        boolean result = false;
        if (node.isEvent() && (event = node.asAnyNode(Event.class)).isThrowEvent()) {
            ThrowEvent catchEvent = event.asThrowEvent();
            result = catchEvent.getEventTriggerType() == EventTriggerType.LINK;
        }
        return result;
    }

    public static boolean isSubprocess(FlowNode node) {
        return node.isActivity() && node.asAnyNode(Activity.class).isSubprocess();
    }

    public static Sequence<SequenceFlow> getOutgoingSequenceFlows(final FlowNode flowNode) {
        Predicate<SequenceFlow> sourcePredicate = new Predicate<SequenceFlow>(){

            public boolean check(SequenceFlow sequenceFlow) {
                return sequenceFlow.getSource().getId().equals(flowNode.getId());
            }
        };
        return ModelUtils.getNodeContainer(flowNode).getSequenceFlows().select((Predicate)sourcePredicate);
    }

    public static Sequence<SequenceFlow> getOutgoingUnconditionalSequenceFlows(@NotNull FlowNode flowNode) {
        return ModelUtils.getOutgoingSequenceFlows(flowNode).select(UNCONDITIONALS_ONLY);
    }

    public static Sequence<SequenceFlow> getIncomingSequenceFlows(final FlowNode flowNode) {
        Predicate<SequenceFlow> targetPredicate = new Predicate<SequenceFlow>(){

            public boolean check(SequenceFlow sequenceFlow) {
                return sequenceFlow.getTarget().getId().equals(flowNode.getId());
            }
        };
        return ModelUtils.getNodeContainer(flowNode).getSequenceFlows().select((Predicate)targetPredicate);
    }

    public static boolean isConditionalFlow(SequenceFlow sequenceFlow) {
        return sequenceFlow.isConditionalFlow();
    }

    public static boolean isCallActivity(FlowNode modelObject) {
        return modelObject.isActivity() && modelObject.asAnyNode(Activity.class).isCallActivity();
    }

    @NotNull
    public static <T extends FlowNode, V extends T> Sequence<V> selectBpmnClass(@NotNull Sequence<T> input, final @NotNull Class<V> clazz) {
        Sequence activities = input.select(new Predicate<T>(){

            public boolean check(@Nullable T flowNode) {
                return flowNode != null && flowNode.getBpmnType().getBpmnClass() == clazz;
            }
        });
        return CollectionUtils.selectInstanceOf((Sequence)activities, clazz);
    }

    public static StartEvent getStartEvent(@NotNull NodeContainer container) {
        return (StartEvent)CollectionUtils.first(container.getEvents(StartEvent.class));
    }

    public static Sequence<StartEvent> getAllStartEvents(@NotNull NodeContainer container) {
        return container.getEvents(StartEvent.class);
    }

    public static FlowNode getStartFlowNode(@NotNull NodeContainer container) {
        return (FlowNode)CollectionUtils.first((Iterable)container.getFlowNodes().select(IS_START_NODE));
    }

    public static EndEvent getAnyEndEvent(@NotNull NodeContainer container) {
        return (EndEvent)CollectionUtils.first(container.getEvents(EndEvent.class));
    }

    public static boolean isBoundaryEvent(FlowNode flowNode) {
        return flowNode.isEvent() && flowNode.asAnyNode(Event.class).isCatchEvent() && flowNode.asAnyNode(CatchEvent.class).isBoundaryEvent();
    }

    public static String getCurrentLevel(FlowNode flowNode) {
        return ModelUtils.getCurrentLevel(flowNode, new HashSet<FlowNode>());
    }

    @NotNull
    public static Lane findOrCreateAutomaticLane(@NotNull Process process) {
        Lane automaticLane = LaneUtils.getLaneForId(process, "AutomaticHandler");
        if (automaticLane == null) {
            automaticLane = process.createLane("AutomaticHandler");
            LaneUtils.setOffsetAfterLastLane(automaticLane);
            try {
                process.addChild(automaticLane);
            }
            catch (ProjectException e) {
                throw new RuntimeException((Throwable)((Object)e));
            }
        }
        return automaticLane;
    }

    @Nullable
    public static Counter findCounterByActivity(Process process, Activity activity) {
        for (Counter counter : process.getCounters()) {
            if (!counter.getActivityId().equals(activity.getId())) continue;
            return counter;
        }
        return null;
    }

    public static boolean isTimerEvent(FlowNode flowNode) {
        return flowNode.isEvent() && flowNode.asAnyNode(Event.class).isCatchEvent() && flowNode.asAnyNode(CatchEvent.class).getEventTriggerType() == EventTriggerType.TIMER;
    }

    public static boolean hasTimerBoundaryEvent(Activity activity) {
        Sequence<BoundaryEvent> boundaryEventSequence = activity.getActivityBoundaryEvents();
        for (BoundaryEvent event : boundaryEventSequence) {
            if (event.getEventTriggerType() != EventTriggerType.TIMER) continue;
            return true;
        }
        return false;
    }

    public static boolean isInTemplate(@NotNull ProjectObject projectObject) {
        Project project = projectObject.getProject();
        return project != null && project.getPreferences().isTemplate();
    }

    public static boolean canHaveOutgoingConditionalFlow(FlowNode node) {
        Gateway gateway;
        boolean result = false;
        if (node.isGateway() && (gateway = node.asAnyNode(Gateway.class)).getDirection() != GatewayDirection.CONVERGING && gateway.getBpmnType() != BpmnType.PARALLEL_GATEWAY && gateway.getBpmnType() != BpmnType.EVENT_BASED_GATEWAY) {
            result = true;
        }
        return result;
    }

    public static String getBuiltName(SequenceFlow sequenceFlow) {
        String result;
        if (sequenceFlow.getSource() == null) {
            result = sequenceFlow.getId();
        } else {
            result = sequenceFlow.getSource().getDefaultLabel() + " To ";
            result = sequenceFlow.getTarget() != null ? result + sequenceFlow.getTarget().getDefaultLabel() : result + "??";
        }
        return result;
    }

    public static Sequence<FlowNode> getStartNodes(NodeContainer container) {
        ArrayList<FlowNode> result = new ArrayList<FlowNode>();
        Sequence<FlowNode> flowNodeSequence = container.getFlowNodes();
        for (FlowNode flowNode : flowNodeSequence) {
            if (!flowNode.getIncomingSequenceFlows().isEmpty() || ModelUtils.isBoundaryEvent(flowNode) || ModelUtils.isEventSubprocess(flowNode)) continue;
            result.add(flowNode);
        }
        return CollectionUtils.asSequence(result);
    }

    public static Counter getCounterFor(FlowNode node) {
        Counter result = null;
        Sequence<Counter> counterSequence = node.getProcess().getDescendants(Counter.class);
        for (Counter counter : counterSequence) {
            if (!Any.equals((Object)counter.getActivity(), (Object)node)) continue;
            result = counter;
            break;
        }
        return result;
    }

    public static boolean isNoneEvent(FlowNode startNode) {
        return ModelUtils.isStartEvent(startNode) && startNode.asAnyNode(StartEvent.class).getEventTriggerType() == EventTriggerType.NONE;
    }

    public static boolean isEventSubprocess(@Nullable FlowNode flowNode) {
        return flowNode != null && flowNode.getBpmnType() == BpmnType.SUBPROCESS && flowNode.asAnyNode(Subprocess.class).isTriggeredByEvent();
    }

    public static Sequence<Measurement> getStopMeasurementsFor(Measurement measurement) {
        ArrayList<Measurement> list = new ArrayList<Measurement>();
        Sequence<Measurement> measurements = measurement.getProcess().getDescendants(Measurement.class);
        for (Measurement measurement1 : measurements) {
            if (measurement1.getMeasurementType() != MeasurementType.STOP || measurement1.getRelatedMeasurement() == null || !Any.equals((Object)measurement1.getRelatedMeasurement().getId(), (Object)measurement.getId())) continue;
            list.add(measurement1);
        }
        return CollectionUtils.asSequence(list);
    }

    public static Sequence<FlowNode> getAllActivitiesAndEvents(Process process) {
        return process.getChildrenByType(FlowNode.class).select(ACTIVITY_OR_EVENT_FILTER).flatten(SUB_PROCESS_TRAVERSAL).selectInstanceOf(FlowNode.class);
    }

    public static Sequence<Activity> getAllActivities(Process process) {
        return process.getChildrenByType(FlowNode.class).select(ACTIVITY_FILTER).flatten(SUB_PROCESS_TRAVERSAL).selectInstanceOf(Activity.class);
    }

    public static Sequence<Measurement> getAllMeasurements(Process process) {
        return process.getChildrenByType(FlowElement.class).flatten(SUB_PROCESS_FLOW_ELEMENT_TRAVERSAL).select(MEASUREMENTS_FILTER).selectInstanceOf(Measurement.class);
    }

    public static Sequence<FlowNode> getAllFlowNodes(Process process) {
        return process.getChildrenByType(FlowNode.class).select(ACTIVTY_LIKE_FLOWNODE_FILTER).flatten(SUB_PROCESS_TRAVERSAL);
    }

    public static Sequence<FlowNode> getAllInteractiveActivities(Process process) {
        return process.getChildrenByType(FlowNode.class).select(ACTIVTY_IS_INTERACTIVE).flatten(SUB_PROCESS_TRAVERSAL);
    }

    public static Sequence<FlowNode> getAllNonInteractiveFlowNodes(Process process) {
        return process.getChildrenByType(FlowNode.class).select(FLOWNODE_IS_NOT_INTERACTIVE).flatten(SUB_PROCESS_TRAVERSAL);
    }

    public static Sequence<FlowNode> getAllFlowNodesWithoutStartEnd(Process process) {
        return ModelUtils.getAllFlowNodes(process).select(ACTIVITY_IS_NOT_START_OR_END);
    }

    @Nullable
    public static Activity findActivity(Process process, final String id) {
        Iterator activityIterator = ModelUtils.getAllActivities(process).select((Predicate)new Predicate<Activity>(){

            public boolean check(@Nullable Activity activity) {
                return activity != null && id.equals(activity.getId());
            }
        }).iterator();
        return activityIterator.hasNext() ? (Activity)activityIterator.next() : null;
    }

    public static Sequence<Process> getCalledProcesses(@NotNull Process process) {
        return ModelUtils.getAllActivities(process).select(CALL_ACTIVITY_FILTER).selectInstanceOf(CallActivity.class).map((Function)new Function<CallActivity, Process>(){

            public Process eval(CallActivity value) {
                return value.getCalledElement();
            }
        }).selectInstanceOf(Process.class);
    }

    public static boolean containsInteractive(Lane lane) {
        Sequence<FlowNode> activities = lane.getActivities();
        for (FlowNode activity : activities) {
            if (!ModelUtils.isAnyInteractive(activity)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInAnyMilestone(UserTask userTask) {
        boolean result = false;
        ActivityGuide guide = userTask.getProject().getActivityGuide();
        Sequence<MilestoneActivity> descendants = guide.getDescendants(MilestoneActivity.class);
        for (MilestoneActivity descendant : descendants) {
            if (!Any.equals((Object)descendant.getActivity(), (Object)userTask)) continue;
            result = true;
        }
        return result;
    }

    public static String nextIdFor(@NotNull BpmnType type, @NotNull FlowNode flowNode) {
        String result = null;
        String id = flowNode.getId();
        if (!Str.isEmpty((String)id)) {
            FlowNode node = flowNode.getProcess().findDescendant(FlowNode.class, id);
            result = node != null ? null : id;
        }
        if (result == null) {
            String prepend = null;
            switch (type) {
                case ABSTRACT_ACTIVITY: 
                case BUSINESS_RULE_TASK: 
                case CALL_ACTIVITY: 
                case RECEIVE_TASK: 
                case SCRIPT_TASK: 
                case SEND_TASK: 
                case SERVICE_TASK: 
                case USER_TASK: 
                case MANUAL_TASK: {
                    prepend = "activity";
                    break;
                }
                case SUBPROCESS: {
                    prepend = "subprocess";
                    break;
                }
                case START_EVENT: {
                    prepend = "startEvent";
                    break;
                }
                case THROW_INTERMEDIATE_EVENT: {
                    prepend = "throwEvent";
                    break;
                }
                case BOUNDARY_EVENT: 
                case CATCH_INTERMEDIATE_EVENT: {
                    prepend = "catchEvent";
                    break;
                }
                case END_EVENT: {
                    prepend = "endEvent";
                    break;
                }
                case EVENT: {
                    prepend = "event";
                    break;
                }
                case EXCLUSIVE_GATEWAY: 
                case INCLUSIVE_GATEWAY: 
                case PARALLEL_GATEWAY: 
                case EVENT_BASED_GATEWAY: 
                case COMPLEX_GATEWAY: {
                    prepend = "gateway";
                    break;
                }
                case MEASUREMENT: {
                    prepend = "measurement";
                    break;
                }
                case COUNTER: {
                    prepend = "counter";
                    break;
                }
                case NOTE: {
                    prepend = "textAnnotation";
                }
            }
            int i = 0;
            do {
                if (i >= 0) {
                    result = prepend + i;
                }
                ++i;
            } while (flowNode.getProcess().findDescendant(FlowNode.class, result) != null);
        }
        return result;
    }

    public static boolean isValidTriggerTypeForBoundaryEvent(CatchEvent node) {
        EventTriggerType triggerType = node.getEventTriggerType();
        return triggerType == EventTriggerType.ERROR || triggerType == EventTriggerType.TIMER || triggerType == EventTriggerType.MESSAGE;
    }

    public static boolean canBeSimulated(@NotNull FlowNode node) {
        return !ModelUtils.isEndEvent(node) && node.getBpmnType() != BpmnType.PARALLEL_GATEWAY && !ModelUtils.isAnyJoin(node);
    }

    public static boolean shouldHaveImplementation(FlowNode node) {
        boolean isSealed;
        boolean result = true;
        Project project = node.getProject();
        ActivityPermissionFeature permissionFeature = node.getFeature(ActivityPermissionFeature.class);
        ProcessSealTypeFeature feature = node.getProcess().getFeature(ProcessSealTypeFeature.class);
        ProcessSealType processValue = (ProcessSealType)((Object)feature.getValue());
        boolean processSeal = processValue == ProcessSealType.ACTIVITY_SEALED || processValue == ProcessSealType.SEALED;
        boolean bl = isSealed = permissionFeature.getValue() == ActivityPermissionType.SEALED || permissionFeature.getValue() == ActivityPermissionType.USE_PROCESS_PERMISSION && processSeal;
        if (project.isTemplate() && !isSealed) {
            result = false;
        }
        return result;
    }

    public static Sequence<UserTask> getInitiatorUserTasks(Process container) {
        ArrayList<UserTask> result = new ArrayList<UserTask>();
        Sequence<UserTask> flowNodeSequence = container.getFlowNodes(UserTask.class);
        for (UserTask userTask : flowNodeSequence) {
            if (!userTask.isManualStart()) continue;
            result.add(userTask);
        }
        return CollectionUtils.asSequence(result);
    }

    public static boolean isManualInitiator(StartEvent event) {
        if (event.getEventTriggerType() == EventTriggerType.NONE) {
            Sequence<UserTask> userTasks = ModelUtils.getInitiatorUserTasks(event.getProcess());
            for (UserTask userTask : userTasks) {
                FindInPath path = new FindInPath(event, userTask);
                if (!path.exists()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasNonInterruptingBoundaryEvents(FlowNode flowNode) {
        boolean retVal = false;
        if (flowNode.isActivity()) {
            Activity activity = flowNode.asAnyNode(Activity.class);
            Sequence nonInterruptingBoundaries = activity.getActivityBoundaryEvents().select((Predicate)new Predicate<BoundaryEvent>(){

                public boolean check(@Nullable BoundaryEvent value) {
                    return value != null && !value.cancelActivity();
                }
            });
            retVal = CollectionUtils.size((Iterable)nonInterruptingBoundaries) > 0;
        }
        return retVal;
    }

    private static boolean hasUniqueEndEvent(@NotNull NodeContainer nodeContainer) {
        return CollectionUtils.size(nodeContainer.getEvents(EndEvent.class)) == 1;
    }

    private static boolean hasUniqueStartEvent(@NotNull NodeContainer nodeContainer) {
        return CollectionUtils.size(nodeContainer.getEvents(StartEvent.class)) == 1;
    }

    private static NodeContainer getNodeContainer(@NotNull FlowNode flowNode) {
        return flowNode.getParentObject();
    }

    private static String getDefaultTitle(Process process, Locale loc) {
        String title = loc == null ? process.getDefaultLabel() : process.getLabel(loc);
        title = title == null ? process.getId() : title;
        return title;
    }

    private static String getCurrentLevel(FlowNode fuegoActivity, Set<FlowNode> visitedNodes) {
        String level = null;
        for (SequenceFlow t : fuegoActivity.getIncomingSequenceFlows()) {
            FlowNode from;
            if (t.getSource() == null) {
                level = "Begin Level";
            } else if (ModelUtils.isStartNode(t.getSource())) {
                level = "Begin Level";
            } else if (ModelUtils.isAnySplit(t.getSource())) {
                return t.getSource().getId();
            }
            if (level != null || visitedNodes.contains(from = t.getSource())) continue;
            visitedNodes.add(from);
            return ModelUtils.getCurrentLevel(from, visitedNodes);
        }
        return "Begin Level";
    }

    private static boolean isStartNode(FlowNode source) {
        return source.getIncomingSequenceFlows().isEmpty() && !ModelUtils.isEventSubprocess(source);
    }
}

