/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.processes;

import java.util.Locale;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeFactory;

public enum TransitionType implements I18nProvider
{
    CONDITIONAL(ProjectModelMsg.CONDITION, ProjectModelMsg.NEW_CONDITIONAL, ProjectModelMsg.NEW_CONDITIONAL_TO){

        @Override
        public String getFileName() {
            return "conditional";
        }
    }
    ,
    BUSINESS_RULE(ProjectModelMsg.BUSINESS_RULE, ProjectModelMsg.NEW_BUSINESS_RULE, ProjectModelMsg.NEW_BUSINESS_RULE_TO){

        @Override
        public String getFileName() {
            return "business_rule";
        }
    }
    ,
    UNCONDITIONAL(ProjectModelMsg.UNCONDITIONAL, ProjectModelMsg.NEW_UNCONDITIONAL, ProjectModelMsg.NEW_UNCONDITIONAL_TO),
    DUE(ProjectModelMsg.DUE, ProjectModelMsg.NEW_DUE, ProjectModelMsg.NEW_DUE_TO){

        @Override
        public TypeDescription getReturnType() {
            return TypeFactory.getInterval();
        }

        @Override
        public String getFileName() {
            return "due";
        }
    }
    ,
    DUE_SCHEDULE(ProjectModelMsg.DUE_SCHEDULE, CoreMsg.EMPTY, CoreMsg.EMPTY){

        @Override
        public String getFileName() {
            return "due_schedule";
        }
    }
    ,
    COMPENSATE(ProjectModelMsg.COMPENSATE, ProjectModelMsg.NEW_COMPENSATE, ProjectModelMsg.NEW_COMPENSATE_TO){

        @Override
        public String getFileName() {
            return "compensate";
        }
    }
    ,
    EXCEPTION(ProjectModelMsg.EXCEPTION, ProjectModelMsg.NEW_EXCEPTION, ProjectModelMsg.NEW_EXCEPTION_TO){

        @Override
        public String getFileName() {
            return "exception";
        }
    }
    ,
    MESSAGE_BASED(ProjectModelMsg.MESSAGE_BASED, ProjectModelMsg.NEW_MESSAGE_BASED, ProjectModelMsg.NEW_MESSAGE_BASED_TO){

        @Override
        public String getFileName() {
            return "message_based";
        }
    }
    ,
    DEPENDENCY(ProjectModelMsg.DEPENDENCY, ProjectModelMsg.NEW_DEPENDENCY, ProjectModelMsg.NEW_DEPENDENCY_TO),
    ANY(ProjectModelMsg.ANY, CoreMsg.EMPTY, CoreMsg.EMPTY);

    private transient Msg msg;
    private final Msg msgForNew;
    private final Msg msgForNewTo;

    private TransitionType(Msg msg, Msg msgForNew, Msg msgForNewTo) {
        this.msg = msg;
        this.msgForNew = msgForNew;
        this.msgForNewTo = msgForNewTo;
    }

    public static TransitionType valueOf(int n) {
        return TransitionType.values()[n];
    }

    public static TransitionType getTransitionType(String name) {
        if (name.equals("NORMAL")) {
            return CONDITIONAL;
        }
        if (name.equals("NORMAL_UNCONDITIONAL")) {
            return UNCONDITIONAL;
        }
        if (name.equals("ACTIVITY_EXPIRATION")) {
            return DUE;
        }
        return TransitionType.valueOf(name);
    }

    public String getFileName() {
        return null;
    }

    public boolean isCompensate() {
        return this == COMPENSATE;
    }

    public boolean isDue() {
        return this == DUE;
    }

    public boolean isConditional() {
        return this == CONDITIONAL;
    }

    public boolean isMessageBased() {
        return this == MESSAGE_BASED;
    }

    public boolean isDependency() {
        return this == DEPENDENCY;
    }

    public boolean isException() {
        return this == EXCEPTION;
    }

    public boolean isBusinessRule() {
        return this == BUSINESS_RULE;
    }

    public boolean isUnconditional() {
        return this == UNCONDITIONAL;
    }

    public int intValue() {
        return this.ordinal();
    }

    public String getString() {
        return this.getMsg().getString();
    }

    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    public Msg getMsg() {
        return this.msg;
    }

    public Msg getMsgForNew() {
        return this.msgForNew;
    }

    public Msg getMsgForNewTo() {
        return this.msgForNewTo;
    }

    public String getInternalMessage(SequenceFlow sequenceFlow) {
        return null;
    }

    public String getReportString(SequenceFlow sequenceFlow, Locale language) {
        return "";
    }

    public TypeDescription getReturnType() {
        return TypeFactory.getBool();
    }
}

