/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.processes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.DefaultNodeFinder;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.NodeFinder;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;

public class FindInPath {
    private final NodeFinder comparator;
    private boolean followBoundary = false;
    private boolean foundIt = false;
    private final FlowNode from;
    private Set<FlowNode> nodeTempList = new HashSet<FlowNode>();
    private final FlowNode to;

    public FindInPath(FlowNode from, FlowNode to) {
        this(from, to, new DefaultNodeFinder(to));
    }

    public FindInPath(FlowNode from, FlowNode to, NodeFinder comparator) {
        this.from = from;
        this.to = to;
        this.comparator = comparator;
    }

    public boolean isFollowBoundary() {
        return this.followBoundary;
    }

    public void setFollowBoundary(boolean followBoundary) {
        this.followBoundary = followBoundary;
    }

    public boolean exists() {
        this.foundIt = false;
        this.nodeTempList.clear();
        this.findIt();
        return this.foundIt;
    }

    private void findIt() {
        this.findIt(this.from);
    }

    private void findIt(FlowNode currentFrom) {
        if (this.nodeTempList.contains(currentFrom)) {
            return;
        }
        this.nodeTempList.add(currentFrom);
        ArrayList flows = new ArrayList();
        currentFrom.getOutgoingSequenceFlows().addAllTo(flows);
        if (this.isFollowBoundary()) {
            Sequence<BoundaryEvent> boundaryEventsFor = ModelUtils.getBoundaryEventsFor(currentFrom);
            for (BoundaryEvent boundaryEvent : boundaryEventsFor) {
                boundaryEvent.getOutgoingSequenceFlows().addAllTo(flows);
            }
        }
        for (SequenceFlow transition : flows) {
            if (this.comparator.matches(transition.getTarget())) {
                this.foundIt = true;
                break;
            }
            if (transition.getTarget() == this.to) continue;
            this.findIt(transition.getTarget());
        }
    }
}

