/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.processes;

import java.util.Map;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.XPathExpression;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.PersistentFeature;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.resources.Msg;

public class ExpressionFeature
extends PersistentFeature<Expression> {
    protected Expression expression;

    protected ExpressionFeature(String featureName, Msg label, Msg description) {
        super(featureName, label, description);
    }

    protected ExpressionFeature(String featureName, Msg label, Msg description, Expression expression) {
        super(featureName, label, description);
        this.setValue(expression);
    }

    public static ExpressionFeature create() {
        return new ExpressionFeature("expression", ProjectModelMsg.EXPRESSION, null);
    }

    @Override
    public int getSortHint() {
        return 1;
    }

    @Override
    public Expression getValue() {
        return this.expression;
    }

    @Override
    public Expression getPrevValue() {
        return null;
    }

    @Override
    @Deprecated
    public void setValue(String string) {
        this.setValue((Expression)new XPathExpression(string));
    }

    @Override
    public void setValue(Expression expression) {
        this.expression = expression;
    }

    @Override
    public void copyFrom(Feature feature) {
        super.copyFrom(feature);
        if (feature instanceof ExpressionFeature) {
            this.expression = ((ExpressionFeature)feature).getValue();
        }
    }

    @Override
    public void fill(Map<String, Object> propertiesFor) {
        Object value = propertiesFor.get(this.getName());
        if (value != null) {
            if (value instanceof Expression) {
                this.setValue((Expression)value);
            }
        } else {
            this.setValue((Expression)null);
        }
    }

    @Override
    public boolean mustBeSaved() {
        return false;
    }
}

