/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.features;

import oracle.bpm.lang.FormatException;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionLanguage;
import oracle.bpm.lib.XPathExpression;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.features.EnumFeature;
import oracle.bpm.project.model.features.FeatureSet;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.ExpressionFeature;
import oracle.bpm.project.model.processes.TimerEventType;

public class TimerFeature
extends FeatureSet {
    private TimeCycleFeature timeCycleFeature;
    private TimeDateFeature timeDateFeature = new TimeDateFeature();
    private TimerEventTypeFeature timerEventTypeFeature;

    public TimerFeature() {
        super("timer", ProjectModelMsg.TIME_OUT, null);
        this.addFeature(this.timeDateFeature);
        this.timeCycleFeature = new TimeCycleFeature();
        this.addFeature(this.timeCycleFeature);
        this.timerEventTypeFeature = new TimerEventTypeFeature();
        this.addFeature(this.timerEventTypeFeature);
    }

    public Expression getTimeDateExpression() {
        return this.timeDateFeature.getValue();
    }

    public Expression getTimeCycleExpression() {
        return this.timeCycleFeature.getValue();
    }

    public void setTimeDate(Expression expression) {
        this.timeDateFeature.setValue(expression);
        this.timerEventTypeFeature.setValue(TimerEventType.TIME_DATE);
        this.timeCycleFeature.setValue((Expression)null);
    }

    public void setTimeCycle(Expression expression) {
        this.timeCycleFeature.setValue(expression);
        this.timerEventTypeFeature.setValue(TimerEventType.TIME_CYCLE);
        this.timeDateFeature.setValue((Expression)null);
    }

    public TimerEventType getTimerEventType() {
        return (TimerEventType)((Object)this.timerEventTypeFeature.getValue());
    }

    public ExpressionLanguage getLanguage() {
        ExpressionLanguage language = null;
        if (this.timeCycleFeature.getValue() != null) {
            language = this.timeCycleFeature.getValue().getLanguage();
        } else if (this.timeDateFeature.getValue() != null) {
            language = this.timeDateFeature.getValue().getLanguage();
        }
        return language;
    }

    public boolean isExpression() {
        boolean isExpression = false;
        if (this.timeCycleFeature != null && this.timeCycleFeature.getValue() != null) {
            try {
                Interval.valueOf((String)XPathExpression.fromXPathLiteral((String)this.getTimeCycleExpression().getExpressionValue()));
            }
            catch (FormatException e) {
                isExpression = true;
            }
        }
        if (this.timeDateFeature != null && this.timeDateFeature.getValue() != null) {
            try {
                Time.valueOf((String)XPathExpression.fromXPathLiteral((String)this.getTimeDateExpression().getExpressionValue()));
            }
            catch (FormatException e) {
                isExpression = true;
            }
        }
        return isExpression;
    }

    @Override
    public boolean mustBeSaved() {
        return false;
    }

    private static class TimerEventTypeFeature
    extends EnumFeature<TimerEventType> {
        public TimerEventTypeFeature() {
            super(TimerEventType.class, "timerType", CoreMsg.TYPE, null, TimerEventType.TIME_CYCLE);
        }
    }

    private static class TimeDateFeature
    extends ExpressionFeature {
        public TimeDateFeature() {
            super("timeDate", ProjectModelMsg.TIME_DATE, ProjectModelMsg.TIME_DATE_DSC);
        }
    }

    private static class TimeCycleFeature
    extends ExpressionFeature {
        public TimeCycleFeature() {
            super("timeCycle", ProjectModelMsg.TIME_CYCLE, ProjectModelMsg.TIME_CYCLE_DSC);
        }
    }
}

