/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.features;

import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.features.AbstractDataAssociationFeature;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.InputDataAssociationEnabled;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.OutputDataAssociationEnabled;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.dataassociations.DataAssociation;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationItem;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSetType;
import oracle.bpm.project.model.processes.dataassociations.DataTransformation;
import oracle.bpm.resources.Msg;

public abstract class SingleDataAssociationFeature
extends AbstractDataAssociationFeature {
    private DataAssociationSet dataAssociationSet;
    private DataAssociationSetType dataAssociationSetType;
    private FlowNode flowNode;
    private Process process;
    private boolean usesTransformations;

    protected SingleDataAssociationFeature(String featureName, Msg label, FlowNode flowNode, DataAssociationSetType dataAssociationSetType) {
        this(featureName, label, flowNode, null, dataAssociationSetType);
    }

    protected SingleDataAssociationFeature(String featureName, Msg label, Process process, DataAssociationSetType dataAssociationSetType) {
        this(featureName, label, null, process, dataAssociationSetType);
    }

    protected SingleDataAssociationFeature(String featureName, Msg label, FlowNode flowNode, Process process, DataAssociationSetType dataAssociationSetType) {
        super(featureName, label);
        this.flowNode = flowNode;
        this.process = process;
        this.dataAssociationSetType = dataAssociationSetType;
        this.usesTransformations = false;
        this.initDataAssociationSet();
    }

    public DataAssociationSet getDataAssociationSet() {
        return this.dataAssociationSet;
    }

    public boolean usesTransformations() {
        return this.usesTransformations;
    }

    public void setUsesTransformations(boolean usesTransformations) {
        this.usesTransformations = usesTransformations;
    }

    @Override
    public void copyFrom(Feature feature) {
        super.copyFrom(feature);
        if (feature instanceof SingleDataAssociationFeature) {
            SingleDataAssociationFeature sourceFeature = (SingleDataAssociationFeature)feature;
            this.setUsesTransformations(sourceFeature.usesTransformations());
            DataAssociationSet sourceDataAssociationSet = sourceFeature.getDataAssociationSet();
            DataAssociationSet targetDataAssociationSet = this.getDataAssociationSet();
            if (sourceDataAssociationSet != null) {
                targetDataAssociationSet.setType(sourceDataAssociationSet.getType());
                targetDataAssociationSet.setExpressionMode(sourceDataAssociationSet.getExpressionMode());
                targetDataAssociationSet.clearDataAssociations();
                targetDataAssociationSet.clearDataTransformations();
                for (DataAssociation dataAssoc : sourceDataAssociationSet.getDataAssociations()) {
                    DataAssociationItem source = targetDataAssociationSet.createDataAssociationItem(dataAssoc.getSource().getEndpoint(), dataAssoc.getSource().getExpression(), dataAssoc.getSource().getDataAssociationItemRefs());
                    DataAssociationItem target = targetDataAssociationSet.createDataAssociationItem(dataAssoc.getTarget().getEndpoint(), dataAssoc.getTarget().getExpression(), dataAssoc.getTarget().getDataAssociationItemRefs());
                    DataAssociation association = targetDataAssociationSet.createDataAssociation(source, target);
                    association.setIsCustom(dataAssoc.isCustom());
                    targetDataAssociationSet.addDataAssociation(association);
                }
                for (DataTransformation dataTransformation : sourceDataAssociationSet.getDataTransformations()) {
                    targetDataAssociationSet.addDataTransformation(dataTransformation);
                }
            }
        }
    }

    @Override
    protected void initDataAssociationSet() {
        NodeContainer container = null;
        if (this.flowNode != null) {
            container = this.flowNode.getParentObject();
        } else if (this.process != null) {
            container = this.process;
        }
        if (container != null) {
            if (this.dataAssociationSetType.equals((Object)DataAssociationSetType.INPUT)) {
                assert (this.getFeatureElement() instanceof InputDataAssociationEnabled) : "The element must be an input data associations enabled";
                this.dataAssociationSet = container.createInputDataAssociationSet((InputDataAssociationEnabled)((Object)this.getFeatureElement()), this.getFeatureElement());
            } else {
                assert (this.getFeatureElement() instanceof OutputDataAssociationEnabled) : "The element must be an output data associations enabled";
                this.dataAssociationSet = container.createOutputDataAssociationSet((OutputDataAssociationEnabled)((Object)this.getFeatureElement()), this.getFeatureElement());
            }
        }
    }

    private DataDeclarationContainer getFeatureElement() {
        return this.flowNode != null ? this.flowNode : this.process;
    }
}

