/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.features;

import oracle.bpm.project.model.features.FeatureSet;
import oracle.bpm.project.model.features.StringFeature;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.resources.Msg;

public class ExternalTaskFeature
extends FeatureSet {
    private StringFeature commitScriptFeature = CommitMethodFeature.create();
    private StringFeature prepareScriptFeature = PrepareMethodFeature.create();
    private StringFeature serverConfigurationFeature = StringFeature.create("serverConfiguration", ProjectModelMsg.CONFIGURATION, null, null);

    private ExternalTaskFeature(String featureName, Msg label, Msg description) {
        super(featureName, label, description);
        this.addFeature(this.commitScriptFeature);
        this.addFeature(this.prepareScriptFeature);
        this.addFeature(this.serverConfigurationFeature);
    }

    public static ExternalTaskFeature create() {
        return new ExternalTaskFeature("externalTask", null, null);
    }

    public StringFeature getCommitScriptFeature() {
        return this.commitScriptFeature;
    }

    public StringFeature getPrepareScriptFeature() {
        return this.prepareScriptFeature;
    }

    public StringFeature getServerConfigurationFeature() {
        return this.serverConfigurationFeature;
    }

    public static class ServerConfigurationFeature
    extends StringFeature {
        protected ServerConfigurationFeature() {
            super("serverConfiguration", ProjectModelMsg.CONFIGURATION, null, null);
        }

        public static ServerConfigurationFeature create() {
            return new ServerConfigurationFeature();
        }
    }

    public static class PrepareMethodFeature
    extends StringFeature {
        protected PrepareMethodFeature() {
            super("prepareScript", ProjectModelMsg.PREPARE_METHOD, null, null);
        }

        public static PrepareMethodFeature create() {
            return new PrepareMethodFeature();
        }
    }

    public static class CommitMethodFeature
    extends StringFeature {
        protected CommitMethodFeature() {
            super("commitScript", ProjectModelMsg.COMMIT_METHOD, null, null);
        }

        public static CommitMethodFeature create() {
            return new CommitMethodFeature();
        }
    }
}

