/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.features;

import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.FeatureSet;
import oracle.bpm.project.model.features.IntFeature;
import oracle.bpm.project.model.features.StringFeature;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.resources.Msg;

public class ExceptionTransitionFeature
extends FeatureSet {
    private ExceptionName exceptionName;
    private ExceptionNamespace exceptionNamespace = ExceptionNamespace.create();
    private ExceptionOrder exceptionOrder;
    private ExceptionSignature exceptionSignature;
    private ExceptionType exceptionType;
    private VariableName variableName;
    public static String DEFAULT_EXCEPTION = "Others";
    public static String INSTANCE_EXPIRATION = "InstanceExpiration";

    private ExceptionTransitionFeature(String featureName, Msg label, Msg description) {
        super(featureName, label, description);
        this.addFeature(this.exceptionNamespace);
        this.exceptionName = ExceptionName.create();
        this.addFeature(this.exceptionName);
        this.variableName = VariableName.create();
        this.addFeature(this.variableName);
        this.exceptionOrder = ExceptionOrder.create();
        this.addFeature(this.exceptionOrder);
        this.exceptionSignature = ExceptionSignature.create();
        this.addFeature(this.exceptionSignature);
        this.exceptionType = ExceptionType.create();
        this.addFeature(this.exceptionType);
    }

    public static String getExceptionHolderName(Process content) {
        String varName = "exceptionHolder";
        String vName = "exceptionHolder";
        int i = 1;
        DataObject variable = content.findDataObject(vName);
        while (variable != null && variable.getType().getKind() != 10) {
            vName = "exceptionHolder" + i++;
            variable = content.findDataObject(vName);
        }
        return vName;
    }

    public static void createIfNotExist(Process content, String varName) throws ProjectException {
        DataObject variable = content.findDataObject(varName);
        if (variable == null) {
            DataObject dataObject = content.createDataObject(varName, CatalogType.Default.getAny());
            content.addDataObject(dataObject);
        }
    }

    public static ExceptionTransitionFeature create() {
        return new ExceptionTransitionFeature("exceptionFeature", null, null);
    }

    public boolean handlesInstanceExpiration() {
        String exception = this.getExceptionName().getValue();
        return exception != null && exception.equals(INSTANCE_EXPIRATION);
    }

    public boolean handlesOthers() {
        String exception = this.getExceptionName().getValue();
        return exception != null && exception.equals(DEFAULT_EXCEPTION);
    }

    public ExceptionSignature getExceptionSignature() {
        return this.exceptionSignature;
    }

    public ExceptionType getExceptionType() {
        return this.exceptionType;
    }

    public ExceptionNamespace getExceptionNamespace() {
        return this.exceptionNamespace;
    }

    public ExceptionName getExceptionName() {
        return this.exceptionName;
    }

    public VariableName getVariableName() {
        return this.variableName;
    }

    public ExceptionOrder getExceptionOrder() {
        return this.exceptionOrder;
    }

    public static class VariableName
    extends StringFeature {
        private VariableName(String featureName, Msg label, Msg description, String value) {
            super(featureName, label, description, value);
        }

        public static VariableName create() {
            return new VariableName("exceptionCauseHolderVariableName", ProjectModelMsg.EXCEPTION_HOLDER, ProjectModelMsg.EXCEPTION_HOLDER_DSC, null);
        }
    }

    public static class ExceptionType
    extends StringFeature {
        private ExceptionType(String featureName, Msg label, Msg description, String value) {
            super(featureName, label, description, value);
        }

        public static ExceptionType create() {
            return new ExceptionType("exceptionType", null, null, null);
        }

        @Override
        public boolean isPublic() {
            return false;
        }
    }

    public static class ExceptionSignature
    extends StringFeature {
        private ExceptionSignature(String featureName, Msg label, Msg description, String value) {
            super(featureName, label, description, value);
        }

        public static ExceptionSignature create() {
            return new ExceptionSignature("exceptionSignature", null, null, null);
        }

        @Override
        public boolean isPublic() {
            return false;
        }
    }

    public static class ExceptionOrder
    extends IntFeature {
        private ExceptionOrder(String featureName, Msg label, Msg description, int value) {
            super(featureName, label, description, value);
        }

        public static ExceptionOrder create() {
            return new ExceptionOrder("exceptionOrder", null, null, 0);
        }

        @Override
        public boolean isPublic() {
            return false;
        }
    }

    public static class ExceptionNamespace
    extends StringFeature {
        private ExceptionNamespace(String featureName, Msg label, Msg description, String value) {
            super(featureName, label, description, value);
        }

        public static ExceptionNamespace create() {
            return new ExceptionNamespace("exceptionNamespace", null, null, null);
        }

        @Override
        public boolean isPublic() {
            return false;
        }
    }

    public static class ExceptionName
    extends StringFeature {
        private ExceptionName(String featureName, Msg label, Msg description, String value) {
            super(featureName, label, description, value);
        }

        public static ExceptionName create() {
            return new ExceptionName("exception", ProjectModelMsg.EXCEPTION_NAME, ProjectModelMsg.EXCEPTION_NAME_DSC, null);
        }
    }
}

