/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.features;

import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.features.BooleanFeature;
import oracle.bpm.project.model.features.FeatureSet;
import oracle.bpm.project.model.features.ParticipantFeature;
import oracle.bpm.project.model.features.ProcessCommunicationFeature;
import oracle.bpm.project.model.features.StringFeature;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NonNls;

public class ConversationFeature
extends FeatureSet {
    private DefinedOperationNameFeature definedOperationName;
    private InitiatorFeature initiatior = InitiatorFeature.create();
    private SyncFeature isSync = SyncFeature.create();

    private ConversationFeature(String featureName, Project project) {
        super(featureName, null, null);
        this.definedOperationName = DefinedOperationNameFeature.create();
        this.addFeature(ProcessCommunicationFeature.create());
        this.addFeature(ParticipantFeature.create(project));
        this.addFeature(this.initiatior);
        this.addFeature(this.isSync);
        this.addFeature(this.definedOperationName);
    }

    public static ConversationFeature create(Project project) {
        return new ConversationFeature("conversation", project);
    }

    public String getInitiatiorId() {
        return this.initiatior.getValue();
    }

    public void setInitiatiorId(String initiatiorId) {
        this.initiatior.setValue(initiatiorId);
    }

    public boolean isSync() {
        return this.isSync.getValue();
    }

    public void setSync(boolean sync) {
        this.isSync.setValue(sync);
    }

    public String getDefinedOperationName() {
        return this.definedOperationName.getValue();
    }

    public void setDefinedOperationName(String definedOperationName) {
        this.definedOperationName.setValue(definedOperationName);
    }

    private static class SyncFeature
    extends BooleanFeature {
        protected SyncFeature(@NonNls String featureName, Msg label, Msg description, boolean value) {
            super(featureName, label, description, value);
        }

        public static SyncFeature create() {
            return new SyncFeature("sync", null, null, false);
        }
    }

    private static class InitiatorFeature
    extends StringFeature {
        protected InitiatorFeature(@NonNls String featureName, Msg label, Msg description, String value) {
            super(featureName, label, description, value);
        }

        public static InitiatorFeature create() {
            return new InitiatorFeature("initiator", null, null, "");
        }
    }

    private static class DefinedOperationNameFeature
    extends StringFeature {
        protected DefinedOperationNameFeature(@NonNls String featureName, Msg label, Msg description, String value) {
            super(featureName, label, description, value);
        }

        public static DefinedOperationNameFeature create() {
            return new DefinedOperationNameFeature("definedOperationName", null, null, null);
        }
    }
}

