/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.events;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.bpm.collections.sets.IdentityHashSet;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectEvent;

public class ProjectEventSet
implements Iterable<ProjectEvent> {
    private Set<ProjectEvent> events = new LinkedHashSet<ProjectEvent>();

    public static ProjectEventSet createFrom(ProjectEvent<ProjectObject> event) {
        ProjectEventSet set = new ProjectEventSet();
        set.add(event);
        return set;
    }

    @Override
    public Iterator<ProjectEvent> iterator() {
        return this.events.iterator();
    }

    public void add(ProjectEvent event) {
        this.events.add(event);
    }

    public void addAll(Iterable<ProjectEvent> iterable) {
        for (ProjectEvent event : iterable) {
            this.add(event);
        }
    }

    public void remove(ProjectEvent event) {
        this.events.remove(event);
    }

    public void makeInmutable() {
        this.events = Collections.unmodifiableSet(this.events);
    }

    public void clear() {
        this.events.clear();
    }

    public int size() {
        return this.events.size();
    }

    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    public void trim() {
        IdentityHashSet removed = new IdentityHashSet();
        for (ProjectEvent event : this.events) {
            if (event.getType() != ProjectEvent.Type.POST_REMOVE) continue;
            removed.add(event.getProjectObject());
        }
        Iterator<ProjectEvent> it = this.events.iterator();
        while (it.hasNext()) {
            ProjectEvent event;
            event = it.next();
            if (event.getType() != ProjectEvent.Type.CHANGE || !removed.contains(event.getProjectObject())) continue;
            it.remove();
        }
    }

    public String toString() {
        return "ProjectEventSet(" + this.events + ")";
    }

    public boolean containsEventType(ProjectEvent.Type type) {
        for (ProjectEvent event : this.events) {
            if (event.getType() != type) continue;
            return true;
        }
        return false;
    }
}

