/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.SequenceBuilder;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Line;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.QuadCurve;
import oracle.bpm.lang.Ref;
import oracle.bpm.project.changeset.ModelChangeSet;
import oracle.bpm.project.model.algorithms.LayoutAlgorithm;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.TransitionType;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChineseLayoutAlgorithm
implements LayoutAlgorithm {
    @NotNull
    private final Map<FlowNode, Node> activities;
    @NotNull
    private final Map<SequenceFlow, Arc> arcs;
    @NotNull
    private final Node begin;
    @NotNull
    private final NodeContainer container;
    @NotNull
    private CoordMap coords;
    @NotNull
    private final Node end;
    @NotNull
    private final HashMap<Role, LaneInfo> lanes;
    @NotNull
    private final Ref<Point> relativeLocation;
    private static final Comparator<FlowNode> ACTIVITIES_BY_ID = new Comparator<FlowNode>(){

        @Override
        public int compare(FlowNode o1, FlowNode o2) {
            return o1.getId().compareTo(o2.getId());
        }
    };
    private static final int MIN_Y_SPACE = 10;
    private static final int MIN_X_SPACE = 10;
    private static final int X_BASE = 100;
    private static final int X_SUBPROCESS_BASE = 30;
    private static final int Y_BASE = 80;
    private static final int Y_SUBPROCESS_BASE = 22;
    private static final int X_SPACE = 120;
    private static final int X_SUBPROCESS_SPACE = 80;
    private static final int Y_SPACE = 120;
    private static final int Y_SUBPROCESS_SPACE = 80;
    private static final int WBYCHAR = 8;
    private static final Comparator<Node> DISTANCE_COMPARATOR = new Comparator<Node>(){

        @Override
        public int compare(Node a, Node b) {
            return a.getDistance() - b.getDistance();
        }
    };
    private static final Comparator<Node> ORDER_OFFSET_COMPARATOR = new Comparator<Node>(){

        @Override
        public int compare(Node a, Node b) {
            int result = a.getOrder() - b.getOrder();
            if (result == 0 && (result = a.getOffset() - b.getOffset()) == 0) {
                result = a.getDistance() - b.getDistance();
            }
            return result;
        }
    };
    private static final List<Node> NO_ARCS = Collections.emptyList();

    public ChineseLayoutAlgorithm(@NotNull NodeContainer container, int gridSize) {
        this.container = container;
        this.relativeLocation = Ref.createRef((Object)Point.ORIGIN);
        this.coords = container instanceof Subprocess ? new CoordMap(30, 80, 22, 80, gridSize) : new CoordMap(100, 120, 80, 120, gridSize);
        this.lanes = new HashMap();
        this.activities = ChineseLayoutAlgorithm.createNodes(container);
        this.arcs = ChineseLayoutAlgorithm.createArcs(container, this.activities);
        this.begin = ChineseLayoutAlgorithm.findNode(this.activities, ModelUtils.getStartFlowNode(this.container));
        this.end = ChineseLayoutAlgorithm.findNode(this.activities, ModelUtils.getAnyEndEvent(this.container));
    }

    public static void layoutModel(@NotNull NodeContainer container, int gridSize) throws ProjectException {
        ChineseLayoutAlgorithm algorithm = new ChineseLayoutAlgorithm(container, gridSize);
        ModelChangeSet changeSet = algorithm.calculateChanges();
        changeSet.apply(container.getProcess());
    }

    @Override
    public ModelChangeSet calculateChanges() throws ProjectException {
        this.createDirectionalGraph();
        this.createInnerChangeSets();
        int maxX = this.calculateDistances();
        this.createLanes();
        this.assignLanes();
        int maxY = this.calculateOffset();
        maxX = this.placeOutOfFlowActivities(maxX);
        this.coords.allocate(maxX, maxY);
        this.assignY();
        this.adjustSizesOnX();
        this.adjustSizesOnY();
        this.avoidHorizontalTransitionOverlap();
        this.fitRoleLabels();
        this.calculateLocations();
        this.avoidTransitionOverlap();
        return this.createChangeSet();
    }

    @NotNull
    private static Map<FlowNode, Node> createNodes(@NotNull NodeContainer container) {
        TreeMap<FlowNode, Node> map = new TreeMap<FlowNode, Node>(ACTIVITIES_BY_ID);
        for (FlowNode node : container.getFlowNodes()) {
            map.put(node, new Node(node));
        }
        return map;
    }

    private static Map<SequenceFlow, Arc> createArcs(@NotNull NodeContainer container, @NotNull Map<FlowNode, Node> activities) {
        HashMap<SequenceFlow, Arc> result = new HashMap<SequenceFlow, Arc>();
        int id = 0;
        for (SequenceFlow flow : container.getSequenceFlows()) {
            Node from = ChineseLayoutAlgorithm.findNode(activities, ChineseLayoutAlgorithm.getSequenceFlowSource(flow));
            Node to = ChineseLayoutAlgorithm.findNode(activities, ChineseLayoutAlgorithm.getSequenceFlowTarget(flow));
            Arc arc = new Arc(from, to, id++);
            BoundaryEvent boundary = flow.getSource().asAnyNode(BoundaryEvent.class);
            arc.boundary = boundary;
            result.put(flow, arc);
        }
        return result;
    }

    @NotNull
    private static Node findNode(Map<FlowNode, Node> activities, @NotNull FlowNode node) {
        Node result = activities.get(node);
        if (result == null) {
            throw new IllegalStateException("Activity: " + node.getId() + " has not associated node.");
        }
        return result;
    }

    private static int shiftOffset(int offset) {
        return 2 * offset + 1;
    }

    private static int controlPointOffset(Point p1, Point p2) {
        return (int)(24.0 + p1.distance(p2) / 8.0);
    }

    private static FlowNode getSequenceFlowTarget(@NotNull SequenceFlow flow) {
        return flow.getTarget();
    }

    private static FlowNode getSequenceFlowSource(@NotNull SequenceFlow flow) {
        BoundaryEvent boundary = flow.getSource().asAnyNode(BoundaryEvent.class);
        return boundary != null ? boundary.getBoundaryActivity() : flow.getSource();
    }

    private void adjustSizesOnX() {
        Node[][] nodes = this.createNodeMatrix();
        for (int column = 0; column < nodes.length; ++column) {
            int maxwidth = this.calculateMaxWidth(nodes, column);
            this.coords.adjustSizesOnX(column, maxwidth);
        }
    }

    private void adjustSizesOnY() {
        Node[][] nodes = this.createNodeMatrix();
        for (int row = 1; row < nodes[0].length - 1; ++row) {
            int maxHeight = this.calculateMaxHeight(nodes, row);
            this.coords.adjustSizesOnY(row, maxHeight);
        }
    }

    @NotNull
    private Node[][] createNodeMatrix() {
        Node[][] nodes = new Node[this.coords.getXSize()][this.coords.getYSize()];
        Iterator<Node> i$ = this.allNodes().iterator();
        while (i$.hasNext()) {
            Node node;
            nodes[((Node)node).getDistance()][((Node)node).getOffset()] = node = i$.next();
        }
        return nodes;
    }

    private int calculateMaxWidth(@NotNull Node[][] nodes, int column) {
        int result = 0;
        for (int y = 0; y < nodes[column].length; ++y) {
            Node node = nodes[column][y];
            if (node == null || column != 0 && nodes[column - 1][y] == null && (column + 1 >= nodes.length || nodes[column + 1][y] == null)) continue;
            result = Math.max(result, node.getFlowNode().getDefaultLabel().length() * 8);
            result = Math.max(result, node.width);
        }
        return result;
    }

    private int calculateMaxHeight(@NotNull Node[][] nodes, int row) {
        int result = 0;
        for (Node[] nodeColumn : nodes) {
            Node node = nodeColumn[row];
            if (node == null) continue;
            result = Math.max(result, node.height);
        }
        return result;
    }

    @NotNull
    private Collection<Node> allNodes() {
        return this.activities.values();
    }

    private int calculateDistances() {
        int max = this.calculateMainFlowDistances();
        max = this.calculateAuxFlowsDistances(max);
        this.calculateOutOfFlowDistances(max + 1);
        return this.adjustDistances();
    }

    private int calculateMainFlowDistances() {
        int max = this.begin.calculateDistanceFrom(0);
        this.end.calculateDistanceTo(0);
        for (Node node : this.allNodes()) {
            node.centerDistance(this.begin.distanceToEnd);
        }
        this.begin.avoidZigZags(null);
        return max * 2;
    }

    private int calculateAuxFlowsDistances(int max) {
        int distanceToEnd = this.end.getDistance();
        for (Node node : this.allNodes()) {
            if (node == this.begin || !node.isStartFlow()) continue;
            max = node.calculateDistanceFrom(max + 1);
        }
        this.end.setDistance(distanceToEnd);
        return max;
    }

    private void calculateOutOfFlowDistances(int distance) {
        for (Node node : this.allNodes()) {
            if (!node.isOutOfFlow()) continue;
            node.distance = distance;
        }
    }

    private int adjustDistances() {
        int distance = Integer.MIN_VALUE;
        int correlative = -1;
        for (Node node : CollectionUtils.sort(this.allNodes(), DISTANCE_COMPARATOR)) {
            if (node.getDistance() > distance) {
                distance = node.getDistance();
                ++correlative;
            }
            node.setDistance(correlative);
        }
        return correlative;
    }

    private void createDirectionalGraph() {
        for (Node node : this.allNodes()) {
            if (!node.isStartFlow()) continue;
            this.createDirectionalGraph(node, true, new HashSet<Node>());
        }
        this.createDirectionalGraph(this.end, false, new HashSet<Node>());
    }

    private void createDirectionalGraph(@NotNull Node node, boolean fwd, @NotNull Set<Node> nodeSet) {
        nodeSet.add(node);
        for (Node n : this.createArcs(node, fwd, nodeSet)) {
            this.createDirectionalGraph(n, fwd, nodeSet);
        }
        nodeSet.remove(node);
    }

    @NotNull
    private List<Node> createArcs(@NotNull Node node, boolean fwd, @NotNull Set<Node> nodeSet) {
        ArrayList<Node> result;
        List<Node> list = result = fwd ? node.targetNodes : node.sourceNodes;
        if (result == NO_ARCS) {
            result = new ArrayList<Node>();
            for (SequenceFlow flow : node.findTransitions(fwd)) {
                FlowNode a = fwd ? ChineseLayoutAlgorithm.getSequenceFlowTarget(flow) : ChineseLayoutAlgorithm.getSequenceFlowSource(flow);
                this.addArc(a, nodeSet, result);
            }
            node.setArcs(fwd, result);
        }
        return result;
    }

    private void addArc(FlowNode a, Set<Node> nodeSet, List<Node> result) {
        Node n = ChineseLayoutAlgorithm.findNode(this.activities, a);
        if (!nodeSet.contains(n) && !result.contains(n)) {
            result.add(n);
        }
    }

    private void createLanes() {
        for (Node node : this.allNodes()) {
            if (!node.hasLane()) continue;
            LaneInfo lane = node.laneInfo;
            if (lane == null) {
                lane = this.createLane(node);
            }
            if (lane.getOrder() <= node.getDistance()) continue;
            lane.setOrder(node.getDistance());
        }
        this.makeOrderUnique();
    }

    private void makeOrderUnique() {
        int order = 0;
        for (LaneInfo lane : CollectionUtils.sort(this.lanes.values(), (Comparator)LaneInfo.ORDER_ID_COMPARATOR)) {
            lane.setOrder(order++);
        }
    }

    @NotNull
    private LaneInfo createLane(@NotNull Node node) {
        Lane lane = node.getFlowNode().getLane();
        LaneInfo laneInfo = this.lanes.get(lane.getRole());
        if (laneInfo == null) {
            laneInfo = new LaneInfo(lane);
            this.lanes.put(lane.getRole(), laneInfo);
        }
        node.setLaneInfo(laneInfo);
        return laneInfo;
    }

    private void assignLanes() {
        if (this.lanes.isEmpty()) {
            this.assignBlankLane();
        } else {
            this.sortConnections();
            for (Node node : this.allNodes()) {
                if (!node.isStartFlow()) continue;
                node.assignLanes();
            }
            this.assignDefaultLane();
            this.assignFirstLaneToBegin();
            this.sortConnections();
        }
    }

    private void assignDefaultLane() {
        LaneInfo defaultLane;
        LaneInfo laneInfo = defaultLane = this.end.hasLaneInfo() ? this.end.getLaneInfo() : (LaneInfo)CollectionUtils.first(this.lanes.values());
        if (defaultLane != null) {
            for (Node node : this.allNodes()) {
                if (node.hasLaneInfo()) continue;
                node.setLaneInfo(defaultLane);
            }
        }
    }

    private void assignFirstLaneToBegin() {
        LaneInfo beginLane = this.begin.getLaneInfo();
        if (beginLane.getOrder() != 0) {
            for (LaneInfo lane : this.lanes.values()) {
                if (lane.getOrder() != 0) continue;
                lane.setOrder(beginLane.getOrder());
                beginLane.setOrder(0);
                break;
            }
        }
    }

    private void assignBlankLane() {
        Lane automaticLane = ModelUtils.findOrCreateAutomaticLane(this.container.getProcess());
        LaneInfo laneInfo = new LaneInfo(automaticLane);
        this.lanes.put(automaticLane.getRole(), laneInfo);
        for (Node node : this.allNodes()) {
            node.setLaneInfo(laneInfo);
        }
    }

    private void sortConnections() {
        for (Node node : this.allNodes()) {
            node.sortByOrder();
        }
    }

    private int calculateOffset() {
        this.begin.calculateOffset(0);
        for (Node node : this.allNodes()) {
            if (node == this.begin || !node.isStartFlow()) continue;
            node.calculateOffset(0);
        }
        this.avoidActivityOverlap();
        int maxY = this.adjustOffsets();
        for (Node node : this.allNodes()) {
            node.getLaneInfo().updateOffset(node.getOffset());
        }
        return maxY;
    }

    private int adjustOffsets() {
        int order = Integer.MIN_VALUE;
        int offset = Integer.MIN_VALUE;
        int correlative = -1;
        for (Node node : CollectionUtils.sort(this.allNodes(), ORDER_OFFSET_COMPARATOR)) {
            if (node.getOrder() != order || node.getOffset() != offset) {
                offset = node.getOffset();
                order = node.getOrder();
                ++correlative;
            }
            node.setOffset(correlative);
        }
        return correlative;
    }

    private void avoidActivityOverlap() {
        HashMap<String, Node> activitiesByCoords = new HashMap<String, Node>();
        for (Node node : this.allNodes()) {
            if (node.isOutOfFlow()) continue;
            int offset = node.getOffset();
            String key = node.getDistance() + "," + node.getOrder() + "," + offset;
            while (activitiesByCoords.get(key) != null) {
                key = node.getDistance() + "," + node.getOrder() + "," + ++offset;
            }
            activitiesByCoords.put(key, node);
            node.setOffset(offset);
        }
    }

    private int placeOutOfFlowActivities(int maxX) {
        HashMap<Point, Node> activitiesByCoords = new HashMap<Point, Node>();
        for (Node node : this.allNodes()) {
            if (!node.isOutOfFlow()) continue;
            LaneInfo lane = node.getLaneInfo();
            int offset = node.getOffset();
            int distance = node.getDistance();
            while (activitiesByCoords.get(new Point(distance, offset)) != null) {
                if (++offset <= lane.getMaxOffset()) continue;
                offset = lane.getMinOffset();
                ++distance;
            }
            maxX = Math.max(maxX, distance);
            activitiesByCoords.put(new Point(distance, offset), node);
            node.setOffset(offset);
            node.setDistance(distance);
        }
        return maxX;
    }

    private void avoidHorizontalTransitionOverlap() {
        ArrayList<Arc> horizontal = new ArrayList<Arc>();
        for (Arc arc : this.arcs.values()) {
            if (arc.getSlope() != 0.0) continue;
            horizontal.add(arc);
        }
        this.curveToAvoidOperlaps(horizontal);
        this.adjustYCoordinateForCurvedTransitions();
    }

    private void adjustYCoordinateForCurvedTransitions() {
        for (Arc arc : this.arcs.values()) {
            if (!arc.isCurve()) continue;
            Point p1 = this.coords.calculateLocation(arc.getFrom().getDistance(), 0);
            Point p2 = this.coords.calculateLocation(arc.getTo().getDistance(), 0);
            int d = ChineseLayoutAlgorithm.controlPointOffset(p1, p2);
            this.coords.adjustSizesOnY(arc.getFrom().getOffset(), arc.isForward(), d);
        }
    }

    private void avoidTransitionOverlap() {
        ArrayList<Arc> transitions = new ArrayList<Arc>();
        for (Arc arc : this.arcs.values()) {
            arc.calculateSlope();
            if (arc.getSlope() == 0.0) continue;
            transitions.add(arc);
        }
        this.curveToAvoidOperlaps(transitions);
    }

    private void fitRoleLabels() {
        for (LaneInfo lane : this.lanesByOffset()) {
            lane.fitLabel(this.coords);
        }
    }

    private void curveToAvoidOperlaps(@NotNull List<Arc> arcSet) {
        SortedSet<Arc> overlaps;
        while ((overlaps = this.findOverlaps(arcSet)) != null) {
            Arc curve = this.findLongest(overlaps);
            arcSet.remove(curve);
            curve.setCurve(true);
        }
    }

    @NotNull
    private Arc findLongest(@NotNull SortedSet<Arc> transitions) {
        Arc longest = transitions.first();
        double max = 0.0;
        for (Arc arc : transitions) {
            double length = arc.calculateLength();
            if (!(length >= max)) continue;
            max = length;
            longest = arc;
        }
        return longest;
    }

    @Nullable
    private SortedSet<Arc> findOverlaps(List<Arc> arcSet) {
        for (int i = 0; i < arcSet.size(); ++i) {
            Arc arc1 = arcSet.get(i);
            TreeSet<Arc> result = new TreeSet<Arc>(Arc.ARC_BY_DIRECTION);
            for (int j = i + 1; j < arcSet.size(); ++j) {
                Arc arc2 = arcSet.get(j);
                if (!arc1.overlaps(arc2)) continue;
                result.add(arc2);
            }
            if (result.isEmpty()) continue;
            result.add(arc1);
            return result;
        }
        return null;
    }

    private void assignY() {
        for (Node n : this.allNodes()) {
            n.setOffset(ChineseLayoutAlgorithm.shiftOffset(n.getOffset()));
        }
        for (LaneInfo laneInfo : this.lanesByOffset()) {
            laneInfo.updateSize(this.coords);
        }
    }

    private List<LaneInfo> lanesByOffset() {
        return CollectionUtils.sort(this.lanes.values(), (Comparator)LaneInfo.OFFSET_COMPARATOR);
    }

    private void calculateLocations() {
        for (Node node : this.allNodes()) {
            node.calculateLocation(this.coords);
        }
        for (LaneInfo laneInfo : this.lanes.values()) {
            laneInfo.calculateLocation(this.coords);
        }
    }

    private ModelChangeSet createChangeSet() throws ProjectException {
        ModelChangeSet changeSet = new ModelChangeSet(this.relativeLocation);
        for (Node node : this.allNodes()) {
            if (!node.isSubprocess) {
                changeSet.addChangeActivity(node.getFlowNode(), node.getLaneInfo().getLane(), node.getLocation());
                continue;
            }
            changeSet.addChangeSubprocess(node.getFlowNode().asAnyNode(Subprocess.class), node.getLocation(), node.getSize(), node.getInnerChangeSet());
        }
        for (BoundaryEvent boundary : this.container.getBoundaryEvents()) {
            Activity activity = boundary.getBoundaryActivity();
            Point delta = boundary.getLocation().sub(activity.getLocation());
            Node owner = ChineseLayoutAlgorithm.findNode(this.activities, activity);
            changeSet.addChangeActivity(boundary, owner.getLaneInfo().getLane(), owner.location.add(delta));
        }
        for (SequenceFlow transition : this.container.getSequenceFlows()) {
            Arc arc = this.arcs.get(transition);
            changeSet.addChangeTransition(transition, arc.calculateControlPoint());
        }
        if (this.container instanceof Process) {
            Process process = (Process)this.container;
            for (Lane lane : process.getLanes()) {
                LaneInfo li = this.lanes.get(lane.getRole());
                if (li != null && li.getLane() == lane) continue;
                changeSet.addRemoveLane(lane);
            }
            for (LaneInfo l : this.lanes.values()) {
                l.updateLane(changeSet);
            }
        }
        return changeSet;
    }

    private void createInnerChangeSets() throws ProjectException {
        for (Node node : this.allNodes()) {
            if (!node.isSubprocess) continue;
            Subprocess subprocess = node.getFlowNode().asAnyNode(Subprocess.class);
            ChineseLayoutAlgorithm algorithm = new ChineseLayoutAlgorithm(subprocess, this.coords.gridSize);
            node.changes = algorithm.calculateChanges();
            CoordMap coordMap = algorithm.coords;
            node.width = coordMap.getX(coordMap.getXSize() - 1) + coordMap.xSpace / 2;
            node.height = coordMap.getY(coordMap.getYSize() - 1);
        }
    }

    private static class Node {
        private ModelChangeSet changes;
        private int distance;
        private int distanceToEnd;
        private int height;
        private boolean isConnector;
        private boolean isSubprocess;
        @Nullable
        private LaneInfo laneInfo;
        @Nullable
        private Point location;
        @NotNull
        private final FlowNode node;
        private int offset;
        private final boolean outOfFlow;
        private final boolean startFlow;
        @NotNull
        private List<Node> sourceNodes;
        @NotNull
        private List<Node> targetNodes;
        private int width;
        private static final int EMPTY = -1;
        private static final Comparator<Node> ORDER_COMPARATOR = new Comparator<Node>(){

            @Override
            public int compare(Node a, Node b) {
                return a.getOrder() - b.getOrder();
            }
        };
        private static final Comparator<SequenceFlow> TRANSITION_COMPARATOR = new Comparator<SequenceFlow>(){

            @Override
            public int compare(SequenceFlow o1, SequenceFlow o2) {
                boolean c2;
                boolean c1 = ModelUtils.isConnector(o1.getTarget());
                if (c1 == (c2 = ModelUtils.isConnector(o2.getTarget()))) {
                    return o1.isNormalFlow() ? -1 : 1;
                }
                return c1 ? -1 : 1;
            }
        };
        private static final EnumMap<TransitionType, Integer> tWeight = new EnumMap(TransitionType.class);

        private Node(@NotNull FlowNode node) {
            this.node = node;
            this.targetNodes = this.sourceNodes = NO_ARCS;
            this.isConnector = ModelUtils.isConnector(node);
            this.isSubprocess = ModelUtils.isSubprocess(node);
            boolean noIncoming = node.getIncomingSequenceFlows().isEmpty();
            boolean notOutgoing = node.getOutgoingSequenceFlows().isEmpty();
            this.outOfFlow = noIncoming && notOutgoing;
            this.startFlow = noIncoming && !notOutgoing;
            this.width = node.getWidth();
            this.height = node.getHeight();
            this.distance = -1;
            this.distanceToEnd = -1;
            this.offset = this.outOfFlow ? 0 : -1;
        }

        public String toString() {
            String id = this.node.getId();
            return this.isConnector ? " --> " + id : id;
        }

        public boolean isCreation() {
            return false;
        }

        public boolean isConditional() {
            return this.node.getBpmnType() == BpmnType.EXCLUSIVE_GATEWAY;
        }

        public boolean isConnector() {
            return this.isConnector;
        }

        @NotNull
        Set<LaneInfo> findGroupLanes() {
            Set<LaneInfo> result = this.hasLane() ? Collections.singleton(this.getLaneInfo()) : Collections.emptySet();
            return result;
        }

        @NotNull
        private Point getLocation() {
            if (this.location == null) {
                throw new IllegalStateException("'getLocation' invoked before 'calculateLocation' for: " + this);
            }
            return this.location;
        }

        @NotNull
        private Dimension getSize() {
            return Dimension.valueOf((int)this.width, (int)this.height);
        }

        @NotNull
        private ModelChangeSet getInnerChangeSet() {
            if (this.changes == null) {
                throw new IllegalStateException("'getInnerChangeSet' invoked, but changes where not initialized for: " + this);
            }
            return this.changes;
        }

        private int getDistance() {
            return this.distance;
        }

        private void setDistance(int value) {
            this.distance = value;
        }

        private boolean isStartFlow() {
            return this.startFlow;
        }

        private boolean isOutOfFlow() {
            return this.outOfFlow;
        }

        private int getOffset() {
            return this.offset;
        }

        private void setOffset(int offset) {
            this.offset = offset;
        }

        private boolean hasOffset() {
            return this.offset != -1;
        }

        @NotNull
        private List<Node> getTargetNodes() {
            return this.targetNodes;
        }

        private boolean hasLane() {
            return ModelUtils.hasLane(this.node);
        }

        @NotNull
        private LaneInfo getLaneInfo() {
            if (this.laneInfo == null) {
                throw new IllegalStateException("Not lane for Activity: " + this.node);
            }
            return this.laneInfo;
        }

        private boolean hasLaneInfo() {
            return this.laneInfo != null;
        }

        private int getOrder() {
            return this.laneInfo == null ? 0 : this.laneInfo.getOrder();
        }

        private void setLaneInfo(@NotNull LaneInfo laneInfo) {
            this.laneInfo = laneInfo;
        }

        @NotNull
        private FlowNode getFlowNode() {
            return this.node;
        }

        @NotNull
        private Iterable<SequenceFlow> findTransitions(boolean fwd) {
            SequenceBuilder flows = SequenceBuilder.create();
            flows.append(fwd ? this.node.getOutgoingSequenceFlows() : this.node.getIncomingSequenceFlows());
            if (fwd && this.node.isActivity()) {
                for (BoundaryEvent boundary : ModelUtils.getBoundaryEventsFor(this.node.asAnyNode(Activity.class))) {
                    flows.append(boundary.getOutgoingSequenceFlows());
                }
            }
            return CollectionUtils.sort((Sequence)flows.build(), TRANSITION_COMPARATOR);
        }

        private void setArcs(boolean fwd, @NotNull List<Node> result) {
            if (fwd) {
                this.targetNodes = result;
            } else {
                this.sourceNodes = result;
            }
        }

        private void sortByOrder() {
            Collections.sort(this.getTargetNodes(), ORDER_COMPARATOR);
        }

        private int calculateOffset(int currentOffset) {
            this.checkConnectorOffset(currentOffset);
            int base = currentOffset;
            int first = -1;
            LaneInfo prev = null;
            for (Node n : this.getTargetNodes()) {
                if (n.hasOffset()) continue;
                if (n.getLaneInfo() == prev) {
                    ++currentOffset;
                } else if (prev != null) {
                    currentOffset = 0;
                }
                currentOffset = n.calculateOffset(currentOffset);
                if (first == -1 && n.getLaneInfo() == this.laneInfo) {
                    first = n.getOffset();
                }
                prev = n.getLaneInfo();
            }
            this.calculateCurrentNodeOffset(base, currentOffset, first);
            return this.getOffset();
        }

        private void calculateCurrentNodeOffset(int base, int last, int first) {
            if (first == -1) {
                this.setOffset(base);
            } else {
                this.setOffset(first);
                this.checkConnectorOffset(first);
            }
        }

        private void checkConnectorOffset(int currentOffset) {
            List<Node> t = this.getTargetNodes();
            if (t.size() > 1 && t.get(0).isConnector() && !t.get(1).isConnector()) {
                Node c = t.get(0);
                c.setOffset(currentOffset + 1);
                c.setDistance(this.getDistance());
            }
        }

        @Nullable
        private LaneInfo assignLanes(@Nullable LaneInfo prevLane) {
            LaneInfo currentLane = this.laneInfo;
            if (currentLane == null && prevLane != null) {
                currentLane = prevLane;
                this.setLaneInfo(prevLane);
            }
            for (Node n : this.targetNodes) {
                LaneInfo nextLane = n.assignLanes(currentLane);
                if (currentLane != null || nextLane == null) continue;
                currentLane = nextLane;
                this.setLaneInfo(nextLane);
            }
            return currentLane;
        }

        private int calculateDistanceFrom(int currentDistance) {
            int maxDistance = currentDistance;
            if (this.distance < currentDistance) {
                this.distance = currentDistance;
                for (Node n : this.targetNodes) {
                    int d = n.calculateDistanceFrom(currentDistance + 1);
                    if (maxDistance >= d) continue;
                    maxDistance = d;
                }
            }
            return maxDistance;
        }

        private void calculateDistanceTo(int currentDistance) {
            if (this.distanceToEnd < currentDistance) {
                this.distanceToEnd = currentDistance;
                for (Node n : this.sourceNodes) {
                    n.calculateDistanceTo(currentDistance + 1);
                }
            }
        }

        private void avoidZigZags(@Nullable Node prevNode) {
            if (this.targetNodes.size() == 1) {
                Node nextNode = this.targetNodes.get(0);
                if (prevNode != null && this.sourceNodes.size() <= 1 && !nextNode.isConditional()) {
                    int prev = prevNode.getDistance();
                    int next = nextNode.getDistance();
                    this.distance = (next - prev) / 2 + prev;
                }
            }
            for (Node n : this.targetNodes) {
                n.avoidZigZags(this);
            }
        }

        private void assignLanes() {
            LaneInfo current = this.assignLanes(null);
            this.assignLanes(current);
        }

        private void centerDistance(int max) {
            if (this.distance != -1 && this.distanceToEnd != -1) {
                this.distance = (this.distance + max - this.distanceToEnd) / 2;
            }
        }

        private void calculateLocation(CoordMap coords) {
            this.location = coords.calculateLocation(this.distance, this.offset);
        }

        private void calculateLocation(CoordMap coords, Node bounded) {
            this.location = coords.calculateLocation(this.distance, this.offset).translate(bounded.width / 2, this.height / 2);
        }

        static {
            for (TransitionType t : TransitionType.values()) {
                tWeight.put(t, 10);
            }
            tWeight.put(TransitionType.UNCONDITIONAL, 0);
            tWeight.put(TransitionType.CONDITIONAL, 1);
            tWeight.put(TransitionType.BUSINESS_RULE, 2);
        }
    }

    private static class LaneInfo {
        @NotNull
        private final Lane lane;
        private int maxOffset;
        private int minOffset;
        private int order;
        private int width;
        private int y;
        private static final Comparator<LaneInfo> OFFSET_COMPARATOR = new Comparator<LaneInfo>(){

            @Override
            public int compare(LaneInfo a, LaneInfo b) {
                return a.minOffset - b.minOffset;
            }
        };
        private static final Comparator<LaneInfo> ORDER_ID_COMPARATOR = new Comparator<LaneInfo>(){

            @Override
            public int compare(LaneInfo a, LaneInfo b) {
                int result = a.order - b.order;
                return result != 0 ? result : a.getLane().getId().compareTo(b.getLane().getId());
            }
        };

        private LaneInfo(@NotNull Lane l) {
            this.lane = l;
            this.minOffset = Integer.MAX_VALUE;
            this.maxOffset = Integer.MIN_VALUE;
            this.order = Integer.MAX_VALUE;
        }

        public String toString() {
            return this.lane.getId();
        }

        public void calculateLocation(CoordMap coords) {
            this.y = coords.getY(this.minOffset - 1);
            this.width = coords.getY(this.maxOffset + 1) - this.y;
        }

        private int getOrder() {
            return this.order;
        }

        private void setOrder(int order) {
            this.order = order;
        }

        @NotNull
        private Lane getLane() {
            return this.lane;
        }

        private int getMaxOffset() {
            return this.maxOffset;
        }

        private int getMinOffset() {
            return this.minOffset;
        }

        private void updateOffset(int activityOffset) {
            this.minOffset = Math.min(this.minOffset, activityOffset);
            this.maxOffset = Math.max(this.maxOffset, activityOffset);
        }

        private void updateLane(@NotNull ModelChangeSet changeSet) {
            changeSet.addChangeLane(this.lane, this.y, this.width);
        }

        private void updateSize(@NotNull CoordMap coords) {
            this.minOffset = ChineseLayoutAlgorithm.shiftOffset(this.minOffset);
            this.maxOffset = ChineseLayoutAlgorithm.shiftOffset(this.maxOffset);
            coords.initializeY(this.minOffset, this.maxOffset);
        }

        private void fitLabel(CoordMap coords) {
            int w = coords.getY(this.maxOffset + 1) - coords.getY(this.minOffset - 1);
            int labelSize = this.getLane().getDefaultLabel().length() * 8;
            int diff = labelSize - w;
            if (diff > 0) {
                coords.addY(this.minOffset, diff / 2);
                coords.addY(this.maxOffset + 1, diff / 2);
            }
        }
    }

    private static class Arc {
        private BoundaryEvent boundary;
        private boolean curve;
        @NotNull
        private final Node from;
        private final int id;
        private double slope = Double.MAX_VALUE;
        @NotNull
        private final Node to;
        private static final Comparator<Arc> ARC_BY_DIRECTION = new Comparator<Arc>(){

            @Override
            public int compare(Arc a1, Arc a2) {
                boolean a1Forward = a1.isForward();
                return a1Forward == a2.isForward() ? a1.id - a2.id : (a1Forward ? -1 : 1);
            }
        };

        public Arc(@NotNull Node from, @NotNull Node to, int id) {
            this.id = id;
            this.from = from;
            this.to = to;
        }

        public String toString() {
            return this.from + " -> " + this.to;
        }

        @NotNull
        public Node getFrom() {
            return this.from;
        }

        @NotNull
        public Node getTo() {
            return this.to;
        }

        public boolean overlaps(Arc arc2) {
            boolean result = false;
            if (Math.abs(this.getSlope() - arc2.getSlope()) < 0.05) {
                Node f1 = this.getFrom();
                Node t1 = this.getTo();
                Node f2 = arc2.getFrom();
                Node t2 = arc2.getTo();
                if (this.getSlope() == 0.0) {
                    result = f1.getOffset() == f2.getOffset() && Line.segmentsOverlap((int)f1.getDistance(), (int)t1.getDistance(), (int)f2.getDistance(), (int)t2.getDistance());
                } else if (this.getSlope() == 1.5707963267948966) {
                    result = f1.getDistance() == f2.getDistance() && Line.segmentsOverlap((int)f1.getOffset(), (int)t1.getOffset(), (int)f2.getOffset(), (int)t2.getOffset());
                } else {
                    double b1;
                    double b0 = this.calculateOriginCoordinate();
                    if (Math.abs((b0 - (b1 = arc2.calculateOriginCoordinate())) / b0) < 0.05) {
                        result = Line.segmentsOverlap((int)this.getP1().getX(), (int)this.getP2().getX(), (int)arc2.getP1().getX(), (int)arc2.getP2().getX());
                    }
                }
            }
            return result;
        }

        public boolean isForward() {
            return this.to.getDistance() > this.from.getDistance() || this.to.getDistance() == this.from.getDistance() && this.to.getOffset() > this.from.getOffset();
        }

        public boolean isCurve() {
            return this.curve;
        }

        public void setCurve(boolean b) {
            this.curve = b;
        }

        private double getSlope() {
            if (this.slope == Double.MAX_VALUE) {
                this.calculateSlope();
            }
            return this.slope;
        }

        private void calculateSlope() {
            this.slope = this.getP1().slope(this.getP2());
        }

        private double calculateOriginCoordinate() {
            double x0 = this.getP1().getX();
            double x1 = this.getP2().getX();
            double y0 = this.getP1().getY();
            double y1 = this.getP2().getY();
            return x0 == x1 ? x0 : (y1 * x0 - y0 * x1) / (x0 - x1);
        }

        private Point calculateControlPoint() {
            return this.isCurve() ? QuadCurve.calculateControlPoint((Point)this.getP1(), (Point)this.getP2(), (int)ChineseLayoutAlgorithm.controlPointOffset(this.getP1(), this.getP2())) : SequenceFlow.NULL_CONTROL_POINT;
        }

        private Point getP2() {
            Node t = this.getTo();
            return t.location == null ? new Point(t.getDistance(), t.getOffset()) : t.location;
        }

        private Point getP1() {
            Node f = this.getFrom();
            return f.location == null ? new Point(f.getDistance(), f.getOffset()) : f.location;
        }

        private double calculateLength() {
            return this.getP1().distance(this.getP2());
        }
    }

    static class CoordMap {
        private int gridSize;
        private final int xBase;
        @NotNull
        private int[] xMappings;
        private final int xSpace;
        private final int yBase;
        @NotNull
        private int[] yMappings;
        private final int ySpace;

        public CoordMap(int xBase, int xSpace, int yBase, int ySpace, int gridSize) {
            this.gridSize = gridSize;
            this.xBase = this.align(xBase);
            this.yBase = this.align(yBase);
            this.xSpace = this.align(xSpace);
            this.ySpace = this.align(ySpace);
            this.xMappings = new int[0];
            this.yMappings = new int[0];
        }

        public int getY(int y) {
            return this.yMappings[y];
        }

        public int getX(int x) {
            return this.xMappings[x];
        }

        public void addX(int column, int diff) {
            diff = this.align(diff);
            int i = column;
            while (i < this.xMappings.length) {
                int n = i++;
                this.xMappings[n] = this.xMappings[n] + diff;
            }
        }

        public void addY(int row, int diff) {
            diff = this.align(diff);
            for (int i = row; i < this.yMappings.length; ++i) {
                this.yMappings[i] = this.yMappings[i] + diff;
            }
        }

        public int getXSize() {
            return this.xMappings.length;
        }

        public int getYSize() {
            return this.yMappings.length;
        }

        public void allocate(int maxX, int maxY) {
            this.xMappings = new int[maxX + 1];
            this.yMappings = new int[maxY * 2 + 3];
            int currentX = this.xBase;
            for (int i = 0; i <= maxX; ++i) {
                this.xMappings[i] = currentX;
                currentX += this.xSpace;
            }
        }

        public void initializeY(int fromY, int toY) {
            this.yMappings[fromY] = this.yMappings[fromY - 1] + this.yBase;
            int halfYSpace = this.align(this.ySpace / 2);
            for (int i = fromY + 1; i <= toY; ++i) {
                this.yMappings[i] = this.yMappings[i - 1] + halfYSpace;
            }
            this.yMappings[toY + 1] = this.yMappings[toY] + this.yBase;
        }

        private int align(int n) {
            int rest = n % this.gridSize;
            return rest == 0 ? n : n + this.gridSize - rest;
        }

        private void adjustSizesOnX(int column, int size) {
            if (size > this.xSpace) {
                this.addX(column, (size - this.xSpace + 10) / 2);
                this.addX(column + 1, (size - this.xSpace) / 2);
            }
        }

        private void adjustSizesOnY(int row, int size) {
            int space = (this.getY(row + 1) - this.getY(row - 1)) / 2;
            if (size > space) {
                this.addY(row, (size - space) / 2);
                this.addY(row + 1, (size - space) / 2);
            }
        }

        private void adjustSizesOnY(int row, boolean down, int size) {
            int baseRow = down ? row + 1 : row;
            int space = this.getY(baseRow) - this.getY(baseRow - 1);
            int diff = size - space + 10;
            if (diff > 0) {
                this.addY(baseRow, diff);
            }
        }

        private Point calculateLocation(int x, int y) {
            if (x < 0 || x >= this.xMappings.length) {
                throw new IndexOutOfBoundsException("Illegal distance: " + x);
            }
            if (y < 0 || y >= this.yMappings.length) {
                throw new IndexOutOfBoundsException("Illegal offset: " + y);
            }
            return new Point(this.xMappings[x], this.yMappings[y]);
        }
    }
}

