/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeSet;
import oracle.bpm.lang.FormatException;
import oracle.bpm.lang.Time;
import oracle.bpm.log.Log;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.DefaultProjectObject;
import oracle.bpm.project.model.MonthlySchedule;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.ScheduleEntry;
import oracle.bpm.project.model.ScheduleType;
import oracle.bpm.project.model.WeeklySchedule;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.xml.XmlWriter;
import org.jetbrains.annotations.NotNull;

public class Schedule
extends DefaultProjectObject
implements ProjectObject.Mutable,
Serializable {
    private ProjectObject parent;
    private Project project;
    private boolean runsOnHolidays = true;
    private List<ScheduleEntry> scheduleEntries = new ArrayList<ScheduleEntry>();
    static final long serialVersionUID = -3888301088723158795L;
    private static final String TAG_NAME = "schedule";
    private static final String START_TAG = "<schedule>";
    private static final String END_TAG = "</schedule>";
    static final long serialCheck = -6616088769855489659L;

    public Schedule() {
    }

    public Schedule(Project project) {
        this();
        this.project = project;
    }

    public Schedule(Schedule schedule) {
        this(schedule.getProject());
        this.parent = schedule.getParentObject();
        this.runsOnHolidays = schedule.getRunsOnHolidays();
        this.addScheduleEntries(schedule);
    }

    @Override
    public void setReadOnly(boolean value) {
        super.setReadOnly(value);
    }

    public void setParentObject(ProjectObject projectObject) {
        this.parent = projectObject;
    }

    public boolean isEmpty() {
        return this.getScheduleEntries().isEmpty();
    }

    public void setRunsOnHolidays(boolean value) {
        this.runsOnHolidays = value;
        for (int i = 0; i < this.getScheduleEntries().size(); ++i) {
            ScheduleEntry entry = this.getScheduleEntries().get(i);
            entry.setRunsOnHolidays(this.runsOnHolidays);
        }
    }

    public boolean getRunsOnHolidays() {
        return this.runsOnHoliday();
    }

    public String getString() {
        StringWriter sw = new StringWriter();
        XmlWriter xml = new XmlWriter((Writer)sw, "UTF-8");
        try {
            this.writeXml(xml);
        }
        catch (IOException e) {
            Log.logWarning((Throwable)e);
        }
        return sw.toString();
    }

    public boolean add(ScheduleEntry sr) {
        return this.getScheduleEntries().add(sr);
    }

    public void clear() {
        this.getScheduleEntries().clear();
    }

    public ScheduleEntry first() {
        return this.getScheduleEntries().isEmpty() ? null : this.getScheduleEntries().get(0);
    }

    public ScheduleEntry get(int index) {
        return this.getScheduleEntries().get(index);
    }

    public Iterator iterator() {
        return this.getScheduleEntries().iterator();
    }

    public Time nextDueTime(TimeZone timeZone) {
        return this.nextDueTime(timeZone, Time.now());
    }

    public Time nextDueTime(TimeZone timeZone, Time base) {
        Time result = Time.MAX_VALUE;
        TimeZone oldTimeZone = Time.getTimeZone();
        Time.setTimeZone((TimeZone)timeZone);
        for (ScheduleEntry scheduleEntry : this.getScheduleEntries()) {
            Time dueTime = scheduleEntry.nextDueTime(base);
            if (dueTime.compareTo(result) >= 0 || dueTime.compareTo(base) <= 0) continue;
            result = dueTime;
        }
        Time.setTimeZone((TimeZone)oldTimeZone);
        return result != Time.MAX_VALUE ? result : null;
    }

    public void remove(int row) {
        this.getScheduleEntries().remove(row);
    }

    public void reset(ScheduleType type) {
        this.getScheduleEntries().clear();
        this.getScheduleEntries().add(type.createSchedule());
    }

    public boolean runsOnHoliday() {
        ScheduleEntry schedule = this.first();
        return schedule != null && schedule.getRunsOnHolidays();
    }

    public int size() {
        return this.getScheduleEntries().size();
    }

    public void sort() {
        TreeSet<ScheduleEntry> set = new TreeSet<ScheduleEntry>();
        for (ScheduleEntry scheduleEntry : this.getScheduleEntries()) {
            set.add(scheduleEntry);
        }
        this.getScheduleEntries().clear();
        for (ScheduleEntry scheduleEntry : set) {
            this.getScheduleEntries().add(scheduleEntry);
        }
    }

    public void writeXml(XmlWriter xml) throws IOException {
        xml.startElement(TAG_NAME);
        for (ScheduleEntry scheduleEntry : this.getScheduleEntries()) {
            scheduleEntry.writeXml(xml);
        }
        xml.endElement();
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        visitor.visit(this);
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    @Deprecated
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.SCHEDULE;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    public Path getPath() {
        return null;
    }

    @Override
    public ProjectObject getParentObject() {
        return this.parent;
    }

    @Override
    public void replace(ProjectObject newObject) throws ProjectException {
    }

    public boolean isModified() {
        return false;
    }

    public List<ScheduleEntry> getScheduleEntries() {
        return this.scheduleEntries;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public void setId(String id) {
    }

    public void setModified(boolean value) {
    }

    @Override
    public void setDefault(boolean isDefault) {
    }

    @Override
    public void delete() throws ProjectException {
    }

    @Override
    public String getName() {
        return this.getId();
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public Class getRawClass() {
        return ProjectObject.class;
    }

    @Override
    public boolean is(Class<? extends ProjectObject> clazz) {
        return clazz.isAssignableFrom(this.getRawClass());
    }

    static Schedule valueOf(String schedule) {
        StringTokenizer tokenizer = new StringTokenizer(schedule, "\n");
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase(START_TAG)) {
            throw new FormatException(CoreMsg.INVALID_SCHEDULE((String)schedule));
        }
        Schedule result = new Schedule();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equalsIgnoreCase(END_TAG)) {
                return result;
            }
            result.add(ScheduleEntry.valueOf(token));
        }
        throw new FormatException(CoreMsg.INVALID_SCHEDULE((String)schedule));
    }

    private void addScheduleEntries(Schedule schedule) {
        for (ScheduleEntry entry : schedule.getScheduleEntries()) {
            ScheduleEntry newEntry = null;
            if (entry.getType() == ScheduleType.DAILY) {
                newEntry = ScheduleEntry.createDaily(entry.getWhen(), entry.getRunsOnHolidays());
            } else if (entry.getType() == ScheduleType.WEEKLY) {
                WeeklySchedule weeklyEntry = (WeeklySchedule)entry;
                newEntry = ScheduleEntry.createWeekly(weeklyEntry.getDayOfWeek(), entry.getWhen(), entry.getRunsOnHolidays());
            } else if (entry.getType() == ScheduleType.MONTHLY) {
                MonthlySchedule monthEntry = (MonthlySchedule)entry;
                newEntry = ScheduleEntry.createMonthly(monthEntry.getMonth(), monthEntry.getDayOfMonth(), entry.getWhen(), entry.getRunsOnHolidays());
            }
            this.scheduleEntries.add(newEntry);
        }
    }
}

