/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.exception.ProjectException;

public abstract class DefaultProjectObject
implements ProjectObject,
Adaptable {
    private List<Object> adapters;
    private boolean deletable = true;
    private boolean readOnly;

    @Override
    public void setId(String id) {
    }

    @Override
    public void setDefault(boolean isDefault) {
    }

    @Override
    public void delete() throws ProjectException {
    }

    public void addAdapter(Object adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException();
        }
        if (this.adapters == null) {
            this.adapters = new ArrayList<Object>(2);
        }
        this.adapters.add(0, adapter);
    }

    public void cleanAdapters() {
        if (this.adapters != null) {
            this.adapters.clear();
        }
    }

    public <T> T as(Class<T> targetType) {
        T result = null;
        if (targetType.isAssignableFrom(this.getClass())) {
            result = targetType.cast(this);
        } else if (this.adapters != null) {
            for (Object adapter : this.adapters) {
                if (!targetType.isAssignableFrom(adapter.getClass())) continue;
                result = targetType.cast(adapter);
                break;
            }
        }
        return result;
    }

    @Override
    public boolean isDescendantOf(ProjectObject projectObject) {
        return this.equals(projectObject) || this.getParentObject() != null && this.getParentObject().isDescendantOf(projectObject);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isDeletable() {
        return this.deletable;
    }

    @Override
    public void setDeletable(boolean deletable) {
        this.deletable = deletable;
    }

    @Override
    public int getPosition() {
        return -1;
    }

    @Override
    public ResourceObject findResourceObject() {
        if (this instanceof ResourceObject) {
            return (ResourceObject)((Object)this);
        }
        return this.getParentObject() != null ? this.getParentObject().findResourceObject() : null;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public boolean is(Class<? extends ProjectObject> clazz) {
        return clazz.isAssignableFrom(this.getRawClass());
    }

    @Override
    public void setReadOnly(boolean value) {
        this.readOnly = value;
    }

    public void afterAdd(ProjectObjectContainer container) throws ProjectException {
    }

    public void afterRemove(ProjectObjectContainer container) throws ProjectException {
    }
}

