/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model;

import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.ScheduleEntry;
import oracle.bpm.project.model.ScheduleType;
import oracle.bpm.project.model.exception.ProjectException;

public class DailySchedule
extends ScheduleEntry {
    static final long serialVersionUID = 1299278201968048764L;
    static final long serialCheck = -7652661446715325347L;

    protected DailySchedule(Interval when, boolean runsOnHolidays) {
        super(when, runsOnHolidays);
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        visitor.visit(this);
    }

    @Override
    public ScheduleType getType() {
        return ScheduleType.DAILY;
    }

    @Override
    public Time nextDueTime(Time base) {
        Time dueTime = this.establishWhen(base);
        if (base.compareTo(dueTime) >= 0) {
            dueTime = dueTime.addDays(1);
        }
        return dueTime;
    }

    static ScheduleEntry create() {
        return new DailySchedule(Interval.ZERO, true);
    }
}

