/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model;

import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.resources.Labeled;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum CompositeServiceType implements Labeled
{
    BPMN("BPMN", ProjectModelMsg.BPMN_COMPONENT),
    WEB_SERVICE("WebServices", ProjectModelMsg.WEB_SERVICE),
    BPEL("BPEL", ProjectModelMsg.BPEL_COMPONENT),
    MEDIATOR("Mediator", ProjectModelMsg.MEDIATOR_COMPONENT),
    CEP("CEP", ProjectModelMsg.CEP_COMPONENT),
    HUMAN_TASK("workflow", ProjectModelMsg.HUMAN_TASK_COMPONENT),
    BUSINESS_RULE("decision", ProjectModelMsg.BUSINESS_RULE_COMPONENT),
    EVENT_AGENT("EventAgent", ProjectModelMsg.EVENT_AGENT_COMPONENT),
    UNKNOWN("Unknown", ProjectModelMsg.UNKNOWN_COMPONENT);

    private String serviceType;
    private Msg msg;

    private CompositeServiceType(String serviceType, Msg msg) {
        this.serviceType = serviceType;
        this.msg = msg;
    }

    @NotNull
    public static CompositeServiceType parse(@Nullable String type) {
        CompositeServiceType[] types = CompositeServiceType.values();
        CompositeServiceType result = WEB_SERVICE;
        if (type != null) {
            for (CompositeServiceType referenceType : types) {
                String fixedName = type.replaceAll(" ", "");
                if (!referenceType.serviceType.equalsIgnoreCase(fixedName)) continue;
                result = referenceType;
                break;
            }
        }
        return result;
    }

    public Msg getLabel() {
        return this.msg;
    }

    @NotNull
    public String getServiceType() {
        return this.serviceType;
    }
}

