/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xml;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.lang.Id;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Literals;
import oracle.bpm.lang.Str;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.util.Base64;
import oracle.bpm.xml.XmlWriterException;
import org.jetbrains.annotations.NonNls;

public class XmlWriter
implements Closeable {
    private boolean charsAreMultiline = false;
    private int currentTag;
    private CharsetEncoder encoder;
    private String encoding;
    private boolean forceStore;
    private boolean hasAttributes = false;
    private boolean hasChars = false;
    private boolean hasElements = false;
    private String indent = "";
    private boolean indentAttributes = false;
    private char indentChar = (char)9;
    private boolean indentNameAttribute = false;
    private boolean startClosed = true;
    private String[] tagStack;
    private Writer target;
    private static final char STARTING_TAG_START = '<';
    private static final char STARTING_TAG_END = '>';
    private static final String ENDING_TAG_START = "</";
    private static final String ENDING_TAG_END = ">\n";
    private static final String COMMENT_END = "-->";
    private static final String COMMENT_START = "<!--";
    private static final char ATTRIBUTE_VALUE_END = '\"';
    private static final String ATTRIBUTE_VALUE_START = "=\"";
    private static final char LINE_DELIMITER = '\n';
    private static final String STR_NAME = "name";
    @NonNls
    private static final String ESCAPED_CDATA_START = "<\\!\\[CDATA\\[";
    @NonNls
    private static final String ESCAPED_CDATA_END = "\\]\\]>";
    @NonNls
    static final String CDATA_START = "#C#D#A#T#A#";
    @NonNls
    static final String CDATA_END = "#]#]#";

    @Deprecated
    public XmlWriter(Writer target) {
        this(target, null);
    }

    public XmlWriter(Writer target, String encoding) {
        assert (XmlWriter.checkEncoding(target, encoding));
        this.setEncoding(encoding);
        this.target = target;
        this.tagStack = new String[32];
        Charset charset = Charset.forName(this.encoding);
        this.encoder = charset.newEncoder();
    }

    public XmlWriter(OutputStream outputStream, String encoding) throws UnsupportedEncodingException {
        this(new OutputStreamWriter(outputStream, encoding), encoding);
    }

    public static void main(String[] args) throws Exception {
        XmlWriter xml = new XmlWriter(new OutputStreamWriter(System.out), "UTF-8");
        xml.startElement("class");
        xml.startElement("inherit");
        xml.printAttribute("class", "x");
        xml.endElement();
        xml.startElement("method");
        xml.printAttribute(STR_NAME, "pepe");
        xml.startElement("description");
        xml.printChars("This is a description");
        xml.endElement();
        xml.startElement("arg");
        xml.printAttribute(STR_NAME, "arg0");
        xml.printAttribute("type", "String");
        xml.endElement();
        xml.endElement();
        xml.endElement();
        xml.close();
    }

    public static String replaceCDATA(String data) {
        data = data.replaceAll(CDATA_START, "<![CDATA[");
        data = data.replaceAll(CDATA_END, "]]>");
        return data;
    }

    public void setIgnoreEmpty(boolean ignore) {
        this.forceStore = !ignore;
    }

    public void setIndentAttributes(boolean indentAttributes) {
        this.indentAttributes = indentAttributes;
    }

    public void setIndentNameAttribute(boolean indentNameAttribute) {
        this.indentNameAttribute = indentNameAttribute;
    }

    @Override
    public void close() throws IOException {
        if (this.currentTag > 0) {
            throw new XmlWriterException(CoreMsg.OPEN_TAGS(this.currentTag));
        }
        this.target.close();
    }

    public void endElement() throws IOException {
        this.reduceIndent();
        String tag = this.popTag();
        if (this.hasElements || this.hasChars) {
            if (this.hasElements || this.charsAreMultiline) {
                this.target.write(this.indent);
            }
            this.target.write(ENDING_TAG_START);
            this.target.write(tag);
            this.target.write(ENDING_TAG_END);
        } else {
            this.target.write("/>\n");
            this.startClosed = true;
        }
        this.hasChars = false;
        this.charsAreMultiline = false;
        this.hasElements = true;
    }

    public void flush() throws IOException {
        this.target.flush();
    }

    public void printAttribute(String name, boolean value, boolean defValue) throws IOException {
        if (this.forceStore || value != defValue) {
            this.printAttribute(name, String.valueOf(value));
        }
    }

    public void printAttribute(String name, Interval value) throws IOException {
        this.printAttribute(name, value == null ? null : value.toXMLString());
    }

    public void printAttribute(String name, BigDecimal value) throws IOException {
        this.printAttribute(name, value == null ? null : value.toString());
    }

    public void printAttribute(@NonNls String name, boolean value) throws IOException {
        this.printAttribute(name, value, false);
    }

    public void printAttribute(String name, int value, int defValue) throws IOException {
        if (this.forceStore || value != defValue) {
            this.printAttributeForced(name, value);
        }
    }

    public void printAttribute(String name, Enum value) throws IOException {
        this.printAttribute(name, value == null ? null : value.toString());
    }

    public void printAttribute(@NonNls String name, int value) throws IOException {
        this.printAttribute(name, value, 0);
    }

    public void printAttribute(String name, double value, double defValue) throws IOException {
        if (this.forceStore || value != defValue) {
            this.printAttribute(name, String.valueOf(value));
        }
    }

    public void printAttribute(String name, double value) throws IOException {
        this.printAttribute(name, value, 0.0);
    }

    public void printAttribute(String name, long value, long defValue) throws IOException {
        if (this.forceStore || value != defValue) {
            this.printAttribute(name, String.valueOf(value));
        }
    }

    public void printAttribute(String name, long value) throws IOException {
        this.printAttribute(name, value, 0L);
    }

    public void printAttribute(String name, String value, String defValue) throws IOException {
        if (this.forceStore || value == null || !value.equals(defValue)) {
            this.printAttribute(name, value);
        }
    }

    public void printAttribute(@NonNls String name, String value) throws IOException {
        if (this.startClosed) {
            throw new XmlWriterException(CoreMsg.ATTRIBUTE_WITHOUT_TAG(name));
        }
        if (value != null) {
            boolean processNameAtt;
            boolean bl = processNameAtt = name.equals(STR_NAME) && !this.hasAttributes;
            if (!processNameAtt && this.indentAttributes || processNameAtt && this.indentNameAttribute) {
                this.target.write(10);
                this.target.write(this.indent);
            } else {
                this.target.write(32);
            }
            this.target.write(name);
            this.target.write(ATTRIBUTE_VALUE_START);
            this.target.write(Str.toXMLString(value));
            this.target.write(34);
            this.hasAttributes = true;
        }
    }

    public void printAttributeForced(String name, int value) throws IOException {
        this.printAttribute(name, String.valueOf(value));
    }

    public void printComment(String comment) throws IOException {
        if (comment == null) {
            comment = "";
        }
        this.printChars(COMMENT_START + comment + COMMENT_END, true, false, false);
    }

    public void printLocalizedElements(String tag, LocaleStringMap messageMap) throws IOException {
        this.printLocalizedElements(tag, messageMap, false);
    }

    public void printLocalizedElements(String tag, LocaleStringMap messageMap, boolean encoded) throws IOException {
        for (Map.Entry<Locale, String> entry : messageMap.entrySet()) {
            this.printLocalizedElement(tag, entry.getKey().getLanguage(), entry.getValue(), encoded);
        }
    }

    public void printTags(String data) throws IOException {
        if (Str.isEmpty(data)) {
            return;
        }
        this.closePreviousTag();
        this.target.write(this.indent);
        this.target.write(data);
    }

    public void printValuedElement(String tag, String value) throws IOException {
        if (Str.isEmpty(value)) {
            return;
        }
        this.closePreviousTag();
        this.hasElements = true;
        this.target.write(this.indent);
        this.target.write(60);
        this.target.write(tag);
        this.target.write(62);
        this.printChars(value, false, true, false);
        this.target.write(ENDING_TAG_START);
        this.target.write(tag);
        this.target.write(ENDING_TAG_END);
    }

    public void printValuedElement(String tag, String value, String defValue) throws IOException {
        if (value != null && !value.equals(defValue)) {
            this.printValuedElement(tag, value);
        }
    }

    public void printXMLCDATA(String data) throws IOException {
        if (Str.isEmpty(data)) {
            return;
        }
        data = data.replaceAll(ESCAPED_CDATA_START, CDATA_START);
        data = data.replaceAll(ESCAPED_CDATA_END, CDATA_END);
        this.printCDATA(data, false);
    }

    public void printCDATAElement(String tag, String data) throws IOException {
        this.printCDATAElement(tag, data, false);
    }

    public void printCDATAElement(String tag, String data, boolean indented) throws IOException {
        if (data != null) {
            this.closePreviousTag();
            this.target.write(this.indent);
            this.target.write(60);
            this.target.write(tag);
            this.target.write(62);
            this.printCDATA(data, indented);
            if (indented) {
                this.target.write(this.indent);
            }
            this.target.write(ENDING_TAG_START);
            this.target.write(tag);
            this.target.write(ENDING_TAG_END);
        }
    }

    public void printChars(String data) throws IOException {
        this.printChars(data, false);
    }

    public void printChars(String data, boolean multiLine) throws IOException {
        this.printChars(data, multiLine, true, false);
    }

    public void printChars(String data, boolean multiLine, boolean escape, boolean addNewLine) throws IOException {
        if (data == null || data.length() == 0) {
            return;
        }
        data = escape ? Str.toXMLString(data, this.encoder) : data;
        this.closePreviousTag(multiLine);
        if (addNewLine && !this.hasElements) {
            this.target.write(10);
        }
        if (!multiLine) {
            this.target.write(data);
        } else {
            this.increaseIndent();
            this.target.write(this.indent);
            int end = data.length() - 1;
            if (data.charAt(end) == '\n') {
                while (data.charAt(--end) == '\n') {
                }
                data = data.substring(0, end + 1);
            }
            this.target.write(Str.replace(data, "\n", '\n' + this.indent));
            this.target.write(10);
            this.charsAreMultiline = true;
            this.reduceIndent();
        }
        if (addNewLine) {
            this.target.write(10);
            this.charsAreMultiline = true;
        }
        this.hasChars = true;
    }

    public void printIndentedCDATAElement(String tag, String data) throws IOException {
        if (data == null || data.length() == 0) {
            return;
        }
        this.closePreviousTag();
        this.hasElements = true;
        this.target.write(this.indent);
        this.target.write(60);
        this.target.write(tag);
        this.target.write(62);
        this.target.write("<![CDATA[\n");
        this.printChars(data, true, false, false);
        this.target.write(this.indent);
        this.target.write("]]>\n");
        this.target.write(this.indent);
        this.target.write(ENDING_TAG_START);
        this.target.write(tag);
        this.target.write(ENDING_TAG_END);
    }

    public void println() throws IOException {
        this.target.write("\n");
    }

    public void startDocument() throws IOException {
        this.target.write(Id.getXmlProcessingInstructionLine(this.encoding));
        this.target.write(Id.getFuegoProcessingInstructionLine());
    }

    @Deprecated
    public void startDocument(String encoding) throws IOException {
        this.setEncoding(encoding);
        this.startDocument();
    }

    public void startElement(@NonNls String name) throws IOException {
        this.closePreviousTag();
        this.pushTag(name);
        this.target.write(this.indent);
        this.target.write(60);
        this.target.write(this.peekTag());
        this.startClosed = false;
        this.hasElements = false;
        this.hasAttributes = false;
        this.increaseIndent();
    }

    public void printCDATA(String data, boolean indented, boolean escape) throws IOException {
        if (data != null) {
            int i;
            this.printChars("<![CDATA[", false, false, false);
            if (indented) {
                this.target.write(10);
            }
            if (escape && (i = data.indexOf("]]>")) != -1) {
                String escaped = Str.toXMLString("]]>", this.encoder);
                data = data.replaceAll("]]>", escaped);
            }
            this.printChars(data, indented, false, false);
            this.printChars("]]>", indented, false, false);
        }
    }

    private static boolean checkEncoding(Writer target, String encoding) {
        if (encoding != null && target instanceof OutputStreamWriter) {
            String targetEncoding = ((OutputStreamWriter)target).getEncoding();
            assert (XmlWriter.sameEncoding(targetEncoding, encoding)) : "Encoding argument[" + encoding + "] != OutputStreamWriter encoding[" + targetEncoding + ']';
        }
        return true;
    }

    private static boolean sameEncoding(String e, String encoding) {
        return Charset.forName(e).compareTo(Charset.forName(encoding)) == 0;
    }

    private void setEncoding(String encoding) {
        if (encoding == null) {
            encoding = Literals.DEFAULT_ENCODING;
        }
        this.encoding = encoding;
    }

    private void closePreviousTag() throws IOException {
        this.closePreviousTag(true);
    }

    private void closePreviousTag(boolean addNewLine) throws IOException {
        if (!this.startClosed && this.currentTag != 0) {
            this.target.write(">");
            if (addNewLine) {
                this.target.write(10);
            }
        }
        this.startClosed = true;
        this.hasChars = false;
    }

    private void increaseIndent() {
        this.indent = this.indent + this.indentChar;
    }

    private String peekTag() {
        return this.tagStack[this.currentTag - 1];
    }

    private String popTag() throws XmlWriterException {
        if (this.currentTag == 0) {
            throw new XmlWriterException(CoreMsg.POP_TAG_ERR);
        }
        return this.tagStack[--this.currentTag];
    }

    private void printCDATA(String data, boolean indented) throws IOException {
        this.printCDATA(data, indented, true);
    }

    private void printLocalizedElement(String tag, String langId, String text, boolean encoded) throws IOException {
        if (text != null && text.length() != 0) {
            this.startElement(tag);
            this.printAttribute("language", langId);
            if (encoded) {
                this.printChars(Base64.encode(text.getBytes()));
            } else {
                this.printChars(text.trim());
            }
            this.endElement();
        }
    }

    private void pushTag(String tag) {
        if (this.currentTag == this.tagStack.length) {
            String[] newStack = new String[this.currentTag * 2];
            System.arraycopy(this.tagStack, 0, newStack, 0, this.currentTag);
            this.tagStack = newStack;
        }
        this.tagStack[this.currentTag++] = tag;
    }

    private void reduceIndent() throws XmlWriterException {
        if (this.indent.length() == 0) {
            throw new XmlWriterException(CoreMsg.INDENT_ERROR(this.currentTag));
        }
        this.indent = this.indent.substring(1);
    }
}

