/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xml;

public class XmlId {
    private static final int[] BASE_CHAR = new int[]{5898305, 7995489, 14024896, 16122072, 0xFF00F8, 0x1310100, 20840756, 21496129, 25035082, 29557120, 32506317, 32834036, 35062266, 44565072, 46203579, 902, 59376520, 908, 60883854, 63832995, 64357328, 986, 988, 990, 992, 66257890, 67896321, 72287246, 73139281, 75564126, 79955088, 80217287, 80479435, 82511056, 83166446, 83428600, 89523505, 1369, 92669281, 99222992, 99747312, 104465953, 105514561, 112658033, 113116858, 114165440, 114493136, 1749, 115738341, 154732805, 2365, 157354328, 160172421, 160434575, 162007443, 162531754, 2482, 163121590, 165480924, 165743071, 166791664, 0xA0A0A05, 168823311, 170396179, 170920490, 171117106, 171313717, 171510328, 173804121, 2654, 175377010, 176884357, 2701, 177277583, 178784915, 0xAB00AAA, 179505842, 179899061, 2749, 2784, 185338629, 185600783, 187173651, 187697962, 187894578, 188287798, 2877, 190647132, 190909279, 193596293, 193989518, 194317202, 194644889, 2972, 194972574, 195300259, 195693480, 196414382, 196676535, 0xC0C0C05, 202378254, 203951122, 204672042, 205065269, 207686752, 210504837, 210766990, 212339858, 213060778, 213454005, 3294, 216075488, 218893573, 219155726, 220728594, 221842730, 224464224, 237899265, 3632, 238226994, 239406656, 243404417, 3716, 243797639, 3722, 3725, 244780692, 245304985, 245567137, 3749, 3751, 246091434, 246288045, 3760, 246615730, 3773, 247729856, 256315200, 258543433, 281350304, 284561616, 4352, 285413634, 285675781, 4361, 286003467, 286396686, 4412, 4414, 4416, 4428, 4430, 4432, 0x11551154, 4441, 291574111, 4451, 4453, 4455, 4457, 292426093, 292753778, 4469, 4510, 4520, 4523, 296685998, 297275831, 4538, 297931196, 4587, 4592, 4601, 513482240, 519642784, 521477888, 522002200, 524623648, 525147976, 525803344, 8025, 8027, 8029, 528293727, 531898240, 532422582, 8126, 532946882, 533471174, 533929936, 534454230, 535568352, 536092658, 536616950, 8486, 556474666, 8494, 562176384, 815018049, 821702817, 824979717, -677139456};
    private static final int[] IDEOGRAPHIC = new int[]{12295, 808005665, -1616556544};
    private static final int[] COMBINING = new int[]{54854400, 56689504, 75891843, 94438801, 96011683, 96273851, 1471, 96601537, 1476, 106038859, 1648, 115082966, 115279581, 115607264, 115869415, 116197098, 151193857, 2364, 155978046, 2381, 156502353, 157485410, 159582593, 2492, 2494, 2495, 163842496, 164104647, 164432331, 2519, 165874146, 2562, 2620, 2622, 2623, 172100160, 172493383, 172821067, 175180400, 176360065, 2748, 180685502, 180947655, 181209803, 184748801, 2876, 188943166, 189270855, 189598539, 190253910, 193137538, 197266366, 197659590, 197987274, 3031, 201526273, 205786174, 206048326, 206376010, 206965845, 209915010, 214174910, 214437062, 214764746, 215354581, 218303746, 222498110, 222825798, 223153482, 3415, 3633, 238685748, 239996487, 3761, 247008948, 247205563, 248319688, 253300504, 3893, 3895, 3897, 3902, 3903, 260312945, 260771718, 261427088, 3991, 262999961, 263655345, 4025, 551297232, 8417, 808398890, 12441, 12442};
    private static final int[] DIGIT = new int[]{0x390030, 0x6690660, 116983536, 158271846, 166660582, 175049318, 183438054, 191826790, 200215527, 208604262, 216992998, 225381734, 240717392, 249106128, 254349088};
    private static final int[] EXTENDER = new int[]{183, 720, 721, 903, 1600, 3654, 3782, 12293, 808792113, 815673501, 821965052};

    public static boolean isBaseChar(char c) {
        return XmlId.belongsTo(c, BASE_CHAR);
    }

    public static boolean isCombining(char c) {
        return XmlId.belongsTo(c, COMBINING);
    }

    public static boolean isDigit(char c) {
        return XmlId.belongsTo(c, DIGIT);
    }

    public static boolean isExtender(char c) {
        return XmlId.belongsTo(c, EXTENDER);
    }

    public static boolean isIdeographic(char c) {
        return XmlId.belongsTo(c, IDEOGRAPHIC);
    }

    public static boolean isLetter(char c) {
        return XmlId.isBaseChar(c) || XmlId.isIdeographic(c);
    }

    public static boolean isName(CharSequence s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if ((i != 0 || XmlId.isNameStart(c)) && (i == 0 || XmlId.isNameChar(c))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNameChar(char c) {
        return XmlId.isLetter(c) || XmlId.isDigit(c) || c == '.' || c == '-' || c == '_' || c == ':' || XmlId.isCombining(c) || XmlId.isExtender(c);
    }

    public static boolean isNameStart(char c) {
        return XmlId.isLetter(c) || c == '_' || c == ':';
    }

    public static String escape(String s) {
        StringBuffer buffer = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (i == 0) {
                XmlId.makeNameStart(buffer, c);
                continue;
            }
            XmlId.makeNameChar(buffer, c);
        }
        return buffer.toString();
    }

    public static String unescape(String s) {
        StringBuffer buffer = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '_') {
                if ((c = s.charAt(++i)) == '_') {
                    buffer.append('_');
                    continue;
                }
                StringBuffer number = new StringBuffer();
                number.append(c);
                number.append(s.charAt(++i));
                number.append(s.charAt(++i));
                number.append(s.charAt(++i));
                buffer.append((char)Integer.parseInt(number.toString(), 16));
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    private static boolean belongsTo(char c, int[] characterClass) {
        int low = 0;
        int high = characterClass.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            char midVal = (char)(characterClass[mid] & 0xFFFF);
            if (midVal < c) {
                low = mid + 1;
                continue;
            }
            if (midVal > c) {
                high = mid - 1;
                continue;
            }
            return true;
        }
        int range = 0;
        if (low > 0) {
            range = characterClass[low - 1];
        }
        char rangeLow = (char)(range & 0xFFFF);
        char rangeHigh = (char)(range >>> 16);
        return rangeHigh != '\u0000' && rangeLow <= c && rangeHigh >= c;
    }

    private static boolean checkTable(int[] table) {
        int last = 0;
        for (int i = 0; i < table.length; ++i) {
            int range = table[i];
            char low = (char)(range & 0xFFFF);
            char high = (char)(range >>> 16);
            if (low >= high && high != '\u0000' || (char)(last & 0xFFFF) >= low || (char)(last >>> 16) >= low) {
                return false;
            }
            last = range;
        }
        return true;
    }

    private static void makeNameChar(StringBuffer buf, char c) {
        if (XmlId.isNameChar(c) && c != '_') {
            buf.append(c);
        } else if (c == '_') {
            buf.append('_');
            buf.append('_');
        } else {
            buf.append('_');
            String val = Integer.toHexString(c);
            for (int i = 4 - val.length(); i > 0; --i) {
                buf.append('0');
            }
            buf.append(val);
        }
    }

    private static void makeNameStart(StringBuffer buf, char c) {
        if (XmlId.isNameStart(c) && c != '_') {
            buf.append(c);
        } else if (c == '_') {
            buf.append('_');
            buf.append('_');
        } else {
            buf.append('_');
            String val = Integer.toHexString(c);
            for (int i = 4 - val.length(); i > 0; --i) {
                buf.append('0');
            }
            buf.append(val);
        }
    }

    static {
        assert (XmlId.checkTable(BASE_CHAR)) : "BASE_CHAR table does not pass the ordering tests";
        assert (XmlId.checkTable(IDEOGRAPHIC)) : "IDEOGRAPHIC table does not pass the ordering tests";
        assert (XmlId.checkTable(COMBINING)) : "COMBINING table does not pass the ordering tests";
        assert (XmlId.checkTable(DIGIT)) : "DIGIT table does not pass the ordering tests";
        assert (XmlId.checkTable(EXTENDER)) : "EXTENDER table does not pass the ordering tests";
    }
}

