/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xml;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.bpm.lang.exception.ProgramException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlHelper {
    private XmlHelper() {
    }

    public static Document parseXmlFile(File file, boolean validating) {
        return XmlHelper.parseXmlFile(file, validating, null);
    }

    public static Document parseXmlFile(File file, boolean validating, EntityResolver entityResolver) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validating);
            InputSource inputSource = new InputSource(new FileReader(file));
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            if (entityResolver != null) {
                documentBuilder.setEntityResolver(entityResolver);
            }
            return documentBuilder.parse(inputSource);
        }
        catch (SAXException e) {
            throw ProgramException.wrap("Error parsing the xml file", e).addInfo("file", file.getAbsolutePath());
        }
        catch (ParserConfigurationException e) {
            throw ProgramException.wrap("Error parsing the xml file", e).addInfo("file", file.getAbsolutePath());
        }
        catch (IOException e) {
            throw ProgramException.wrap("Error parsing the xml file", e).addInfo("file", file.getAbsolutePath());
        }
    }

    public static void writeXmlFile(Document doc, File file) {
        try {
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            XmlHelper.writeXmlFile(xformer, doc, file);
        }
        catch (TransformerConfigurationException e) {
            throw ProgramException.wrap("Error on transforming the xml to write", e).addInfo("file", file.getAbsolutePath());
        }
    }

    public static void writeXmlFile(Transformer xformer, Document doc, File file) {
        try {
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(file);
            if (doc.getDoctype() != null) {
                String systemValue = doc.getDoctype().getSystemId();
                xformer.setOutputProperty("doctype-system", systemValue);
                String pubValue = doc.getDoctype().getPublicId();
                xformer.setOutputProperty("doctype-public", pubValue);
            }
            xformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw ProgramException.wrap("Error on transforming the xml to write", e).addInfo("file", file.getAbsolutePath());
        }
    }
}

