/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xml;

import java.math.BigDecimal;
import java.util.IdentityHashMap;
import java.util.Map;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.Time;
import oracle.bpm.util.Base64;
import oracle.bpm.xml.Serializer;
import oracle.bpm.xml.XMLSerializerWriter;
import org.jetbrains.annotations.NonNls;

public class BaseSerializer
implements Serializer,
oracle.bpm.lang.Serializer {
    protected XMLSerializerWriter writer_d;
    private static final ThreadLocal<IdentityHashMap<DynamicObject, Integer>> threadLocalMap_d = new ThreadLocal();
    private static final ThreadLocal<Integer> threadLocalMapCount_d = new ThreadLocal();

    @Override
    public final void serialize(XMLSerializerWriter writer, String objName, DynamicObject dobj) {
        threadLocalMap_d.set(new IdentityHashMap());
        threadLocalMapCount_d.set(Integer.valueOf("1"));
        this.writer_d = writer;
        this.serialize(objName, dobj);
        threadLocalMap_d.set(null);
    }

    @Override
    public final void serialize(XMLSerializerWriter writer, String objName, Object object) {
        threadLocalMap_d.set(new IdentityHashMap());
        threadLocalMapCount_d.set(1);
        this.writer_d = writer;
        this.serialize(objName, DynamicObject.valueOf(object, true));
        threadLocalMap_d.set(null);
    }

    @Override
    public final void serializeBinary(byte[] value) {
        this.writer_d.print(Base64.encode(value));
    }

    @Override
    public final void serializeBoolean(boolean value) {
        this.writer_d.print(Boolean.valueOf(value).toString());
    }

    @Override
    public final void serializeComposite(DynamicObject map) {
        this.writer_d.indent();
        for (Map.Entry<String, Object> entry : map.asFieldsMap().entrySet()) {
            this.writer_d.println();
            this.serialize(entry.getKey(), (DynamicObject)entry.getValue());
        }
        this.writer_d.dedent();
    }

    @Override
    public final void serializeDecimal(BigDecimal value) {
        this.writer_d.print(value.toString());
    }

    @Override
    public final void serializeInt(long value) {
        this.writer_d.print(String.valueOf(value));
    }

    @Override
    public final void serializeInterval(Interval value) {
        this.writer_d.print(value.toXMLString());
    }

    @Override
    public final void serializeList(DynamicObject list) {
        this.writer_d.indent();
        int size = list.asList().size();
        for (int i = 0; i < size; ++i) {
            this.serialize("element" + i, list.getElementAt(i));
        }
        this.writer_d.dedent();
    }

    @Override
    public final void serializeMap(DynamicObject map) {
        this.writer_d.indent();
        for (Map.Entry<DynamicObject, DynamicObject> entry : map.asAssociativeArray().entrySet()) {
            this.serialize("key", entry.getKey());
            this.serialize("value", entry.getValue());
        }
        this.writer_d.dedent();
    }

    @Override
    public final void serializeNull() {
    }

    @Override
    public final void serializeReal(double value) {
        this.writer_d.print(String.valueOf(value));
    }

    @Override
    public final void serializeString(String value) {
        this.writer_d.print(Str.toXMLString(value, this.writer_d.getCharsetEncoder()));
    }

    @Override
    public final void serializeTime(Time value) {
        this.writer_d.print(value.toXMLString());
    }

    protected final void serialize(@NonNls String name, DynamicObject dobj) {
        if (dobj.isAssociativeArray()) {
            this.writer_d.println("<" + name + " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type='map'>");
        } else if (dobj.isList()) {
            this.writer_d.println("<" + name + " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type='array'>");
        } else if (dobj.isBinary()) {
            this.writer_d.print("<" + name + " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type='SOAP-ENC:base64'>");
        } else if (dobj.isComposite() && dobj.getJavaClassName() != null) {
            IdentityHashMap<DynamicObject, Integer> map = threadLocalMap_d.get();
            Integer refId = map.get(dobj);
            if (refId != null) {
                String refName = name;
                if ("this$0".equals(name)) {
                    refName = "__outerInstance";
                }
                this.writer_d.print("<" + refName + " ref='" + refId + "'>");
                this.writer_d.println("</" + refName + ">");
                return;
            }
            Integer counter = threadLocalMapCount_d.get();
            this.writer_d.print("<" + name + " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type='" + dobj.getJavaClassName() + "' id='" + counter + "'>");
            map.put(dobj, counter);
            counter = counter + 1;
            threadLocalMapCount_d.set(counter);
        } else if (dobj.isInt()) {
            this.writer_d.print("<" + name + " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type='long'>");
        } else if (dobj.isReal()) {
            this.writer_d.print("<" + name + " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type='double'>");
        } else if (dobj.isBool()) {
            this.writer_d.print("<" + name + " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type='boolean'>");
        } else if (dobj == DynamicObject.NULL) {
            this.writer_d.print("<" + name + " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:null='1'>");
        } else {
            this.writer_d.print("<" + name + ">");
        }
        dobj.serialize(this);
        this.writer_d.println("</" + name + ">");
    }
}

